/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.NodeSettings;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.content.Content;
import com.intellij.util.NotNullProducer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmPackageProjectGenerator
extends WebProjectTemplate<Pair<NodeJsInterpreter, String>>
implements ProjectTemplate {
    private static final String ID = "none";
    private static final Logger LOG = Logger.getInstance(NpmPackageProjectGenerator.class);

    @NotNull
    protected abstract Filter[] filters(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    protected abstract String executable(String var1);

    @NotNull
    protected abstract String[] generatorArgs(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract void customizeModule(@NotNull VirtualFile var1, ContentEntry var2);

    @NotNull
    protected abstract String packageName();

    @NotNull
    protected abstract String presentablePackageName();

    private void generateApp(@NotNull NodeJsLocalInterpreter node, @NotNull String path, @NotNull VirtualFile baseDir, @NotNull Project project) throws IOException, ExecutionException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateApp"));
        }
        NpmPackageProjectGenerator.generate(node, this.executable(path), baseDir, this.workingDir(project, baseDir), project, this.postInstall(node, project, baseDir), this.filters(project, baseDir), this.generatorArgs(project, baseDir));
    }

    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        Runnable runnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$postInstall$1"));
            }
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$postInstall$1"));
            }
            if (!project.isDisposed()) {
                NpmScriptsService instance = NpmScriptsService.getInstance();
                List<VirtualFile> buildfiles = instance.detectAllBuildfiles(project);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$0"));
                    }
                    if (node == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$0"));
                    }
                    for (VirtualFile buildfile : buildfiles) {
                        instance.getFileManager(project).addBuildfile(buildfile);
                    }
                    NodeJsInterpreterManager.getInstance(project).setDefault(node);
                    instance.getToolWindowManager(project).setAvailable();
                });
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "postInstall"));
        }
        return runnable;
    }

    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull String path, final @NotNull VirtualFile baseDir, @NotNull VirtualFile workingDir, @NotNull Project project, final @Nullable Runnable callback, @NotNull Filter[] filters, String ... args) throws ExecutionException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        if (filters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filters", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generate"));
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add(node.getInterpreterSystemDependentPath());
        arguments.add(path);
        ContainerUtil.addAll(arguments, (Object[])args);
        GeneralCommandLine commandLine = new GeneralCommandLine(arguments);
        commandLine.setWorkDirectory(workingDir.getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        final KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project);
        builder.setUsePredefinedMessageFilter(false);
        for (Filter filter : filters) {
            builder.addFilter(filter);
        }
        ConsoleView console = builder.getConsole();
        console.attachToProcess((ProcessHandler)handler);
        ConsoleProgress.install(console, (ProcessHandler)handler);
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(ProcessEvent event) {
                baseDir.refresh(false, true);
                baseDir.getChildren();
                handler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                if (callback != null) {
                    ApplicationManager.getApplication().runReadAction(callback);
                }
            }
        });
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        String title = "Generating " + baseDir.getName();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(ID, title, title, (Disposable)project);
        Content consoleContent = ui.createContent(ID, console.getComponent(), title, null, console.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        RunContentDescriptor descriptor = new RunContentDescriptor((ExecutionConsole)console, (ProcessHandler)handler, console.getComponent(), title);
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(defaultExecutor, descriptor);
        handler.startNotify();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Pair<NodeJsInterpreter, String> settings, @NotNull Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "generateProject"));
        }
        NodeJsInterpreter interpreter = (NodeJsInterpreter)settings.first;
        NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(interpreter);
        assert (local != null);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$3"));
            }
            if (baseDir == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$3"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$3"));
            }
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$generateProject$3"));
            }
            try {
                this.generateApp(local, (String)settings.second, baseDir, project);
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
                this.customizeModule(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "lambda$null$2"));
                    }
                    model.commit();
                    project.save();
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<Pair<NodeJsInterpreter, String>> createPeer() {
        WebProjectGenerator.GeneratorPeer<Pair<NodeJsInterpreter, String>> generatorPeer = new WebProjectGenerator.GeneratorPeer<Pair<NodeJsInterpreter, String>>(){
            private NodeJsInterpreterField myInterpreter;
            private TextFieldWithHistoryWithBrowseButton myModule;

            @NotNull
            public JComponent getComponent() {
                Project project = ProjectManager.getInstance().getDefaultProject();
                JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
                this.myInterpreter = new NodeJsInterpreterField(project, false){

                    @Override
                    public boolean isDefaultProjectInterpreterField() {
                        return true;
                    }
                };
                this.myInterpreter.setInterpreter(NodeJsInterpreterManager.getInstance(project).getDefault());
                LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myInterpreter), (String)"Node &interpreter:");
                component.setLabelLocation("West");
                panel.add((Component)component);
                NotNullProducer producer = () -> {
                    ArrayList<String> dirs = new ArrayList<String>();
                    NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(this.myInterpreter.getInterpreter());
                    ArrayList modules = ContainerUtil.newArrayList();
                    NodeModuleSearchUtil.findModulesWithName(modules, NpmPackageProjectGenerator.this.packageName(), null, NodeSettings.create(local), true);
                    for (CompletionModuleInfo module : modules) {
                        VirtualFile dir = module.getVirtualFile();
                        if (dir == null || !dir.isDirectory()) continue;
                        dirs.add(FileUtil.toSystemDependentName((String)dir.getPath()));
                    }
                    Collections.sort(dirs);
                    return dirs;
                };
                this.myModule = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)("Select " + NpmPackageProjectGenerator.this.packageName() + " package"), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor(), (NotNullProducer)producer);
                String item = (String)ContainerUtil.getFirstItem((List)((List)producer.produce()));
                if (item != null) {
                    this.myModule.setText(item);
                }
                component = LabeledComponent.create((JComponent)this.myModule, (String)NpmPackageProjectGenerator.this.presentablePackageName());
                component.setAnchor((JComponent)panel.getComponent(0));
                component.setLabelLocation("West");
                panel.add((Component)component);
                JPanel jPanel = panel;
                if (jPanel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$2", "getComponent"));
                }
                return jPanel;
            }

            public void buildUI(@NotNull SettingsStep settingsStep) {
                if (settingsStep == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingsStep", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$2", "buildUI"));
                }
                this.getComponent();
                settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Node &interpreter:"), (JComponent)((Object)this.myInterpreter));
                settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)NpmPackageProjectGenerator.this.presentablePackageName()), (JComponent)this.myModule);
            }

            @NotNull
            public Pair<NodeJsInterpreter, String> getSettings() {
                Pair pair = Pair.create((Object)this.myInterpreter.getInterpreter(), (Object)this.myModule.getText());
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$2", "getSettings"));
                }
                return pair;
            }

            @Nullable
            public ValidationInfo validate() {
                NodeJsInterpreter interpreter = this.myInterpreter.getInterpreter();
                String error = NodeJsLocalInterpreter.getErrorMessage(interpreter);
                if (error != null) {
                    return new ValidationInfo(error);
                }
                String packageDir = this.myModule.getText();
                if (StringUtil.isEmptyOrSpaces((String)packageDir)) {
                    return new ValidationInfo("Please specify " + NpmPackageProjectGenerator.this.packageName() + " package");
                }
                File file = new File(packageDir);
                if (!file.isAbsolute() || !file.isDirectory()) {
                    return new ValidationInfo("Please specify " + NpmPackageProjectGenerator.this.packageName() + " package correctly");
                }
                return null;
            }

            public boolean isBackgroundJobRunning() {
                return false;
            }

            public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener) {
                if (listener == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$2", "addSettingsStateListener"));
                }
                this.myInterpreter.addChangeListener(interpreter -> {
                    if (listener == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$2", "lambda$addSettingsStateListener$1"));
                    }
                    listener.stateChanged(this.validate() == null);
                });
                ((TextFieldWithHistory)this.myModule.getChildComponent()).addItemListener(module -> {
                    if (listener == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$2", "lambda$addSettingsStateListener$2"));
                    }
                    listener.stateChanged(this.validate() == null);
                });
                listener.stateChanged(this.validate() == null);
            }
        };
        if (generatorPeer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "createPeer"));
        }
        return generatorPeer;
    }

    @NotNull
    protected VirtualFile workingDir(Project project, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseDir", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "workingDir"));
        }
        VirtualFile virtualFile = baseDir;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator", "workingDir"));
        }
        return virtualFile;
    }
}

