/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSLanguageUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSDoWhileStatement;
import com.intellij.lang.javascript.psi.JSForInStatement;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSWhileStatement;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JSBracePostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processElement"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processElement"));
        }
        Project project = source.getProject();
        if (source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            return new JSBraceEnforcer(project, settings).process(source);
        }
        if (source.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            return new InXmlBraceEnforcer(project, settings).process(source);
        }
        return source;
    }

    public TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        if (rangeToReformat == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rangeToReformat", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor", "processText"));
        }
        Project project = source.getProject();
        if (source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            return new JSBraceEnforcer(project, settings).processText(source, rangeToReformat);
        }
        if (source.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            return new InXmlBraceEnforcer(project, settings).processText(source, rangeToReformat);
        }
        List files = source.getViewProvider().getAllFiles();
        for (PsiFile file : files) {
            Language templateLang = file.getLanguage();
            if (templateLang.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                return new JSBraceEnforcer(project, settings).processText(file, rangeToReformat);
            }
            if (!(templateLang instanceof XMLLanguage)) continue;
            return new InXmlBraceEnforcer(project, settings).processText(file, rangeToReformat);
        }
        return rangeToReformat;
    }

    private static class JSBraceEnforcer
    extends JSRecursiveElementVisitor {
        private CommonCodeStyleSettings mySettings;
        private final CodeStyleSettings myTopSettings;
        private final PostFormatProcessorHelper myPostFormatProcessor;
        private final Project myProject;

        public JSBraceEnforcer(Project project, CodeStyleSettings settings) {
            this.myProject = project;
            this.myTopSettings = settings;
            this.myPostFormatProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
        }

        public void visitJSIfStatement(JSIfStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSIfStatement(node);
                this.processStatement((JSStatement)node, node.getThen(), this.mySettings.IF_BRACE_FORCE);
                if (!(node.getElse() instanceof JSIfStatement) || !this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.processStatement((JSStatement)node, node.getElse(), this.mySettings.IF_BRACE_FORCE);
                }
            }
        }

        public void visitJSDoWhileStatement(JSDoWhileStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSDoWhileStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.DOWHILE_BRACE_FORCE);
            }
        }

        public void visitJSWhileStatement(JSWhileStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSWhileStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.WHILE_BRACE_FORCE);
            }
        }

        public void visitJSForStatement(JSForStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        public void visitJSForInStatement(JSForInStatement node) {
            if (this.myPostFormatProcessor.isElementPartlyInRange((PsiElement)node)) {
                super.visitJSForInStatement(node);
                this.processStatement((JSStatement)node, node.getBody(), this.mySettings.FOR_BRACE_FORCE);
            }
        }

        private void processStatement(JSStatement statement, JSStatement blockCandidate, int options) {
            if (blockCandidate instanceof JSBlockStatement || blockCandidate == null) {
                return;
            }
            if (options == 3 || options == 1 && PostFormatProcessorHelper.isMultiline((PsiElement)statement)) {
                this.replaceWithBlock(statement, blockCandidate);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void replaceWithBlock(@NotNull JSStatement parent, JSStatement blockCandidate) {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/lang/javascript/formatter/JSBracePostFormatProcessor$JSBraceEnforcer", "replaceWithBlock"));
            }
            assert (parent.isValid());
            if (!this.myPostFormatProcessor.isElementFullyInRange((PsiElement)blockCandidate)) {
                return;
            }
            String oldText = blockCandidate.getText();
            StringBuilder buf = new StringBuilder(oldText.length() + 3);
            buf.append('{');
            buf.append(oldText);
            buf.append("\n}");
            int oldTextLength = parent.getTextLength();
            try {
                ASTNode replacement = JSChangeUtil.createJSTreeFromText(this.myProject, buf.toString(), JSUtils.getDialect(parent.getContainingFile()));
                if (replacement == null) {
                    return;
                }
                ASTNode parentNode = parent.getNode();
                PsiElement blockCandidateNextSibling = blockCandidate.getNextSibling();
                if (blockCandidateNextSibling instanceof PsiWhiteSpace) {
                    CodeEditUtil.removeChild((ASTNode)parentNode, (ASTNode)blockCandidateNextSibling.getNode());
                }
                CodeEditUtil.replaceChild((ASTNode)parentNode, (ASTNode)blockCandidate.getNode(), (ASTNode)replacement);
                PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)this.myProject);
                Document doc = docManager.getDocument(parent.getContainingFile());
                if (doc != null) {
                    docManager.doPostponedOperationsAndUnblockDocument(doc);
                    CodeStyleManager.getInstance((Project)this.myProject).reformatNewlyAddedElement(parent.getParent().getNode(), parent.getNode());
                }
            }
            finally {
                this.myPostFormatProcessor.updateResultRange(oldTextLength, parent.getTextLength());
            }
        }

        public TextRange processElementRange(PsiElement element, TextRange rangeToReformat) {
            this.mySettings = this.myTopSettings.getCommonSettings(JSLanguageUtil.getLanguageDialect(element));
            this.myPostFormatProcessor.setResultTextRange(rangeToReformat);
            element.accept((PsiElementVisitor)this);
            return this.myPostFormatProcessor.getResultTextRange();
        }

        public PsiElement process(PsiElement formatted) {
            this.mySettings = this.myTopSettings.getCommonSettings(JSLanguageUtil.getLanguageDialect(formatted));
            assert (formatted.isValid());
            formatted.accept((PsiElementVisitor)this);
            return formatted;
        }

        public TextRange processText(PsiFile source, TextRange rangeToReformat) {
            this.mySettings = this.myTopSettings.getCommonSettings(JSLanguageUtil.getLanguageDialect((PsiElement)source));
            this.myPostFormatProcessor.setResultTextRange(rangeToReformat);
            source.accept((PsiElementVisitor)this);
            return this.myPostFormatProcessor.getResultTextRange();
        }
    }

    private static class InXmlBraceEnforcer
    extends XmlRecursiveElementVisitor {
        private final CodeStyleSettings mySettings;
        private final PostFormatProcessorHelper myPostFormatProcessor;
        private final Project myProject;

        public InXmlBraceEnforcer(Project project, CodeStyleSettings settings) {
            this.mySettings = settings;
            this.myPostFormatProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)settings);
            this.myProject = project;
        }

        public void visitXmlText(XmlText text) {
            this.processInjected((PsiElement)text);
        }

        public void processInjected(PsiElement element) {
            List pairs = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element);
            if (pairs == null) {
                return;
            }
            for (Pair pair : pairs) {
                if (!(pair.getFirst() instanceof PsiFile)) continue;
                PsiFile jsFile = (PsiFile)pair.getFirst();
                int jsFileOffset = element.getTextOffset();
                int relStart = 0;
                int relEnd = 0;
                TextRange initialRange = this.myPostFormatProcessor.getResultTextRange();
                if (initialRange != null) {
                    relStart = initialRange.getStartOffset() - jsFileOffset;
                    if (relStart < 0) {
                        relStart = 0;
                    }
                    if ((relEnd = initialRange.getEndOffset() - jsFileOffset) < 0) {
                        return;
                    }
                    if (relEnd > jsFile.getTextLength()) {
                        relEnd = jsFile.getTextLength();
                    }
                } else {
                    relStart = 0;
                    relEnd = jsFile.getTextLength();
                }
                UnfairTextRange relRange = new UnfairTextRange(relStart, relEnd);
                new JSBraceEnforcer(this.myProject, this.mySettings).processText(jsFile, (TextRange)relRange);
            }
        }

        public void visitElement(PsiElement element) {
            ASTNode node = element.getNode();
            if (node != null && node.getElementType() == JSElementTypes.EMBEDDED_CONTENT) {
                new JSBraceEnforcer(this.myProject, this.mySettings).processElementRange(element, this.myPostFormatProcessor.getResultTextRange());
            }
            super.visitElement(element);
        }

        public PsiElement process(PsiElement formatted) {
            assert (formatted.isValid());
            formatted.accept((PsiElementVisitor)this);
            return formatted;
        }

        public TextRange processText(PsiFile source, TextRange rangeToReformat) {
            this.myPostFormatProcessor.setResultTextRange(rangeToReformat);
            source.accept((PsiElementVisitor)this);
            return this.myPostFormatProcessor.getResultTextRange();
        }
    }
}

