/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSNodeVisitor;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSSpacingProcessor
extends JSNodeVisitor {
    protected final ASTNode myParent;
    protected final ASTNode myChild1;
    protected final ASTNode myChild2;
    protected final CommonCodeStyleSettings mySettings;
    @NotNull
    private final JSCodeStyleSettings myJSCodeStyleSettings;
    protected Spacing myResult;
    protected final IElementType type1;
    protected final IElementType type2;
    public static TokenSet NOT_A_PACKAGE_CONTENT = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.PACKAGE_KEYWORD, JSElementTypes.REFERENCE_EXPRESSION, JSTokenTypes.LBRACE, JSTokenTypes.RBRACE});

    public JSSpacingProcessor(ASTNode parent, ASTNode child1, ASTNode child2, CodeStyleSettings settings, Language dialect, @NotNull JSCodeStyleSettings jsCodeStyleSettings) {
        if (jsCodeStyleSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsCodeStyleSettings", "com/intellij/lang/javascript/formatter/JSSpacingProcessor", "<init>"));
        }
        this.myParent = parent;
        this.myChild1 = child1;
        this.myChild2 = child2;
        this.type1 = child1.getElementType();
        this.type2 = child2.getElementType();
        this.mySettings = settings.getCommonSettings(dialect);
        this.myJSCodeStyleSettings = jsCodeStyleSettings;
    }

    public Spacing calcSpacing() {
        if (!this.isLineCommentSpacing()) {
            this.visit(this.myParent);
        }
        return this.myResult;
    }

    private boolean isLineCommentSpacing() {
        if (this.type2 == JSTokenTypes.END_OF_LINE_COMMENT && this.isInlineEndOfLineCommentOnLeft() && this.type1 != JSStubElementTypes.IMPORT_STATEMENT) {
            this.myResult = Spacing.getReadOnlySpacing();
            return true;
        }
        if (this.type1 == JSTokenTypes.END_OF_LINE_COMMENT) {
            boolean isTemplateLangRightChild;
            int blankLines = this.mySettings.KEEP_BLANK_LINES_IN_CODE;
            if (this.type2 == JSStubElementTypes.IMPORT_STATEMENT) {
                blankLines = this.mySettings.BLANK_LINES_BEFORE_IMPORTS;
            }
            int minBlankLines = (isTemplateLangRightChild = this.myChild2.getPsi() instanceof OuterLanguageElement) ? 0 : 1;
            boolean keepLineBreaks = isTemplateLangRightChild || this.mySettings.KEEP_LINE_BREAKS;
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)minBlankLines, (boolean)keepLineBreaks, (int)blankLines);
            return true;
        }
        return false;
    }

    @Override
    public void visitObjectLiteralExpression(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES);
    }

    @Override
    public void visitDestructuringObject(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_OBJECT_LITERAL_BRACES);
    }

    private void forceSpaceInBraces(ASTNode node, boolean need) {
        if (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE) {
            if (this.type1 == JSTokenTypes.LBRACE && this.type2 == JSTokenTypes.RBRACE) {
                this.forceSingleSpace(false);
                return;
            }
            int spaces = need ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)node.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE, false);
        }
    }

    @Override
    public void visitES6ImportDeclaration(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_IMPORTS);
    }

    @Override
    public void visitES6ExportDeclaration(ASTNode node) {
        this.forceSpaceInBraces(node, this.myJSCodeStyleSettings.SPACES_WITHIN_IMPORTS);
    }

    @Override
    public void visitArrayLiteralExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET) {
            int spaces;
            if (this.type1 == JSTokenTypes.LBRACKET && this.type2 == JSTokenTypes.RBRACKET) {
                this.forceSingleSpace(false);
                return;
            }
            int n = spaces = this.mySettings.SPACE_WITHIN_BRACKETS ? 1 : 0;
            if (this.isArrayBracketOnAnotherLine(this.type1) || this.isArrayBracketOnAnotherLine(this.type2)) {
                TextRange parentRange = this.myParent.getTextRange();
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)parentRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                return;
            }
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE, false);
        }
    }

    @Override
    public void visitIndexedPropertyAccessExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.LBRACKET || this.type2 == JSTokenTypes.RBRACKET) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_BRACKETS);
        }
    }

    @Override
    public void visitXmlLiteralExpression(ASTNode node) {
        if (this.type2 == JSTokenTypes.XML_JS_SCRIPT) {
            this.myResult = Spacing.getReadOnlySpacing();
        } else if (this.type2 == JSElementTypes.XML_LITERAL_EXPRESSION || this.type1 == JSTokenTypes.XML_START_TAG_LIST && this.type2 != JSTokenTypes.XML_END_TAG_LIST && this.type2 != JSTokenTypes.XML_TAG_CONTENT || this.type1 == JSElementTypes.XML_LITERAL_EXPRESSION) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitAttributeList(ASTNode node) {
        if (this.type1 == JSStubElementTypes.ATTRIBUTE || this.type2 == JSStubElementTypes.ATTRIBUTE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSElementTypes.REFERENCE_EXPRESSION && this.type2 == JSTokenTypes.STATIC_KEYWORD) {
            this.setSingleSpace(true);
        } else if (this.getModifiersSet().contains(this.type1) && this.type2 == JSTokenTypes.STATIC_KEYWORD) {
            this.forceSingleSpace();
        } else {
            IElementType parentElementType;
            this.myResult = this.type1 == JSTokenTypes.AT && this.type2 == JSStubElementTypes.ES6_DECORATOR ? Spacing.getReadOnlySpacing() : (this.type1 == JSStubElementTypes.ES6_DECORATOR && this.getModifiersSet().contains(this.type2) ? ((parentElementType = node.getTreeParent().getElementType()) != TypeScriptElementTypes.TYPESCRIPT_PARAMETER && !JSElementTypes.VAR_STATEMENTS.contains(parentElementType) ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE)) : Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE));
        }
    }

    @Override
    public void visitEmbeddedContent(ASTNode node) {
        if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type1) || JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type2) && this.type1 != JSTokenTypes.DOT || this.type2 == JSTokenTypes.RBRACE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
    }

    @Override
    public void visitParameterList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR && this.type2 == JSTokenTypes.RPAR) {
            this.forceSingleSpace(false);
        } else if (this.type1 == JSTokenTypes.LPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, false, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, false, 0);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, 0, false);
        }
    }

    @Override
    public void visitPackageStatement(ASTNode node) {
        if (this.type2 == JSTokenTypes.LBRACE) {
            this.putBraceAsNeeded();
        } else {
            this.processBlock(node);
        }
    }

    @Override
    public void visitImportStatement(ASTNode node) {
        this.processBlock(node);
    }

    @Override
    public void visitClass(ASTNode node) {
        if (this.type2 == JSTokenTypes.LBRACE) {
            this.putBraceAsNeeded();
        } else {
            this.processBlock(node);
        }
    }

    @Override
    public void visitTypeScriptInterface(ASTNode node) {
        if (this.type2 == TypeScriptElementTypes.OBJECT_TYPE) {
            this.putBraceAsNeeded();
        } else {
            this.processBlock(node);
        }
    }

    @Override
    public void visitObjectType(ASTNode node) {
        IElementType grandParentType = this.myParent.getTreeParent().getElementType();
        if (grandParentType == JSStubElementTypes.TYPESCRIPT_INTERFACE) {
            this.processBlock(node);
        }
    }

    private void putBraceAsNeeded() {
        if (this.mySettings.CLASS_BRACE_STYLE == 2) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.setBraceSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.CLASS_BRACE_STYLE, this.myChild1.getTextRange());
        }
    }

    @Override
    public void visitBlock(ASTNode node) {
        this.processBlock(node);
    }

    @Override
    public void visitCaseClause(ASTNode node) {
        if (this.type1 == JSTokenTypes.COLON && this.type2 == JSElementTypes.BLOCK_STATEMENT) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, this.myChild2.getTextRange());
            return;
        }
        this.processBlock(node);
    }

    @Override
    public void visitTypeScriptModule(ASTNode node) {
        if (this.type2 == JSTokenTypes.LBRACE) {
            this.putBraceAsNeeded();
        } else {
            this.processBlock(node);
        }
    }

    protected void processBlock(ASTNode node) {
        if (this.type2 == TokenType.NEW_LINE_INDENT) {
            this.myResult = Spacing.getReadOnlySpacing();
            return;
        }
        if (this.type1 == JSTokenTypes.IMPORT_KEYWORD && this.type2 == JSElementTypes.REFERENCE_EXPRESSION) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            return;
        }
        if (this.type1 == JSStubElementTypes.ATTRIBUTE_LIST && this.type2 == JSTokenTypes.CLASS_KEYWORD) {
            this.decoratorSpacing();
        }
        if (this.type1 == JSTokenTypes.CLASS_KEYWORD && this.type2 == JSElementTypes.REFERENCE_EXPRESSION) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (this.type1 == JSElementTypes.REFERENCE_EXPRESSION && (JSStubElementTypes.EXTENDS_LIST_MEMBER == this.type2 || JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(this.type2))) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (JSElementTypes.EXTENDS_LISTS.contains(this.type1) && this.type2 == JSStubElementTypes.IMPLEMENTS_LIST) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type1) || JSTokenTypes.COMMENTS.contains(this.type1) || JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type2) || this.type2 == JSTokenTypes.RBRACE) {
            if (JSSpacingProcessor.isInjectedJSHack(this.type1, this.type2) || JSSpacingProcessor.isInjectedJSHack(this.type2, this.type1)) {
                this.myResult = Spacing.getReadOnlySpacing();
            } else {
                boolean keepOneLine = false;
                ASTNode superParent = this.myParent.getTreeParent();
                if (superParent != null) {
                    boolean bl = keepOneLine = superParent.getPsi() instanceof JSFunction ? this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE : this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE;
                }
                this.myResult = keepOneLine && (this.type1 == JSTokenTypes.LBRACE || this.type2 == JSTokenTypes.RBRACE) ? Spacing.createDependentLFSpacing((int)0, (int)1, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (JSStubElementTypes.IMPORT_STATEMENT == this.type1 && JSStubElementTypes.IMPORT_STATEMENT != this.type2 && JSTokenTypes.RBRACE != this.type2 ? Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_AFTER_IMPORTS), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (JSStubElementTypes.IMPORT_STATEMENT != this.type1 && JSTokenTypes.LBRACE != this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2 ? Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_BEFORE_IMPORTS), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (JSStubElementTypes.IMPORT_STATEMENT == this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2 ? this.getSpacingBetweenImports() : (JSStubElementTypes.USE_NAMESPACE_DIRECTIVE == this.type1 && JSStubElementTypes.USE_NAMESPACE_DIRECTIVE != this.type2 && JSTokenTypes.RBRACE != this.type2 || JSStubElementTypes.USE_NAMESPACE_DIRECTIVE != this.type1 && JSTokenTypes.LBRACE != this.type1 && JSStubElementTypes.USE_NAMESPACE_DIRECTIVE == this.type2 ? Spacing.createSpacing((int)0, (int)0, (int)2, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (node.getElementType() == JSStubElementTypes.PACKAGE_STATEMENT && this.type1 == JSTokenTypes.LBRACE ? Spacing.createSpacing((int)0, (int)0, (int)(this.mySettings.BLANK_LINES_AFTER_PACKAGE + 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : (JSTokenTypes.LBRACE == this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2 ? Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0) : (this.shouldPlaceExtraLinesAroundMethod() ? Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_AROUND_METHOD), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE) : Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE))))))));
            }
        }
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type1) && this.type2 == JSElementTypes.EMPTY_STATEMENT) {
            this.setSingleSpace(false);
        }
    }

    protected boolean shouldPlaceExtraLinesAroundMethod() {
        JSFunction fun;
        JSFunction jSFunction = fun = JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type2) ? (JSFunction)this.myChild2.getPsi() : null;
        if (JSElementTypes.VAR_STATEMENTS.contains(this.type1) && fun != null) {
            JSVariable[] vars;
            return !fun.isGetProperty() && !fun.isSetProperty() || (vars = ((JSVarStatement)this.myChild1.getPsi()).getVariables()).length <= 0 || !Comparing.equal((String)JSRefactoringUtil.transformVarNameToAccessorName(vars[0].getName(), this.myJSCodeStyleSettings), (String)fun.getName(), (boolean)true);
        }
        return JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type1) && this.type2 != JSTokenTypes.RBRACE;
    }

    private Spacing getSpacingBetweenImports() {
        String fqn1 = ((JSImportStatement)this.myChild1.getPsi()).getImportText();
        String fqn2 = ((JSImportStatement)this.myChild2.getPsi()).getImportText();
        String rootPackage1 = fqn1 != null && fqn1.contains(".") ? fqn1.substring(0, fqn1.indexOf(".")) : null;
        String rootPackage2 = fqn2 != null && fqn2.contains(".") ? fqn2.substring(0, fqn2.indexOf(".")) : null;
        boolean lineBreak = rootPackage1 != null && rootPackage2 != null && !rootPackage1.equals(rootPackage2);
        return Spacing.createSpacing((int)0, (int)0, (int)(lineBreak ? 2 : 1), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static boolean isInjectedJSHack(IElementType type1, IElementType type2) {
        return type1 == JSTokenTypes.BAD_CHARACTER && JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(type2);
    }

    @Override
    public void visitFile(ASTNode node) {
        if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type1) || JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(this.type2)) {
            if (JSStubElementTypes.IMPORT_STATEMENT == this.type1 && JSStubElementTypes.IMPORT_STATEMENT != this.type2) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_AFTER_IMPORTS), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (JSStubElementTypes.IMPORT_STATEMENT != this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_BEFORE_IMPORTS), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else if (JSStubElementTypes.IMPORT_STATEMENT == this.type1 && JSStubElementTypes.IMPORT_STATEMENT == this.type2) {
                this.myResult = this.getSpacingBetweenImports();
            } else if (JSElementTypes.FUNCTION_DECLARATIONS.contains(this.type1) && this.type2 == JSElementTypes.EMPTY_STATEMENT) {
                this.setSingleSpace(false);
            } else if (this.shouldPlaceExtraLinesAroundMethod() && node.getPsi().getContext() instanceof XmlText) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)(1 + this.mySettings.BLANK_LINES_AROUND_METHOD), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                int minLineFeeds = this.type1 == JSElementTypes.EMPTY_STATEMENT ? 0 : 1;
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)minLineFeeds, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
    }

    private boolean isInlineEndOfLineCommentOnLeft() {
        ASTNode prev = this.myChild2.getTreePrev();
        if (prev == this.myChild1) {
            return true;
        }
        if (prev != null && prev.getPsi() instanceof PsiWhiteSpace) {
            return !prev.textContains('\n');
        }
        return false;
    }

    @Override
    public void visitFunctionDeclaration(ASTNode node) {
        if (this.type1 == JSTokenTypes.FUNCTION_KEYWORD) {
            if (JSKeywordSets.IDENTIFIER_NAMES.contains(this.type2)) {
                this.setSingleSpace(true);
            } else if (JSElementTypes.PARAMETER_LISTS.contains(this.type2)) {
                this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_FUNCTION_LEFT_PARENTH);
            }
        } else if (JSElementTypes.PARAMETER_LISTS.contains(this.type2)) {
            ASTNode firstChild = this.myChild2.getFirstChildNode();
            boolean startsWithLeftPar = firstChild != null && firstChild.getElementType() == JSTokenTypes.LPAR;
            this.setSingleSpace(!startsWithLeftPar || this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        } else if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            if (this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE && this.mySettings.METHOD_BRACE_STYLE != 1 && this.mySettings.METHOD_BRACE_STYLE != 5) {
                int spaces = this.mySettings.SPACE_BEFORE_METHOD_LBRACE ? 1 : 0;
                this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)this.myParent.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.setBraceSpace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, this.myChild1.getTextRange());
            }
        } else if (this.type1 == JSStubElementTypes.ATTRIBUTE_LIST && this.type2 == JSTokenTypes.FUNCTION_KEYWORD) {
            this.decoratorSpacing();
        } else if (this.type1 == JSTokenTypes.EQGT || this.type2 == JSTokenTypes.EQGT) {
            int spaces = this.myJSCodeStyleSettings.SPACE_AROUND_ARROW_FUNCTION_OPERATOR ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.appendSpacingForTypes();
        }
    }

    protected void decoratorSpacing() {
        if (this.isAfterDecorator()) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            this.forceSingleSpace();
        }
    }

    private boolean isAfterDecorator() {
        return (DialectDetector.isTypeScript(this.myParent.getPsi()) || DialectDetector.isES6(this.myParent.getPsi())) && this.myChild1.getChildren(this.getModifiersSet()).length == 0;
    }

    @Override
    public void visitFunctionExpression(ASTNode node) {
        this.visitFunctionDeclaration(node);
    }

    @Override
    public void visitReferenceExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.NEW_KEYWORD) {
            this.setSingleSpace(true);
        } else {
            this.setSingleSpace(false);
        }
    }

    @Override
    public void visitDocComment(ASTNode node) {
    }

    @Override
    public void visitIfStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.IF_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
                TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
                this.setBraceSpace(this.mySettings.SPACE_BEFORE_IF_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
            } else if (this.type2 == JSElementTypes.EXPRESSION_STATEMENT) {
                this.setSingleSpace(true);
            }
        } else if (this.type2 == JSTokenTypes.ELSE_KEYWORD) {
            this.setLineBreakSpace(this.mySettings.ELSE_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_ELSE_KEYWORD);
        } else if (this.type1 == JSTokenTypes.ELSE_KEYWORD) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
                this.setBraceSpace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, null);
            }
            if (this.type2 == JSElementTypes.IF_STATEMENT) {
                if (this.mySettings.SPECIAL_ELSE_IF_TREATMENT) {
                    this.forceSingleSpace();
                } else {
                    this.setLineBreakSpace(true, false);
                }
            }
        }
    }

    @Override
    public void visitCallExpression(ASTNode node) {
        if (this.type2 == JSElementTypes.ARGUMENT_LIST) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
    }

    @Override
    public void visitNewExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.NEW_KEYWORD) {
            this.setSingleSpace(true);
        } else if (this.type2 == JSElementTypes.ARGUMENT_LIST) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
    }

    @Override
    public void visitForStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.SEMICOLON) {
            this.setSingleSpace(true);
        } else if (this.type2 == JSTokenTypes.SEMICOLON) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_SEMICOLON);
        }
        if (this.type1 == JSTokenTypes.FOR_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        } else if (this.type1 == JSTokenTypes.LPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.FOR_STATEMENT_LPAREN_ON_NEXT_LINE, (Computable<TextRange>)((Computable)() -> JSSpacingProcessor.getRangeInsideParentheses(node)), this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.FOR_STATEMENT_RPAREN_ON_NEXT_LINE, (Computable<TextRange>)((Computable)() -> JSSpacingProcessor.getRangeInsideParentheses(node)), this.mySettings.SPACE_WITHIN_FOR_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        }
    }

    @Nullable
    private static TextRange getRangeInsideParentheses(ASTNode node) {
        IElementType childType;
        ASTNode child;
        ASTNode firstNode = null;
        ASTNode lastNode = null;
        for (child = node.getFirstChildNode(); child != null && child.getElementType() != JSTokenTypes.LPAR; child = child.getTreeNext()) {
        }
        if (child == null) {
            return null;
        }
        while (child != null && (childType = child.getElementType()) != JSTokenTypes.RPAR) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childType)) {
                return null;
            }
            if (!(child.getPsi() instanceof PsiWhiteSpace)) {
                if (firstNode == null) {
                    firstNode = child;
                }
                lastNode = child;
            }
            child = child.getTreeNext();
        }
        return firstNode != null ? new TextRange(firstNode.getTextRange().getStartOffset(), lastNode.getTextRange().getEndOffset()) : null;
    }

    @Override
    public void visitDoWhileStatement(ASTNode node) {
        if (this.type2 == JSTokenTypes.WHILE_KEYWORD) {
            if (this.mySettings.WHILE_ON_NEW_LINE) {
                this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                int spaces = this.mySettings.SPACE_BEFORE_WHILE_KEYWORD ? 1 : 0;
                this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        } else if (this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.DO_KEYWORD && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_DO_LBRACE);
        }
    }

    @Override
    public void visitForInStatement(ASTNode node) {
        if (JSTokenTypes.VAR_MODIFIERS.contains(this.type1) || JSTokenTypes.VAR_MODIFIERS.contains(this.type2)) {
            this.setSingleSpace(true);
        } else if (this.type1 == JSTokenTypes.FOR_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
        }
    }

    @Override
    public void visitWhileStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.WHILE_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        }
    }

    @Override
    public void visitWithStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.WITH_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        }
    }

    @Override
    public void visitTryStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.TRY_KEYWORD && JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, null);
        } else if (this.type2 == JSElementTypes.CATCH_BLOCK) {
            this.setLineBreakSpace(this.mySettings.CATCH_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_CATCH_KEYWORD);
        } else if (this.type2 == JSTokenTypes.FINALLY_KEYWORD) {
            this.setLineBreakSpace(this.mySettings.FINALLY_ON_NEW_LINE, this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD);
        } else if (this.type1 == JSTokenTypes.FINALLY_KEYWORD) {
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, this.mySettings.BRACE_STYLE, null);
        }
    }

    @Override
    public void visitCatchBlock(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.CATCH_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(this.type2)) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild2.getTextRange().getStartOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_CATCH_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        }
    }

    @Override
    public void visitSwitchStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.SWITCH_KEYWORD && this.type2 == JSTokenTypes.LPAR) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
        } else if (this.type1 == JSTokenTypes.RPAR) {
            TextRange dependentRange = new TextRange(this.myParent.getStartOffset(), this.myChild1.getTextRange().getEndOffset());
            this.setBraceSpace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, dependentRange);
        } else if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(this.type2) || this.type2 == JSTokenTypes.RBRACE) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else if (this.type1 == JSTokenTypes.LPAR || this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
        }
    }

    @Override
    public void visitArgumentList(ASTNode node) {
        if (this.type1 == JSTokenTypes.LPAR && this.type2 == JSTokenTypes.RPAR) {
            this.setSingleSpace(false);
            return;
        }
        if (this.type1 == JSTokenTypes.LPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type2 == JSTokenTypes.RPAR) {
            this.setDependentSpacingIfNecessary(this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE, this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, this.mySettings.KEEP_LINE_BREAKS, 0);
        } else if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE, false);
        }
    }

    @Override
    public void visitStatement(ASTNode node) {
        if (this.type2 == JSTokenTypes.SEMICOLON) {
            this.setSingleSpace(false);
        }
    }

    @Override
    public void visitVarStatement(ASTNode node) {
        if (JSTokenTypes.VAR_MODIFIERS.contains(this.type1)) {
            this.setSingleSpace(true);
            return;
        }
        if (this.type1 == JSStubElementTypes.ATTRIBUTE_LIST && (JSTokenTypes.VAR_MODIFIERS.contains(this.type2) || this.type2 == TypeScriptElementTypes.TYPESCRIPT_FIELD)) {
            if (this.isAfterDecorator()) {
                this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            } else {
                this.forceSingleSpace();
            }
            return;
        }
        if (this.type1 == JSTokenTypes.COMMA || this.type2 == JSTokenTypes.COMMA) {
            this.createCommaSpacing(this.type1, this.type2, this.mySettings.KEEP_BLANK_LINES_IN_CODE, true);
            return;
        }
        this.visitStatement(node);
    }

    private void forceSingleSpace() {
        this.forceSingleSpace(true);
    }

    private void forceSingleSpace(boolean needSpace) {
        int spaces = needSpace ? 1 : 0;
        this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
    }

    @Override
    public void visitVariable(ASTNode node) {
        if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        } else if (this.type1 == JSTokenTypes.DOT_DOT_DOT && this.type2 == JSTokenTypes.IDENTIFIER) {
            this.setSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_DOTS_IN_REST_PARAMETER);
        } else {
            this.appendSpacingForTypes();
        }
    }

    protected void appendSpacingForTypes() {
        if (this.type1 == JSTokenTypes.COLON) {
            this.forceSingleSpace(this.myJSCodeStyleSettings.SPACE_AFTER_TYPE_COLON);
        } else if (this.type2 == JSTokenTypes.COLON) {
            this.forceSingleSpace(this.myJSCodeStyleSettings.SPACE_BEFORE_TYPE_COLON);
        }
    }

    @Override
    public void visitBinaryExpression(ASTNode node) {
        if (this.type2 == JSElementTypes.PREFIX_EXPRESSION || this.type1 == JSTokenTypes.INSTANCEOF_KEYWORD || this.type2 == JSTokenTypes.INSTANCEOF_KEYWORD) {
            this.forceSingleSpace();
            return;
        }
        IElementType opSign = null;
        if (JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(this.type1)) {
            opSign = this.type1;
        } else if (JSExtendedLanguagesTokenSetProvider.OPERATIONS.contains(this.type2)) {
            opSign = this.type2;
        }
        if (opSign != null) {
            this.setSingleSpace(JSSpacingProcessor.keepSpacesAround(opSign) || this.getSpaceAroundOption(opSign));
        }
    }

    private static boolean keepSpacesAround(@NotNull IElementType opSign) {
        if (opSign == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "opSign", "com/intellij/lang/javascript/formatter/JSSpacingProcessor", "keepSpacesAround"));
        }
        return opSign == JSTokenTypes.IN_KEYWORD;
    }

    @Override
    public void visitCommaExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.COMMA) {
            this.setSingleSpace(true);
        }
    }

    @Override
    public void visitConditionalExpression(ASTNode node) {
        if (this.type1 == JSTokenTypes.QUEST) {
            this.setSingleSpace(this.mySettings.SPACE_AFTER_QUEST);
        } else if (this.type2 == JSTokenTypes.QUEST) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_QUEST);
        } else if (this.type1 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.mySettings.SPACE_AFTER_COLON);
        } else if (this.type2 == JSTokenTypes.COLON) {
            this.setSingleSpace(this.mySettings.SPACE_BEFORE_COLON);
        }
    }

    protected boolean getSpaceAroundOption(IElementType opSign) {
        boolean option = false;
        if (JSTokenTypes.ADDITIVE_OPERATIONS.contains(opSign)) {
            option = this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS;
        } else if (JSTokenTypes.MULTIPLICATIVE_OPERATIONS.contains(opSign) || JSTokenTypes.MULTMULT == opSign) {
            option = this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS;
        } else if (JSExtendedLanguagesTokenSetProvider.ASSIGNMENT_OPERATIONS.contains(opSign)) {
            option = this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS;
        } else if (JSTokenTypes.EQUALITY_OPERATIONS.contains(opSign)) {
            option = this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS;
        } else if (JSTokenTypes.RELATIONAL_OPERATIONS.contains(opSign)) {
            option = this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS;
        } else if (JSTokenTypes.SHIFT_OPERATIONS.contains(opSign)) {
            option = this.mySettings.SPACE_AROUND_SHIFT_OPERATORS;
        } else if (opSign == JSTokenTypes.ANDAND || opSign == JSTokenTypes.OROR) {
            option = this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS;
        } else if (opSign == JSTokenTypes.OR || opSign == JSTokenTypes.AND || opSign == JSTokenTypes.XOR) {
            option = this.mySettings.SPACE_AROUND_BITWISE_OPERATORS;
        } else if (opSign == JSTokenTypes.IS_KEYWORD || opSign == JSTokenTypes.AS_KEYWORD) {
            option = true;
        }
        return option;
    }

    @Override
    public void visitPrefixExpression(ASTNode node) {
        this.setUnaryOperatorSpacing(this.type1);
    }

    @Override
    public void visitPostfixExpression(ASTNode node) {
        this.setUnaryOperatorSpacing(this.type2);
    }

    protected void setUnaryOperatorSpacing(IElementType opType) {
        if (opType == JSTokenTypes.PLUS || opType == JSTokenTypes.MINUS || opType == JSTokenTypes.PLUSPLUS || opType == JSTokenTypes.MINUSMINUS || opType == JSTokenTypes.TILDE || opType == JSTokenTypes.EXCL) {
            this.setSingleSpace(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        }
    }

    private void setDependentSpacingIfNecessary(boolean useDependentSpacing, boolean needSpace, boolean keepLineBreaks, int keepBlankLines) {
        this.setDependentSpacingIfNecessary(useDependentSpacing, (Computable<TextRange>)((Computable)() -> this.myParent.getTextRange()), needSpace, keepLineBreaks, keepBlankLines);
    }

    private void setDependentSpacingIfNecessary(boolean useDependentSpacing, Computable<TextRange> dependencyRangeComputable, boolean needSpace, boolean keepLineBreaks, int keepBlankLines) {
        TextRange dependencyRange;
        TextRange textRange = dependencyRange = useDependentSpacing ? (TextRange)dependencyRangeComputable.compute() : null;
        if (dependencyRange != null) {
            int spaces = needSpace ? 1 : 0;
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)dependencyRange, (boolean)keepLineBreaks, (int)keepBlankLines);
        } else {
            int spaces = needSpace ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)keepLineBreaks, (int)keepBlankLines);
        }
    }

    protected void setSingleSpace(boolean needSpace) {
        int spaces = needSpace ? 1 : 0;
        this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    protected void setBraceSpace(boolean needSpaceSetting, int braceStyleSetting, TextRange textRange) {
        int spaces;
        int n = spaces = needSpaceSetting ? 1 : 0;
        if (braceStyleSetting == 5 && textRange != null) {
            this.myResult = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        } else {
            int lineBreaks = braceStyleSetting == 1 || braceStyleSetting == 5 ? 0 : 1;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)lineBreaks, (boolean)false, (int)0);
        }
    }

    protected void setLineBreakSpace(boolean needLineBreak, boolean needSpace) {
        int breaks = needLineBreak || this.myChild1.getElementType() == JSTokenTypes.END_OF_LINE_COMMENT ? 1 : 0;
        int spaces = needSpace ? 1 : 0;
        this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)breaks, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @Override
    public void visitElement(ASTNode node) {
        if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(node.getElementType())) {
            this.processReferenceList();
        } else if (node.getElementType() == JSStubElementTypes.NAMESPACE_DECLARATION) {
            if (this.type1 == JSTokenTypes.NAMESPACE_KEYWORD || this.type2 == JSTokenTypes.NAMESPACE_KEYWORD) {
                this.setSingleSpace(true);
            } else if (this.type1 == JSTokenTypes.EQ || this.type2 == JSTokenTypes.EQ) {
                this.setSingleSpace(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
            }
        } else if (node.getElementType() == JSStubElementTypes.ATTRIBUTE) {
            if (this.type1 == JSTokenTypes.COMMA) {
                this.setSingleSpace(this.mySettings.SPACE_AFTER_COMMA);
            } else if (this.type2 == JSTokenTypes.COMMA) {
                this.setSingleSpace(this.mySettings.SPACE_BEFORE_COMMA);
            } else {
                this.forceSingleSpace(false);
            }
        } else if (node.getElementType() == JSStubElementTypes.ATTRIBUTE_NAME_VALUE_PAIR) {
            this.forceSingleSpace(false);
        }
    }

    private void processReferenceList() {
        if ((this.type1 == JSTokenTypes.EXTENDS_KEYWORD || this.type1 == JSTokenTypes.IMPLEMENTS_KEYWORD) && this.type2 == JSStubElementTypes.EXTENDS_LIST_MEMBER) {
            this.myResult = Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (this.type1 == JSStubElementTypes.EXTENDS_LIST_MEMBER && this.type2 == JSTokenTypes.COMMA) {
            this.myResult = Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
    }

    @Override
    public void visitProperty(ASTNode node) {
        if (this.type2 == JSTokenTypes.COLON) {
            int spaces = this.myJSCodeStyleSettings.SPACE_BEFORE_PROPERTY_COLON ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
        } else if (this.type1 == JSTokenTypes.COLON) {
            int spaces = this.myJSCodeStyleSettings.SPACE_AFTER_PROPERTY_COLON ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)false, (int)0);
        }
    }

    @Override
    public void visitParenthesizedExpression(ASTNode node) {
        ASTNode parent;
        if ((JSElementTypes.FUNCTION_EXPRESSIONS.contains(this.type2) && this.type1 == JSTokenTypes.LPAR || JSElementTypes.FUNCTION_EXPRESSIONS.contains(this.type1) && this.type2 == JSTokenTypes.RPAR) && (parent = this.myParent.getTreeParent()) != null && parent.getElementType() == JSElementTypes.CALL_EXPRESSION) {
            this.forceSingleSpace(false);
        }
    }

    @Override
    public void visitReturnStatement(ASTNode node) {
        if (this.type1 == JSTokenTypes.RETURN_KEYWORD) {
            int spaces = this.type2 == JSTokenTypes.SEMICOLON ? 0 : 1;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
        } else {
            super.visitReturnStatement(node);
        }
    }

    protected void createCommaSpacing(@NotNull IElementType type1, @NotNull IElementType type2, int blankLinesToKeep, boolean forceNewLine) {
        if (type1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type1", "com/intellij/lang/javascript/formatter/JSSpacingProcessor", "createCommaSpacing"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type2", "com/intellij/lang/javascript/formatter/JSSpacingProcessor", "createCommaSpacing"));
        }
        if (type1 == JSTokenTypes.COMMA) {
            int spaces = this.mySettings.SPACE_AFTER_COMMA ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesToKeep);
        } else if (type2 == JSTokenTypes.COMMA) {
            int spaces = this.mySettings.SPACE_BEFORE_COMMA ? 1 : 0;
            this.myResult = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)blankLinesToKeep);
        }
    }

    private boolean isArrayBracketOnAnotherLine(IElementType bracketType) {
        if (bracketType == JSTokenTypes.LBRACKET) {
            return this.mySettings.ARRAY_INITIALIZER_LBRACE_ON_NEXT_LINE;
        }
        if (bracketType == JSTokenTypes.RBRACKET) {
            return this.mySettings.ARRAY_INITIALIZER_RBRACE_ON_NEXT_LINE;
        }
        return false;
    }

    protected TokenSet getModifiersSet() {
        return JSTokenTypes.MODIFIERS;
    }
}

