/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.flow.validation;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.validation.ES6AnnotatingVisitor;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.frameworks.flow.validation.FlowJSAnnotatorCheckerProvider;
import com.intellij.lang.javascript.highlighting.JSSemanticHighlightingUtil;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunctionSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameter;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSEmptyTypeChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlowJSAnnotatingVisitor
extends ES6AnnotatingVisitor {
    public FlowJSAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "<init>"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "<init>"));
        }
        super(psiElement, holder);
    }

    @Override
    @NotNull
    protected JSAnnotatorProblemReporter createProblemReporter(PsiElement context) {
        FlowJSAnnotatorCheckerProvider flowJSAnnotatorCheckerProvider = FlowJSAnnotatorCheckerProvider.getCheckerProvider(context);
        if (flowJSAnnotatorCheckerProvider != null) {
            JSAnnotatorProblemReporter jSAnnotatorProblemReporter = flowJSAnnotatorCheckerProvider.createFlowProblemReporter(this.myHolder);
            if (jSAnnotatorProblemReporter == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "createProblemReporter"));
            }
            return jSAnnotatorProblemReporter;
        }
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = super.createProblemReporter(context);
        if (jSAnnotatorProblemReporter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "createProblemReporter"));
        }
        return jSAnnotatorProblemReporter;
    }

    @Override
    @NotNull
    protected JSTypeChecker<Annotation> createTypeChecker(PsiElement context) {
        JSEmptyTypeChecker jSEmptyTypeChecker = JSEmptyTypeChecker.getInstance();
        if (jSEmptyTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "createTypeChecker"));
        }
        return jSEmptyTypeChecker;
    }

    @Override
    public void visitES6ImportedBinding(ES6ImportedBinding importedBinding) {
        IElementType elementType;
        PsiElement prevSibling = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace((PsiElement)importedBinding);
        if (prevSibling != null && ((elementType = prevSibling.getNode().getElementType()) == JSTokenTypes.TYPE_KEYWORD || elementType == JSTokenTypes.TYPEOF_KEYWORD)) {
            return;
        }
        super.visitES6ImportedBinding(importedBinding);
    }

    public void visitTypeScriptIndexSignature(TypeScriptIndexSignature indexSignature) {
        JSSemanticHighlightingUtil.highlight(indexSignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptPropertySignature(TypeScriptPropertySignature propertySignature) {
        JSSemanticHighlightingUtil.highlight(propertySignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptFunctionSignature(TypeScriptFunctionSignature functionSignature) {
        JSSemanticHighlightingUtil.highlight(functionSignature, this.myHighlighter, this.myHolder);
    }

    public void visitTypeScriptTypeParameter(TypeScriptTypeParameter typeParameter) {
        JSSemanticHighlightingUtil.highlight(typeParameter, this.myHighlighter, this.myHolder);
    }

    @Override
    protected Annotation reportUnresolvedRefProblem(@Nullable ProblemHighlightType unresolveReferenceHighlightType, @Nullable List<LocalQuickFix> quickFixes, @NotNull PsiElement referenceNameElement, @NotNull String message, @Nullable String inspectionId) {
        if (referenceNameElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceNameElement", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/frameworks/flow/validation/FlowJSAnnotatingVisitor", "reportUnresolvedRefProblem"));
        }
        return super.reportUnresolvedRefProblem(null, quickFixes, referenceNameElement, message, inspectionId);
    }
}

