/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.systemjs;

import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSConfig;
import com.intellij.lang.javascript.frameworks.systemjs.SystemJSPathSubstitution;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.JSCustomStringIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemJSConfigFinder {
    public static final String BASE_URL = "baseURL";
    public static final String PATHS = "paths";
    public static final String MAPPINGS = "map";
    private static final Key<ParameterizedCachedValue<SystemJSConfig, JSObjectLiteralExpression>> CACHED_VALUE_KEY = Key.create((String)"TypeScript.System.JS");
    private static final ParameterizedCachedValueProvider<SystemJSConfig, JSObjectLiteralExpression> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<SystemJSConfig, JSObjectLiteralExpression>(){

        @Nullable
        public CachedValueProvider.Result<SystemJSConfig> compute(JSObjectLiteralExpression param) {
            SystemJSConfig config = SystemJSConfigFinder.parseConfigImpl(param);
            return CachedValueProvider.Result.create((Object)config, (Object[])new Object[]{param});
        }
    };

    public Collection<SystemJSConfig> getConfigs(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigs"));
        }
        return this.getConfigsImpl(context);
    }

    protected Collection<SystemJSConfig> getConfigsImpl(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigsImpl"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)context.getProject())) {
            return ContainerUtil.emptyList();
        }
        Collection<JSObjectLiteralExpression> literals = SystemJSConfigFinder.getConfigLiterals(context);
        if (literals.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        return literals.stream().map(SystemJSConfigFinder::parseConfig).filter(el -> el != null).collect(Collectors.toList());
    }

    @NotNull
    private static Collection<JSObjectLiteralExpression> getConfigLiterals(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigLiterals"));
        }
        Collection elements = StubIndex.getElements(JSCustomStringIndex.KEY, (Object)"System.config", (Project)context.getProject(), (GlobalSearchScope)JSResolveUtil.getResolveScope(context), PsiElement.class);
        Collection collection = elements.stream().map(el -> (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)el, JSObjectLiteralExpression.class)).filter(el -> el != null).filter(el -> {
            VirtualFile configFile = PsiUtilCore.getVirtualFile((PsiElement)el);
            return configFile != null && !JSLibraryUtil.isProbableLibraryFile(configFile);
        }).collect(Collectors.toList());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getConfigLiterals"));
        }
        return collection;
    }

    private static SystemJSConfig parseConfig(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "parseConfig"));
        }
        return (SystemJSConfig)CachedValuesManager.getManager((Project)expression.getProject()).getParameterizedCachedValue((UserDataHolder)expression, CACHED_VALUE_KEY, CACHED_VALUE_PROVIDER, false, (Object)expression);
    }

    @Nullable
    private static SystemJSConfig parseConfigImpl(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "parseConfigImpl"));
        }
        final VirtualFile configFile = PsiUtilCore.getVirtualFile((PsiElement)expression);
        if (configFile == null) {
            return null;
        }
        final VirtualFile file = SystemJSConfigFinder.getBaseURLFile(configFile.getParent(), SystemJSConfigFinder.getBaseURL(expression));
        final Collection<SystemJSPathSubstitution> substitutions = SystemJSConfigFinder.getAllSubstitutions(expression);
        if (substitutions.isEmpty()) {
            return null;
        }
        return new SystemJSConfig(){

            @Override
            public VirtualFile getBaseURL() {
                return file;
            }

            @Override
            public VirtualFile rootDirectory() {
                return configFile.getParent();
            }

            @Override
            public Collection<SystemJSPathSubstitution> getMappings() {
                return substitutions;
            }
        };
    }

    private static Collection<SystemJSPathSubstitution> getAllSubstitutions(JSObjectLiteralExpression expression) {
        Collection<Object> mappings;
        Map<String, String> rawPaths = SystemJSConfigFinder.getValues(expression, PATHS);
        Collection<SystemJSPathSubstitution> paths = SystemJSConfigFinder.convertToSubstitutions(rawPaths, SystemJSPathSubstitution.SystemJSPathSubstitutionType.PATH);
        Map<String, String> rawMappings = SystemJSConfigFinder.getValues(expression, MAPPINGS);
        if (paths.isEmpty() || rawMappings == null) {
            mappings = SystemJSConfigFinder.convertToSubstitutions(rawMappings, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP);
        } else {
            mappings = ContainerUtil.newArrayList();
            for (Map.Entry<String, String> entry : rawMappings.entrySet()) {
                String pattern = entry.getKey();
                String mapping = entry.getValue();
                Pair<SystemJSPathSubstitution, String> matchedElement = JSPathMappingsUtil.findMaxElementByPaths(mapping, paths);
                if (matchedElement == null) {
                    mappings.add(new SystemJSPathSubstitution(pattern, mapping, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP));
                    continue;
                }
                String newMapping = SystemJSConfigFinder.getSubstitutedString(mapping, matchedElement);
                mappings.add(new SystemJSPathSubstitution(pattern, newMapping, SystemJSPathSubstitution.SystemJSPathSubstitutionType.MAP));
            }
        }
        boolean isMappingEmpty = mappings.isEmpty();
        if (isMappingEmpty || paths.isEmpty()) {
            return isMappingEmpty ? paths : mappings;
        }
        if (mappings.isEmpty() && paths.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList(mappings);
        result.addAll(paths);
        return result;
    }

    private static String getSubstitutedString(String stringToProcess, Pair<SystemJSPathSubstitution, String> matchedElement) {
        JSModulePathSubstitution matchedPattern = (JSModulePathSubstitution)matchedElement.getFirst();
        String matchedStar = StringUtil.nullize((String)((String)matchedElement.getSecond()));
        String pattern = matchedPattern.getPattern();
        String patternExact = matchedStar != null ? pattern.replace("*", matchedStar) : pattern;
        String replaceBy = (String)ContainerUtil.getFirstItem(matchedPattern.getMappings());
        assert (replaceBy != null);
        String replaceByExact = matchedStar != null ? replaceBy.replace("*", matchedStar) : replaceBy;
        return stringToProcess.replace(patternExact, replaceByExact);
    }

    @NotNull
    private static VirtualFile getBaseURLFile(VirtualFile file, @Nullable String baseURL) {
        assert (file != null);
        if (baseURL == null || "/".equals(baseURL) || ".".equals(baseURL)) {
            VirtualFile virtualFile = file;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getBaseURLFile"));
            }
            return virtualFile;
        }
        VirtualFile url = JSPathMappingsUtil.getPathRelativeBaseUrl(file, baseURL);
        VirtualFile virtualFile = url == null ? file : url;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getBaseURLFile"));
        }
        return virtualFile;
    }

    @Nullable
    private static String getBaseURL(@NotNull JSObjectLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getBaseURL"));
        }
        JSProperty property = expression.findProperty(BASE_URL);
        if (property == null) {
            return null;
        }
        return SystemJSConfigFinder.getPropertyValueAsString(property);
    }

    @Nullable
    private static String getPropertyValueAsString(JSProperty property) {
        JSLiteralExpression expression = property.getLiteralExpressionInitializer();
        if (expression == null) {
            return null;
        }
        String significantValue = expression.getSignificantValue();
        return significantValue == null ? null : StringUtil.unquoteString((String)significantValue);
    }

    @Nullable
    private static Map<String, String> getValues(@NotNull JSObjectLiteralExpression expression, String propertyName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "getValues"));
        }
        JSProperty paths = expression.findProperty(propertyName);
        if (paths == null) {
            return null;
        }
        JSObjectLiteralExpression pathsExpression = paths.getObjectLiteralExpressionInitializer();
        if (pathsExpression == null) {
            return null;
        }
        JSProperty[] properties = pathsExpression.getProperties();
        if (properties.length == 0) {
            return null;
        }
        HashMap result = ContainerUtil.newHashMap();
        for (JSProperty property : properties) {
            String name = property.getName();
            String value = SystemJSConfigFinder.getPropertyValueAsString(property);
            if (StringUtil.isEmptyOrSpaces((String)name) || StringUtil.isEmptyOrSpaces((String)value)) continue;
            result.put(name, value);
        }
        return result;
    }

    private static Collection<SystemJSPathSubstitution> convertToSubstitutions(@Nullable Map<String, String> elements, @NotNull SystemJSPathSubstitution.SystemJSPathSubstitutionType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "convertToSubstitutions"));
        }
        if (elements == null) {
            return ContainerUtil.emptyList();
        }
        return elements.entrySet().stream().map(el -> {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/frameworks/systemjs/SystemJSConfigFinder", "lambda$convertToSubstitutions$4"));
            }
            return new SystemJSPathSubstitution((String)el.getKey(), (String)el.getValue(), type);
        }).collect(Collectors.toList());
    }
}

