/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.ES6ConvertRequireIntoImportInspection;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.ES6ImportsWorker;
import com.intellij.lang.javascript.modules.LastImportInScope;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCommaExpression;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ConvertRequireIntoImportQuickFix
implements LocalQuickFix,
IntentionAction,
HighPriorityAction {
    @NotNull
    private final SmartPsiElementPointer<JSCallExpression> myPointer;

    public ES6ConvertRequireIntoImportQuickFix(@NotNull JSCallExpression call) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "<init>"));
        }
        this.myPointer = SmartPointerManager.getInstance((Project)call.getProject()).createSmartPsiElementPointer((PsiElement)call);
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "getName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"js.convert.require.into.es6.import.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "getText"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = JSBundle.message((String)"js.convert.require.into.es6.import.family.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "isAvailable"));
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "invoke"));
        }
        JSCallExpression element = (JSCallExpression)this.myPointer.getElement();
        if (element != null && element.isValid()) {
            new Worker(element).execute();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix", "applyFix"));
        }
        JSCallExpression element = (JSCallExpression)this.myPointer.getElement();
        if (element != null && element.isValid()) {
            new Worker(element).execute();
        }
    }

    private static Set<String> collectExistingNames(PsiElement topElement) {
        HashSet<String> names = new HashSet<String>();
        Collection elements = PsiTreeUtil.findChildrenOfType((PsiElement)topElement, JSNamedElement.class);
        for (JSNamedElement element : elements) {
            String name = element.getName();
            if (StringUtil.isEmptyOrSpaces((String)name)) continue;
            names.add(name);
        }
        return names;
    }

    private static class Worker {
        private final JSCallExpression myCallExpression;
        private JSVariable myOwnerVariable;
        private PsiElement myFirstReference;
        private String myFirstReferenceText;
        private PsiElement myTopElement;
        private CommentsMover myCommentsMover;
        private final Set<PsiElement> myTouchedElements;
        private JSSourceElement myIsTopLevelStatement;
        private boolean myShouldMoveComments;
        private boolean myHasReferenceTail;
        private JSDestructuringElement myDestructuringElement;

        public Worker(@NotNull JSCallExpression callExpression) {
            if (callExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callExpression", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "<init>"));
            }
            this.myCallExpression = callExpression;
            this.myTouchedElements = new HashSet<PsiElement>();
        }

        public void execute() {
            this.init();
            if (this.myTopElement == null) {
                return;
            }
            JSExpression[] arguments = this.myCallExpression.getArguments();
            if (arguments.length == 1 && arguments[0] instanceof JSLiteralExpression && ((JSLiteralExpression)arguments[0]).isQuotedLiteral()) {
                JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)this.myCallExpression, JSSourceElement.class);
                boolean bl = this.myShouldMoveComments = sourceElement != null && this.shouldMoveComments(sourceElement);
                if (sourceElement != null) {
                    this.myCommentsMover = new CommentsMover(sourceElement);
                }
                String requireText = StringUtil.unquoteString((String)arguments[0].getText());
                if (this.myDestructuringElement != null && this.tryProcessAsDestructuring(requireText)) {
                    this.moveComments();
                    return;
                }
                Trinity<String, PsiElement, ES6ImportDeclaration> existing = ES6ImportsWorker.getExistingImport(this.myTopElement, requireText, this.myFirstReferenceText);
                if (existing != null && this.useExistingImport(requireText, existing)) {
                    return;
                }
                PsiElement createdReferenceTarget = this.createImport(requireText);
                if (createdReferenceTarget == null) {
                    return;
                }
                this.replaceWithReferenceToImport(this.myHasReferenceTail, createdReferenceTarget, createdReferenceTarget.getText(), this.myFirstReference);
                this.moveComments();
            }
        }

        private void moveComments() {
            if (this.myCommentsMover != null && this.myShouldMoveComments) {
                this.myCommentsMover.move(this.myTouchedElements, this.myTouchedElements);
            }
        }

        private boolean tryProcessAsDestructuring(@NotNull String requireText) {
            JSDestructuringProperty[] properties;
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "tryProcessAsDestructuring"));
            }
            if (this.myDestructuringElement == null) {
                return false;
            }
            PsiElement grand = this.myDestructuringElement.getParent();
            if (!(grand instanceof JSVarStatement)) {
                return false;
            }
            JSDestructuringContainer container = this.myDestructuringElement.getTarget();
            if (!(container instanceof JSDestructuringObject)) {
                return false;
            }
            JSDestructuringObject object = (JSDestructuringObject)container;
            for (JSDestructuringProperty property : properties = object.getProperties()) {
                if (property.getDestructuringElement() == null || property.getDestructuringElement().getName() == null || StringUtil.isEmptyOrSpaces((String)property.getName())) {
                    return false;
                }
                if (!"default".equals(property.getName()) || !"default".equals(property.getDestructuringElement().getName())) continue;
                return false;
            }
            ES6ImportsWorker.ExistingImports existingImports = ES6ImportsWorker.getExistingImports(this.myTopElement, requireText);
            for (JSDestructuringProperty property : properties) {
                PsiElement newImport;
                ES6ImportSpecifier existingExactSpecifier;
                String reference = property.getName();
                assert (reference != null);
                JSInitializerOwner variable = property.getDestructuringElement();
                String additionText = reference.equals(variable.getName()) ? "{" + reference + "}" : "{" + reference + " as " + variable.getName() + "}";
                boolean isDefault = "default".equals(reference);
                ES6ImportSpecifier eS6ImportSpecifier = existingExactSpecifier = isDefault ? null : existingImports.getByReference().get(reference);
                if (existingExactSpecifier != null) {
                    if (variable.getName().equals(existingExactSpecifier.getDeclaredName())) continue;
                    ES6ImportSpecifier replaceTarget = existingExactSpecifier.getAlias() != null ? existingExactSpecifier.getAlias() : existingExactSpecifier;
                    JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)replaceTarget, this.myTopElement);
                    continue;
                }
                if (!isDefault && !existingImports.getByReference().isEmpty()) {
                    Map.Entry<String, ES6ImportSpecifier> entry = existingImports.getByReference().entrySet().iterator().next();
                    assert (entry.getValue().getDeclaration() != null);
                    ES6ImportDeclaration declaration = (ES6ImportDeclaration)entry.getValue().getDeclaration();
                    if (this.insertImportIntoExistingRebind(declaration, additionText, existingImports, variable)) continue;
                }
                boolean existingUsed = false;
                for (ES6ImportedBinding binding : existingImports.getBindings()) {
                    if (binding.isNamespaceImport() || !(binding.getParent() instanceof ES6ImportDeclaration)) continue;
                    if (isDefault) {
                        JSChangeUtil.rebindVariableUsages((PsiElement)property.getDestructuringElement(), (PsiElement)binding, this.myTopElement);
                        existingUsed = true;
                        break;
                    }
                    if (!this.insertImportIntoExistingRebind((ES6ImportDeclaration)binding.getParent(), additionText, existingImports, variable)) continue;
                    existingUsed = true;
                    break;
                }
                if (existingUsed) continue;
                if (isDefault) {
                    newImport = this.createImport(this.myCallExpression.getProject(), requireText, variable.getName());
                    assert (newImport instanceof ES6ImportedBinding);
                    ES6ImportedBinding newBinding = (ES6ImportedBinding)newImport;
                    existingImports.getBindings().add(newBinding);
                    this.myTouchedElements.add((PsiElement)newBinding);
                } else {
                    newImport = this.createImport(this.myCallExpression.getProject(), requireText, additionText);
                    ES6ImportSpecifier importSpecifier = null;
                    if (newImport instanceof ES6ImportSpecifier) {
                        importSpecifier = (ES6ImportSpecifier)newImport;
                    } else if (newImport.getParent() instanceof ES6ImportSpecifier) {
                        importSpecifier = (ES6ImportSpecifier)newImport.getParent();
                    } else if (newImport.getParent() instanceof ES6ImportSpecifierAlias) {
                        importSpecifier = (ES6ImportSpecifier)((ES6ImportSpecifierAlias)newImport.getParent()).findSpecifierElement();
                    }
                    assert (importSpecifier != null);
                    existingImports.getByReference().put(importSpecifier.getReferenceName(), importSpecifier);
                    this.myTouchedElements.add(importSpecifier.getParent());
                }
                JSChangeUtil.rebindVariableUsages((PsiElement)variable, newImport, this.myTopElement);
            }
            JSDestructuringElement parent = this.myDestructuringElement;
            PsiElement current = parent.getNextSibling();
            while (current instanceof PsiWhiteSpace) {
                current = parent.getNextSibling();
            }
            if (current != null && current.getNode().getElementType() == JSTokenTypes.COMMA) {
                parent.getParent().deleteChildRange((PsiElement)parent, current);
            } else {
                parent.delete();
            }
            if (((JSVarStatement)grand).getVariables().length == 0) {
                grand.delete();
            }
            return true;
        }

        private boolean insertImportIntoExistingRebind(ES6ImportDeclaration declaration, String additionText, ES6ImportsWorker.ExistingImports existingImports, JSInitializerOwner variable) {
            this.myTouchedElements.add((PsiElement)declaration);
            ES6ImportSpecifier importSpecifier = ES6ImportsWorker.insertImportSpecifier(declaration, additionText);
            if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                existingImports.getByReference().put(importSpecifier.getReferenceName(), importSpecifier);
                ES6ImportSpecifier nameElement = importSpecifier.getAlias() != null ? importSpecifier.getAlias() : importSpecifier;
                JSChangeUtil.rebindVariableUsages((PsiElement)variable, (PsiElement)nameElement, this.myTopElement);
                return true;
            }
            return false;
        }

        private boolean useExistingImport(String requireText, Trinity<String, PsiElement, ES6ImportDeclaration> existing) {
            if (existing.getFirst() != null && existing.getSecond() != null) {
                if (existing.getSecond() instanceof ES6ImportedBinding && !"default".equals(this.myFirstReferenceText)) {
                    this.replaceWithReferenceToImport(this.myFirstReference != null, (PsiElement)existing.getSecond(), (String)existing.getFirst(), (PsiElement)this.myCallExpression);
                } else {
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, (PsiElement)existing.getSecond(), (String)existing.getFirst(), this.myFirstReference);
                }
                return true;
            }
            if (existing.getThird() != null) {
                String prefixText = this.getPrefixText(requireText, this.myCallExpression.getParent());
                if (prefixText == null) {
                    return true;
                }
                ES6ImportSpecifier importSpecifier = ES6ImportsWorker.insertImportSpecifier((ES6ImportDeclaration)existing.getThird(), prefixText);
                if (importSpecifier != null && importSpecifier.getDeclaredName() != null) {
                    this.replaceWithReferenceToImport(this.myHasReferenceTail, (PsiElement)importSpecifier, importSpecifier.getDeclaredName(), this.myFirstReference);
                    return true;
                }
            }
            return false;
        }

        private void replaceWithReferenceToImport(boolean hasReferenceTail, @NotNull PsiElement createdReferenceTarget, @NotNull String createdName, @Nullable PsiElement replacementTarget) {
            if (createdReferenceTarget == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdReferenceTarget", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "replaceWithReferenceToImport"));
            }
            if (createdName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "createdName", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "replaceWithReferenceToImport"));
            }
            ES6ImportDeclaration importDeclaration = (ES6ImportDeclaration)PsiTreeUtil.getParentOfType((PsiElement)createdReferenceTarget, ES6ImportDeclaration.class);
            if (importDeclaration != null) {
                this.myTouchedElements.add((PsiElement)importDeclaration);
            }
            JSExpressionStatement statement = (JSExpressionStatement)JSChangeUtil.createStatementFromText(this.myCallExpression.getProject(), createdName).getPsi(JSExpressionStatement.class);
            if (!hasReferenceTail) {
                if (this.myOwnerVariable != null) {
                    if (!createdName.equals(this.myOwnerVariable.getName())) {
                        JSChangeUtil.rebindVariableUsages((PsiElement)this.myOwnerVariable, createdReferenceTarget, this.myTopElement);
                    }
                    this.myOwnerVariable.delete();
                } else if (this.myCallExpression.getParent() instanceof JSExpressionStatement && ((JSExpressionStatement)this.myCallExpression.getParent()).getExpression() == this.myCallExpression) {
                    this.myCallExpression.getParent().delete();
                } else if (this.myCallExpression.getParent() instanceof JSCommaExpression) {
                    JSCommaExpression comma = (JSCommaExpression)this.myCallExpression.getParent();
                    JSExpression other = comma.getLOperand() == this.myCallExpression ? comma.getROperand() : comma.getLOperand();
                    comma.replace((PsiElement)other);
                } else {
                    this.myCallExpression.replace(statement.getExpression());
                }
            } else if (replacementTarget != null) {
                replacementTarget.replace((PsiElement)statement.getExpression());
            }
        }

        private boolean shouldMoveComments(@NotNull JSSourceElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "shouldMoveComments"));
            }
            if (this.myDestructuringElement != null && element instanceof JSVarStatement) {
                JSVariable[] variables;
                for (JSVariable variable : variables = ((JSVarStatement)element).getVariables()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)this.myDestructuringElement, (PsiElement)variable, (boolean)true)) continue;
                    return false;
                }
                return true;
            }
            if (element instanceof JSVarStatement && ((JSVarStatement)element).getVariables().length == 1 && ((JSVarStatement)element).getVariables()[0] == this.myOwnerVariable) {
                return true;
            }
            return element instanceof JSExpressionStatement && ((JSExpressionStatement)element).getExpression() == this.myCallExpression;
        }

        private PsiElement createImport(@NotNull String requireText) {
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "createImport"));
            }
            PsiElement parent = this.myCallExpression.getParent();
            String prefixText = this.getPrefixText(requireText, parent);
            if (prefixText == null) {
                return null;
            }
            Project project = this.myCallExpression.getProject();
            return this.createImport(project, requireText, prefixText);
        }

        @NotNull
        private PsiElement createImport(Project project, @NotNull String requireText, String prefixText) {
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "createImport"));
            }
            JSCodeStyleSettings styleSettings = JSCodeStyleSettings.getSettings((PsiElement)this.myCallExpression);
            boolean singleQuotes = !styleSettings.USE_DOUBLE_QUOTES;
            char quote = singleQuotes ? (char)'\'' : '\"';
            ES6ImportDeclaration importStatement = (ES6ImportDeclaration)JSChangeUtil.createStatementFromText(project, "import " + prefixText + " from " + quote + requireText + quote + JSCodeStyleSettings.getSemicolon(project)).getPsi(ES6ImportDeclaration.class);
            ES6ImportDeclaration importDeclaration = this.createImportInProperPlace(importStatement);
            Object element = PsiTreeUtil.findChildOfType((PsiElement)importDeclaration, ES6ImportedBinding.class);
            if (element == null) {
                ES6ImportSpecifier specifier = (ES6ImportSpecifier)PsiTreeUtil.findChildOfType((PsiElement)importDeclaration, ES6ImportSpecifier.class);
                element = specifier != null && specifier.getAlias() != null && specifier.getAlias().getNameIdentifier() != null ? specifier.getAlias().getNameIdentifier() : specifier;
            }
            assert (element != null);
            PsiElement psiElement = element;
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "createImport"));
            }
            return psiElement;
        }

        private ES6ImportDeclaration createImportInProperPlace(ES6ImportDeclaration importStatement) {
            PsiElement lastImportAnchor = new LastImportInScope(true).withNoticeRequire(false).findAndSelect(this.myTopElement);
            if (lastImportAnchor != null && lastImportAnchor.getTextOffset() < this.myCallExpression.getTextOffset()) {
                return (ES6ImportDeclaration)this.myTopElement.addAfter((PsiElement)importStatement, LastImportInScope.lastCommentAnchorCorrection(lastImportAnchor));
            }
            PsiElement anchor = this.myTopElement.getFirstChild();
            if (anchor != null && !(anchor instanceof PsiComment) && !(anchor instanceof JSSourceElement)) {
                JSSourceElement sourceElement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)anchor, JSSourceElement.class);
                if (sourceElement != null) {
                    anchor = sourceElement;
                } else {
                    PsiElement current = anchor.getNextSibling();
                    while (current instanceof PsiWhiteSpace) {
                        current = anchor.getNextSibling();
                    }
                    if (current != null) {
                        anchor = current;
                    }
                }
            }
            if (anchor != null) {
                return (ES6ImportDeclaration)this.myTopElement.addBefore((PsiElement)importStatement, anchor);
            }
            return (ES6ImportDeclaration)this.myTopElement.add((PsiElement)importStatement);
        }

        @Nullable
        private String getPrefixText(@NotNull String requireText, PsiElement parent) {
            String prefixText;
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "getPrefixText"));
            }
            String string = prefixText = this.myOwnerVariable != null ? this.myOwnerVariable.getName() : this.calculateVariableName(requireText);
            if (parent instanceof JSReferenceExpression) {
                if (this.myFirstReferenceText == null) {
                    return null;
                }
                if ("default".equals(this.myFirstReferenceText)) {
                    return prefixText;
                }
                prefixText = this.myHasReferenceTail || this.myFirstReferenceText.equals(prefixText) ? "{" + this.myFirstReferenceText + "}" : "{" + this.myFirstReferenceText + " as " + prefixText + "}";
            }
            if (prefixText == null) {
                return null;
            }
            return prefixText;
        }

        private void init() {
            this.findTopElement();
            this.initFirstReference();
            this.lookupOwnerVariable();
        }

        private void initFirstReference() {
            PsiElement parent = this.myCallExpression.getParent();
            if (parent instanceof JSReferenceExpression) {
                String fullReferenceText = parent.getText();
                this.myFirstReference = parent;
                String callText = this.myCallExpression.getText();
                if (!fullReferenceText.startsWith(callText) || fullReferenceText.length() == callText.length()) {
                    return;
                }
                this.myFirstReferenceText = fullReferenceText.substring(callText.length() + 1);
            }
        }

        private void lookupOwnerVariable() {
            PsiElement current = this.myCallExpression.getParent();
            while (current instanceof JSReferenceExpression) {
                current = current.getParent();
            }
            if (current instanceof JSDestructuringElement && current.getParent() instanceof JSVarStatement && ((JSDestructuringElement)current).getInitializer() != null && PsiTreeUtil.isAncestor((PsiElement)((JSDestructuringElement)current).getInitializer(), (PsiElement)this.myCallExpression, (boolean)false)) {
                this.myDestructuringElement = (JSDestructuringElement)current;
            }
            PsiElement previous = null;
            current = this.myCallExpression.getParent();
            int refCnt = 0;
            while (current instanceof JSReferenceExpression || previous != null && current instanceof JSCallExpression && !Worker.isInCallArgumentsList(previous)) {
                if (current instanceof JSReferenceExpression) {
                    ++refCnt;
                }
                previous = current;
                current = current.getParent();
            }
            boolean bl = this.myHasReferenceTail = refCnt > 1 || refCnt == 1 && previous instanceof JSCallExpression;
            if (current instanceof JSVariable) {
                this.myOwnerVariable = (JSVariable)current;
            }
        }

        private static boolean isInCallArgumentsList(PsiElement current) {
            return PsiTreeUtil.isAncestor((PsiElement)((JSCallExpression)current.getParent()).getArgumentList(), (PsiElement)current, (boolean)true);
        }

        private String calculateVariableName(@NotNull String requireText) {
            String varNameCandidate;
            if (requireText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requireText", "com/intellij/lang/javascript/inspections/ES6ConvertRequireIntoImportQuickFix$Worker", "calculateVariableName"));
            }
            if (this.myTopElement == null) {
                return null;
            }
            Set existingNames = ES6ConvertRequireIntoImportQuickFix.collectExistingNames(this.myTopElement);
            if (this.myFirstReferenceText != null && !"default".equals(this.myFirstReferenceText)) {
                varNameCandidate = this.myFirstReferenceText;
            } else {
                String[] split = ES6ConvertRequireIntoImportInspection.cutRelativePathStartAndForwardSlash(requireText).split("/");
                varNameCandidate = split[0];
            }
            varNameCandidate = varNameCandidate.replace('-', '_');
            varNameCandidate = StringUtil.isEmptyOrSpaces((String)varNameCandidate) || !Character.isLetter(varNameCandidate.charAt(0)) ? "generated" : varNameCandidate;
            for (int i = 0; i < 1000 && existingNames.contains(varNameCandidate); ++i) {
                varNameCandidate = varNameCandidate + i;
            }
            return varNameCandidate;
        }

        private void findTopElement() {
            JSSourceElement statement;
            this.myTopElement = this.myCallExpression.getContainingFile();
            if (!(this.myTopElement instanceof JSFile)) {
                this.myTopElement = PsiTreeUtil.getParentOfType((PsiElement)this.myCallExpression, JSEmbeddedContent.class);
            }
            this.myIsTopLevelStatement = (statement = (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)this.myCallExpression, JSSourceElement.class)) != null && statement.getParent() == this.myTopElement ? statement : null;
        }
    }
}

