/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.intentions.JSStringConcatenationToES6TemplateHelper;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ES6ConvertToTemplateStringHelper {
    private static final Set<Class<? extends JSExpression>> ACCEPTED_EXPRESSIONS = ContainerUtil.set((Object[])new Class[]{JSCallExpression.class, JSReferenceExpression.class, JSPostfixExpression.class, JSPrefixExpression.class, JSIndexedPropertyAccessExpression.class});
    @NotNull
    private final Unit myMain;

    public ES6ConvertToTemplateStringHelper(@NotNull JSExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/lang/javascript/intentions/ES6ConvertToTemplateStringHelper", "<init>"));
        }
        this.myMain = new Unit((PsiElement)expression);
    }

    public void process() {
        ContainerUtil.process((Iterable)this.traverser().postOrderDfsTraversal(), unit -> {
            for (Unit child : unit.getChildren()) {
                ((Unit)unit).myAttributes.mergeChild(child.myAttributes);
            }
            return true;
        });
    }

    @NotNull
    private JBTreeTraverser<Unit> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(unit -> unit.getChildren()).withRoot((Object)this.myMain);
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertToTemplateStringHelper", "traverser"));
        }
        return jBTreeTraverser;
    }

    public boolean isValid() {
        return !this.myMain.myAttributes.myNotPlusSign && !this.myMain.myAttributes.myWrong && this.myMain.myAttributes.myStringLiteral && (this.myMain.myAttributes.myReference || this.myMain.myAttributes.myNonStringLiteral);
    }

    public String convert() {
        StringBuilder sb = new StringBuilder("`");
        ContainerUtil.process((Iterable)this.traverser().preOrderDfsTraversal(), unit -> {
            if (((Unit)unit).myAttributes.myNotPlusSign || ((Unit)unit).myAttributes.myBinaryContents || !((Unit)unit).myAttributes.myStringLiteral && !((Unit)unit).myAttributes.myNonStringLiteral) {
                ((Unit)unit).mySkipChildren = true;
                PsiElement element = ((Unit)unit).myElement instanceof JSParenthesizedExpression ? ((JSParenthesizedExpression)((Unit)unit).myElement).getInnerExpression() : ((Unit)unit).myElement;
                String text = JSStringConcatenationToES6TemplateHelper.unquoteUnescapeEscape(element);
                if (!StringUtil.isEmptyOrSpaces((String)text)) {
                    sb.append("${").append(text).append("}");
                }
            } else if (unit.getChildren().isEmpty()) {
                sb.append(JSStringConcatenationToES6TemplateHelper.unquoteUnescapeEscape(((Unit)unit).myElement));
            }
            return true;
        });
        sb.append("`");
        return sb.toString();
    }

    private static class Attributes {
        private boolean myStringLiteral;
        private boolean myReference;
        private boolean myNonStringLiteral;
        private boolean myWrong;
        private boolean myNotPlusSign;
        private boolean myBinaryContents;

        private Attributes() {
        }

        public void mergeChild(@NotNull Attributes child) {
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/lang/javascript/intentions/ES6ConvertToTemplateStringHelper$Attributes", "mergeChild"));
            }
            this.myWrong |= child.myWrong;
            this.myStringLiteral |= child.myStringLiteral;
            this.myReference |= child.myReference;
            this.myNonStringLiteral |= child.myNonStringLiteral;
            this.myBinaryContents |= this.myBinaryContents;
            if (child.myStringLiteral) {
                this.myNotPlusSign |= child.myNotPlusSign;
            }
        }
    }

    private static class Unit {
        private final PsiElement myElement;
        private final Attributes myAttributes;
        private List<Unit> myChildren;
        private boolean mySkipChildren;

        public Unit(PsiElement element) {
            this.myElement = element;
            this.myAttributes = new Attributes();
        }

        public List<Unit> getChildren() {
            if (this.mySkipChildren) {
                return Collections.emptyList();
            }
            if (this.myChildren == null) {
                this.myChildren = this.findChildren();
            }
            return this.myChildren;
        }

        @NotNull
        private List<Unit> findChildren() {
            List list = Collections.emptyList();
            if (this.myElement instanceof JSBinaryExpression) {
                JSBinaryExpression binary = (JSBinaryExpression)this.myElement;
                if (binary.getOperationSign() != JSTokenTypes.PLUS) {
                    this.myAttributes.myNotPlusSign = true;
                }
                list = ContainerUtil.filter((Collection)ContainerUtil.list((Object[])new JSExpression[]{binary.getLOperand(), binary.getROperand()}), expression -> expression != null);
            } else if (this.myElement instanceof JSParenthesizedExpression) {
                JSExpression innerExpression = ((JSParenthesizedExpression)this.myElement).getInnerExpression();
                if (innerExpression != null) {
                    list = ContainerUtil.list((Object[])new JSExpression[]{innerExpression});
                }
            } else if (this.myElement instanceof JSConditionalExpression) {
                this.myAttributes.myBinaryContents = true;
                this.myAttributes.myReference = true;
                JSConditionalExpression conditional = (JSConditionalExpression)this.myElement;
                list = ContainerUtil.filter((Collection)ContainerUtil.list((Object[])new JSExpression[]{conditional.getThen(), conditional.getElse()}), expression -> expression != null);
            } else if (this.myElement instanceof JSLiteralExpression) {
                if (((JSLiteralExpression)this.myElement).isQuotedLiteral()) {
                    this.myAttributes.myStringLiteral = true;
                } else {
                    this.myAttributes.myNonStringLiteral = true;
                }
            } else {
                Class<?> elementClass = this.myElement.getClass();
                boolean found = false;
                for (Class aClass : ACCEPTED_EXPRESSIONS) {
                    if (!aClass.isAssignableFrom(elementClass)) continue;
                    found = true;
                    this.myAttributes.myReference = true;
                    break;
                }
                if (!found) {
                    this.myAttributes.myWrong = true;
                }
            }
            List list2 = ContainerUtil.map(list, expression -> new Unit((PsiElement)expression));
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/intentions/ES6ConvertToTemplateStringHelper$Unit", "findChildren"));
            }
            return list2;
        }
    }
}

