/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSPredefinedLibraryRenamingManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryUtil;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@State(name="JavaScriptLibraryMappings", storages={@Storage(value="jsLibraryMappings.xml")})
public class JSLibraryMappings
extends ScriptingLibraryMappings {
    static final String COMPONENT_NAME = "JavaScriptLibraryMappings";
    static final String EXCLUDED_PREDEFINED_LIBRARY = "excludedPredefinedLibrary";
    static final String INCLUDED_PREDEFINED_LIBRARY = "includedPredefinedLibrary";
    static final String PREDEFINED_LIBRARY_NAME = "name";
    private final Set<String> myExcludedPredefinedLibraryNames = new TreeSet<String>();
    private final Set<String> myIncludedPredefinedLibraryNames = new TreeSet<String>();
    private ScriptingLibraryManager myLibraryManager;
    private JSPredefinedLibraryRenamingManager myPredefinedLibraryRenamingManager;

    public JSLibraryMappings(Project project) {
        super(project);
        this.setMissingPredefinedLibraries();
        ScriptingLibraryUtil.registerJSLibraryMappings((Project)project, (ScriptingLibraryMappings)this);
    }

    @NotNull
    protected ScriptingLibraryManager getLibraryManager() {
        if (this.myLibraryManager == null) {
            this.myLibraryManager = (ScriptingLibraryManager)ServiceManager.getService((Project)this.getProject(), JSLibraryManager.class);
        }
        ScriptingLibraryManager scriptingLibraryManager = this.myLibraryManager;
        if (scriptingLibraryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryMappings", "getLibraryManager"));
        }
        return scriptingLibraryManager;
    }

    public void loadState(Element state) {
        this.setMapping(null, null);
        this.myExcludedPredefinedLibraryNames.clear();
        List excludedLibraries = state.getChildren(EXCLUDED_PREDEFINED_LIBRARY);
        for (Element predefLibrary : excludedLibraries) {
            Attribute libName = predefLibrary.getAttribute(PREDEFINED_LIBRARY_NAME);
            if (libName == null) continue;
            String presentationName = this.getPredefinedLibraryPresentationName(libName.getValue());
            this.myExcludedPredefinedLibraryNames.add(presentationName);
        }
        List includedLibraries = state.getChildren(INCLUDED_PREDEFINED_LIBRARY);
        for (Element predefLibrary : includedLibraries) {
            Attribute libName = predefLibrary.getAttribute(PREDEFINED_LIBRARY_NAME);
            if (libName == null) continue;
            String presentationName = this.getPredefinedLibraryPresentationName(libName.getValue());
            this.myIncludedPredefinedLibraryNames.add(presentationName);
        }
        super.loadState(state);
        this.setMissingPredefinedLibraries();
    }

    public Element getState() {
        String serializationName;
        Element predefLibsElement;
        Element e = super.getState();
        assert (e != null);
        this.updateLibraryStates();
        for (String libName : this.myIncludedPredefinedLibraryNames) {
            predefLibsElement = new Element(INCLUDED_PREDEFINED_LIBRARY);
            serializationName = this.getPredefinedLibrarySerializationName(libName);
            predefLibsElement.setAttribute(new Attribute(PREDEFINED_LIBRARY_NAME, serializationName));
            e.addContent(predefLibsElement);
        }
        for (String libName : this.myExcludedPredefinedLibraryNames) {
            predefLibsElement = new Element(EXCLUDED_PREDEFINED_LIBRARY);
            serializationName = this.getPredefinedLibrarySerializationName(libName);
            predefLibsElement.setAttribute(new Attribute(PREDEFINED_LIBRARY_NAME, serializationName));
            e.addContent(predefLibsElement);
        }
        return e;
    }

    @NotNull
    protected String getPredefinedLibraryPresentationName(@NotNull String serializationName) {
        if (serializationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serializationName", "com/intellij/lang/javascript/library/JSLibraryMappings", "getPredefinedLibraryPresentationName"));
        }
        String presentationName = this.getRenamingManager().getPresentationNameBySerializationName(serializationName);
        String string = (String)ObjectUtils.notNull((Object)presentationName, (Object)serializationName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryMappings", "getPredefinedLibraryPresentationName"));
        }
        return string;
    }

    @NotNull
    protected String getPredefinedLibrarySerializationName(@NotNull String presentationName) {
        if (presentationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentationName", "com/intellij/lang/javascript/library/JSLibraryMappings", "getPredefinedLibrarySerializationName"));
        }
        String serializationName = this.getRenamingManager().getSerializationNameByPresentationName(presentationName);
        String string = (String)ObjectUtils.notNull((Object)serializationName, (Object)presentationName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryMappings", "getPredefinedLibrarySerializationName"));
        }
        return string;
    }

    @NotNull
    private JSPredefinedLibraryRenamingManager getRenamingManager() {
        JSPredefinedLibraryRenamingManager manager = this.myPredefinedLibraryRenamingManager;
        if (manager == null) {
            this.myPredefinedLibraryRenamingManager = manager = new JSPredefinedLibraryRenamingManager();
        }
        JSPredefinedLibraryRenamingManager jSPredefinedLibraryRenamingManager = manager;
        if (jSPredefinedLibraryRenamingManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryMappings", "getRenamingManager"));
        }
        return jSPredefinedLibraryRenamingManager;
    }

    private void setMissingPredefinedLibraries() {
        ScriptingLibraryManager libManager = this.getLibraryManager();
        for (ScriptingLibraryModel model : libManager.getPredefinedLibraries()) {
            String libraryName = model.getName();
            if (this.myIncludedPredefinedLibraryNames.contains(libraryName)) {
                this.associate(null, libraryName, true);
                continue;
            }
            List mappings = this.getMappingsByLibraryName(libraryName);
            if (!mappings.isEmpty() || this.myExcludedPredefinedLibraryNames.contains(libraryName)) continue;
            List defaultMappings = model.getDefaultMappings();
            for (VirtualFile file : defaultMappings) {
                this.associate(file, libraryName, true);
            }
        }
    }

    private void updateLibraryStates() {
        this.myExcludedPredefinedLibraryNames.clear();
        this.myIncludedPredefinedLibraryNames.clear();
        for (ScriptingLibraryModel model : this.getLibraryManager().getPredefinedLibraries()) {
            List mappings;
            List defaultMappings = model.getDefaultMappings();
            if (defaultMappings.equals(mappings = this.getMappingsByLibraryName(model.getName()))) continue;
            if (mappings.isEmpty()) {
                this.myExcludedPredefinedLibraryNames.add(model.getName());
                continue;
            }
            if (!defaultMappings.isEmpty() || !JSLibraryMappings.isAssociatedWithProject((List)mappings)) continue;
            this.myIncludedPredefinedLibraryNames.add(model.getName());
        }
    }

    @NotNull
    public static JSLibraryMappings getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/JSLibraryMappings", "getInstance"));
        }
        JSLibraryMappings jSLibraryMappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        if (jSLibraryMappings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryMappings", "getInstance"));
        }
        return jSLibraryMappings;
    }

    @NotNull
    public Set<VirtualFile> getLibraryFilesFor(VirtualFile file) {
        Set files = super.getLibraryFilesFor(file);
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        Set set = files;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/JSLibraryMappings", "getLibraryFilesFor"));
        }
        return set;
    }
}

