/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library.ui;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.documentation.JSExternalLibraryDocBundle;
import com.intellij.lang.javascript.library.JSLibraryKind;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.library.download.JSDownloadManager;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.util.net.IOExceptionDialog;
import com.intellij.util.ui.JBUI;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSScriptingContextProvider
extends LangScriptingContextProvider {
    private static final Logger LOG = Logger.getInstance(JSScriptingContextProvider.class);

    @NotNull
    public Language getLanguage() {
        JavascriptLanguage javascriptLanguage = JavascriptLanguage.INSTANCE;
        if (javascriptLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getLanguage"));
        }
        return javascriptLanguage;
    }

    public PersistentLibraryKind getLibraryKind() {
        return JSLibraryKind.INSTANCE;
    }

    public ScriptingLibraryManager getLibraryManager(Project project) {
        return (ScriptingLibraryManager)ServiceManager.getService((Project)project, JSLibraryManager.class);
    }

    public boolean acceptsExtension(String fileExt) {
        if (fileExt != null) {
            for (String extension : JSFileReference.IMPLICIT_EXTENSIONS) {
                if (!fileExt.regionMatches(true, 0, extension, 1, fileExt.length())) continue;
                return true;
            }
        }
        return false;
    }

    public ScriptingLibraryMappings getLibraryMappings(Project project) {
        JSLibraryMappings mappings = (JSLibraryMappings)((Object)ServiceManager.getService((Project)project, JSLibraryMappings.class));
        assert (mappings != null);
        return mappings;
    }

    public boolean isCompact(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "isCompact"));
        }
        return JSMinifiedFileUtil.isFileContentMinified(file);
    }

    @Nullable
    public String getLibraryTypeName(OrderRootType rootType) {
        if (rootType == OrderRootType.CLASSES) {
            return "Release";
        }
        if (rootType == OrderRootType.SOURCES) {
            return "Debug";
        }
        return null;
    }

    public String getDefaultDocUrl(@NotNull ScriptingFrameworkDescriptor framework) {
        if (framework == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "framework", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getDefaultDocUrl"));
        }
        String baseKey = JSExternalLibraryDocBundle.getBaseKey(framework.getFrameworkName(), framework.getFrameworkVersion());
        if (baseKey != null) {
            return JSExternalLibraryDocBundle.getBaseUrl(baseKey);
        }
        return null;
    }

    @Nullable
    public ScriptingFrameworkDescriptor detectFramework(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "detectFramework"));
        }
        return JSProjectUtil.detectFramework(file.getUrl());
    }

    @Nullable
    public String getOfflineDocUrl(String defaultDocUrl) {
        String baseKey = JSExternalLibraryDocBundle.getBaseURLKey(defaultDocUrl);
        if (baseKey != null) {
            return JSExternalLibraryDocBundle.getOfflineDocUrl(baseKey);
        }
        return null;
    }

    public void downloadOfflineDoc(@NotNull Project project, @NotNull String offlineDocUrl, @Nullable Component notificationAreaComponent, @NotNull Consumer<File> onDownloadedFile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "downloadOfflineDoc"));
        }
        if (offlineDocUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offlineDocUrl", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "downloadOfflineDoc"));
        }
        if (onDownloadedFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDownloadedFile", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "downloadOfflineDoc"));
        }
        JSScriptingContextProvider.doDownload(project, Collections.singletonList(offlineDocUrl), "Downloading documentation", notificationAreaComponent, (Consumer<List<File>>)((Consumer)files -> {
            if (onDownloadedFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onDownloadedFile", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$downloadOfflineDoc$0"));
            }
            onDownloadedFile.consume(ContainerUtil.getFirstItem((List)files));
        }));
    }

    private static void doDownload(final @NotNull Project project, final @NotNull Collection<String> urls, @NotNull String progressTitle, final @Nullable Component notificationAreaComponent, final @NotNull Consumer<List<File>> downloadedFilesConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doDownload"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doDownload"));
        }
        if (progressTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressTitle", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doDownload"));
        }
        if (downloadedFilesConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadedFilesConsumer", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doDownload"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final ModalityState modalityState = ModalityState.current();
        Task.Backgroundable task = new Task.Backgroundable(project, progressTitle, true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$1", "run"));
                }
                ArrayList result = ContainerUtil.newArrayList();
                ArrayList downloadedUrls = ContainerUtil.newArrayList();
                StepProgressIndicator stepIndicator = new StepProgressIndicator(indicator, urls.size());
                for (String url : urls) {
                    if (indicator.isCanceled()) {
                        return;
                    }
                    File file = JSScriptingContextProvider.doDownloadUrl(indicator, url);
                    stepIndicator.onStepDone();
                    if (file == null) continue;
                    result.add(file);
                    downloadedUrls.add(url);
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$1", "lambda$run$0"));
                    }
                    if (downloadedFilesConsumer == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "downloadedFilesConsumer", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$1", "lambda$run$0"));
                    }
                    if (notificationAreaComponent != null) {
                        JSScriptingContextProvider.notifyAboutSuccessfulDownload(project, notificationAreaComponent, downloadedUrls);
                    }
                    downloadedFilesConsumer.consume((Object)result);
                }, modalityState);
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    @Nullable
    private static File doDownloadUrl(@Nullable ProgressIndicator progressIndicator, @NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doDownloadUrl"));
        }
        JSDownloadManager downloadManager = new JSDownloadManager(null);
        downloadManager.setProgressIndicator(progressIndicator);
        boolean tryAgain = true;
        while (tryAgain) {
            downloadManager.download(url, JSExternalLibraryDocBundle.getOfflineDocExt(url));
            if (downloadManager.getLastError() == null) {
                String targetFilePath = downloadManager.getTargetFilePath();
                return targetFilePath != null ? new File(targetFilePath) : null;
            }
            tryAgain = IOExceptionDialog.showErrorDialog((String)"Download Error", (String)("Cannot download " + url + ". " + downloadManager.getLastError()));
        }
        return null;
    }

    @NotNull
    public DownloadableFileSetVersions<DownloadableFileSetDescription> getDownloadableLibraryDescriptors(Project project) {
        URL localUrl = JSDownloadManager.class.getResource("jslibraries.xml");
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions("javascript", new URL[]{localUrl});
        if (downloadableFileSetVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getDownloadableLibraryDescriptors"));
        }
        return downloadableFileSetVersions;
    }

    public void filterExistingLibraries(@NotNull Project project, @NotNull List<? extends DownloadableFileSetDescription> descriptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "filterExistingLibraries"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "filterExistingLibraries"));
        }
        JSScriptingContextProvider.doFilterExistingLibraries(project, descriptions);
    }

    private static <T extends DownloadableFileSetDescription> void doFilterExistingLibraries(@NotNull Project project, @NotNull List<T> descriptions) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doFilterExistingLibraries"));
        }
        if (descriptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "doFilterExistingLibraries"));
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$doFilterExistingLibraries$1"));
            }
            if (descriptions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptions", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$doFilterExistingLibraries$1"));
            }
            if (project.isDisposed()) {
                return;
            }
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            ArrayList<DownloadableFileSetDescription> toRemove = new ArrayList<DownloadableFileSetDescription>();
            for (DownloadableFileSetDescription description : descriptions) {
                String ideLibName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
                if (libraryManager.getLibraryByName(ideLibName) == null) continue;
                toRemove.add(description);
            }
            descriptions.removeAll(toRemove);
        });
    }

    public void downloadLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @Nullable Component notificationAreaComponent, @Nullable Runnable onLibraryCreated) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "downloadLibrary"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "downloadLibrary"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ModalityState modalityState = ModalityState.current();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$downloadLibrary$4"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$downloadLibrary$4"));
            }
            try {
                List urls = ContainerUtil.mapNotNull((Collection)description.getFiles(), DownloadableFileDescription::getDownloadUrl);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$null$3"));
                    }
                    if (description == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$null$3"));
                    }
                    JSScriptingContextProvider.doDownload(project, ContainerUtil.newLinkedHashSet((Iterable)urls), "Downloading library", notificationAreaComponent, (Consumer<List<File>>)((Consumer)downloadedFiles -> {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$null$2"));
                        }
                        if (description == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$null$2"));
                        }
                        boolean created = this.createLibrary(project, description, (List<File>)downloadedFiles);
                        if (created && onLibraryCreated != null) {
                            onLibraryCreated.run();
                        }
                    }));
                }, modalityState);
            }
            catch (Exception e) {
                LOG.warn("Cannot determine library URLs, no library created", (Throwable)e);
            }
        });
    }

    private boolean createLibrary(@NotNull Project project, @NotNull DownloadableFileSetDescription description, @NotNull List<File> libraryFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "createLibrary"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "createLibrary"));
        }
        if (libraryFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "createLibrary"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (libraryFiles.isEmpty()) {
            return false;
        }
        return (Boolean)WriteAction.compute(() -> {
            String baseUrl;
            if (libraryFiles == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryFiles", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$createLibrary$6"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$createLibrary$6"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "lambda$createLibrary$6"));
            }
            List files = ContainerUtil.mapNotNull((Collection)libraryFiles, file -> VfsUtil.findFileByIoFile((File)file, (boolean)true));
            if (files.isEmpty()) {
                return false;
            }
            String libName = JSScriptingContextProvider.getIdeLibraryName((DownloadableFileSetDescription)description);
            JSLibraryManager libraryManager = JSLibraryManager.getInstance(project);
            LibraryTable libTable = libraryManager.getLibraryTable(ScriptingLibraryModel.LibraryLevel.GLOBAL);
            Library library = libTable.getLibraryByName(libName);
            if (library != null) {
                return false;
            }
            ScriptingFrameworkDescriptor framework = this.detectFramework((VirtualFile)files.iterator().next());
            String[] docUrls = ArrayUtil.EMPTY_STRING_ARRAY;
            if (framework != null && (baseUrl = this.getDefaultDocUrl(framework)) != null) {
                docUrls = new String[]{baseUrl};
            }
            ScriptingLibraryModel libModel = libraryManager.createLibrary(libName, VfsUtilCore.toVirtualFileArray((Collection)files), VirtualFile.EMPTY_ARRAY, docUrls, ScriptingLibraryModel.LibraryLevel.GLOBAL, false);
            if (framework != null) {
                libModel.setFrameworkDescriptor(framework);
            }
            libraryManager.commitChanges();
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
            mappings.associate(null, libName);
            return true;
        });
    }

    private static void notifyAboutSuccessfulDownload(@NotNull Project project, @NotNull Component notificationAreaComponent, @NotNull List<String> urls) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "notifyAboutSuccessfulDownload"));
        }
        if (notificationAreaComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationAreaComponent", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "notifyAboutSuccessfulDownload"));
        }
        if (urls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urls", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "notifyAboutSuccessfulDownload"));
        }
        String info = urls.size() == 1 ? urls.get(0) : StringUtil.join(urls, url -> "<div>" + url + "</div>", (String)"");
        BalloonBuilder builder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder("Successfully downloaded " + info, null, MessageType.INFO.getPopupBackground(), null);
        builder.setShowCallout(false).setCloseButtonEnabled(true).setDisposable((Disposable)project);
        Rectangle bounds = notificationAreaComponent.getBounds();
        Point p = new Point(bounds.width / 2, bounds.height - JBUI.scale((int)40));
        RelativePoint point = new RelativePoint(notificationAreaComponent, p);
        Balloon balloon = builder.createBalloon();
        balloon.show(point, Balloon.Position.below);
    }

    public ScriptingFrameworkDescriptor[] getSupportedFrameworks(Project project) {
        Set<String> keys = JSExternalLibraryDocBundle.getBasePatternKeys();
        ArrayList<ScriptingFrameworkDescriptor> descriptors = new ArrayList<ScriptingFrameworkDescriptor>();
        for (String key : keys) {
            String name = JSExternalLibraryDocBundle.getLibraryName(key);
            descriptors.add(new ScriptingFrameworkDescriptor(name, null));
        }
        Collections.sort(descriptors, (d1, d2) -> {
            int nameResult;
            int n = nameResult = d1.getFrameworkName() != null ? d1.getFrameworkName().compareToIgnoreCase(d2.getFrameworkName()) : -1;
            if (nameResult != 0) {
                return nameResult;
            }
            return d1.getFrameworkVersion() != null ? d1.getFrameworkVersion().compareTo(d2.getFrameworkVersion()) : -1;
        });
        return descriptors.toArray(new ScriptingFrameworkDescriptor[descriptors.size()]);
    }

    @NotNull
    public Icon getFileIcon() {
        Icon icon = JavaScriptLanguageIcons.Library.JsLibrary;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider", "getFileIcon"));
        }
        return icon;
    }

    private static class StepProgressIndicator
    extends ProgressIndicatorBase {
        private final int myTotalSteps;
        private final AtomicInteger myFinishedSteps;
        private final ProgressIndicatorEx myRealIndicator;
        private boolean myUpdatingRealIndicatorFraction;

        public StepProgressIndicator(@NotNull ProgressIndicator realIndicator, int totalSteps) {
            if (realIndicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realIndicator", "com/intellij/lang/javascript/library/ui/JSScriptingContextProvider$StepProgressIndicator", "<init>"));
            }
            this.myFinishedSteps = new AtomicInteger(0);
            this.myUpdatingRealIndicatorFraction = false;
            this.myTotalSteps = totalSteps;
            this.myRealIndicator = (ProgressIndicatorEx)ObjectUtils.tryCast((Object)realIndicator, ProgressIndicatorEx.class);
            if (this.myRealIndicator != null) {
                this.myRealIndicator.addStateDelegate((ProgressIndicatorEx)this);
            }
        }

        public void setFraction(double stepFraction) {
            if (!this.myUpdatingRealIndicatorFraction) {
                stepFraction = Math.min(Math.max(stepFraction, 0.0), 1.0);
                double fraction = ((double)this.myFinishedSteps.get() + stepFraction) / (1.0 * (double)this.myTotalSteps);
                super.setFraction(fraction);
                this.myUpdatingRealIndicatorFraction = true;
                this.myRealIndicator.setFraction(fraction);
                this.myUpdatingRealIndicatorFraction = false;
            }
        }

        public void onStepDone() {
            this.myFinishedSteps.incrementAndGet();
        }
    }
}

