/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterEditSettingsAction;
import com.intellij.lang.javascript.linter.JSLinterExternalAnnotator;
import com.intellij.lang.javascript.linter.JSLinterFileLevelAnnotation;
import com.intellij.lang.javascript.linter.JSLinterState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterInput<T extends JSLinterState> {
    private final Project myProject;
    private final PsiFile myPsiFile;
    private final String myFileContent;
    private final T myState;
    private final EditorColorsScheme myColorsScheme;
    private final JSLinterExternalAnnotator<T> myExternalAnnotator;
    private final Document myDocument;

    private JSLinterInput(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull Document document, @NotNull String fileContent, @NotNull T state, @Nullable EditorColorsScheme colorsScheme, @NotNull JSLinterExternalAnnotator<T> externalAnnotator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        if (externalAnnotator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotator", "com/intellij/lang/javascript/linter/JSLinterInput", "<init>"));
        }
        this.myProject = project;
        this.myPsiFile = psiFile;
        this.myDocument = document;
        this.myFileContent = fileContent;
        this.myState = state;
        this.myColorsScheme = colorsScheme;
        this.myExternalAnnotator = externalAnnotator;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getProject"));
        }
        return project;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getPsiFile"));
        }
        return psiFile;
    }

    @NotNull
    public Document getDocument() {
        Document document = this.myDocument;
        if (document == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getDocument"));
        }
        return document;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        VirtualFile virtualFile = this.myPsiFile.getViewProvider().getVirtualFile();
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    public String getFileContent() {
        String string = this.myFileContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getFileContent"));
        }
        return string;
    }

    @NotNull
    public T getState() {
        T t = this.myState;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "getState"));
        }
        return t;
    }

    @Nullable
    public EditorColorsScheme getColorsScheme() {
        return this.myColorsScheme;
    }

    @NotNull
    public JSLinterAnnotationResult<T> createFileLevelWarningResult(@NotNull String message, IntentionAction ... additionalFixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterInput", "createFileLevelWarningResult"));
        }
        JSLinterAnnotationResult<T> jSLinterAnnotationResult = this.createFileLevelAnnotationResult(message, HighlightSeverity.WARNING, additionalFixes);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "createFileLevelWarningResult"));
        }
        return jSLinterAnnotationResult;
    }

    @NotNull
    private JSLinterAnnotationResult<T> createFileLevelAnnotationResult(@NotNull String message, @NotNull HighlightSeverity severity, IntentionAction ... additionalFixes) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/lang/javascript/linter/JSLinterInput", "createFileLevelAnnotationResult"));
        }
        if (severity == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/lang/javascript/linter/JSLinterInput", "createFileLevelAnnotationResult"));
        }
        JSLinterEditSettingsAction editSettingsAction = new JSLinterEditSettingsAction(this.myExternalAnnotator.createSettingsConfigurable(this.myProject), true);
        JSLinterFileLevelAnnotation annotation = new JSLinterFileLevelAnnotation(this.myExternalAnnotator.getFileLevelAnnotationDefaultIcon(), message.replace('\n', ' '), severity, (IntentionAction[])ArrayUtil.append((Object[])additionalFixes, (Object)editSettingsAction));
        JSLinterAnnotationResult jSLinterAnnotationResult = JSLinterAnnotationResult.create(this, annotation);
        if (jSLinterAnnotationResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "createFileLevelAnnotationResult"));
        }
        return jSLinterAnnotationResult;
    }

    @NotNull
    public static <T extends JSLinterState> JSLinterInput<T> create(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull Document document, @NotNull String fileContent, @NotNull T state, @Nullable EditorColorsScheme colorsScheme, @NotNull JSLinterExternalAnnotator<T> externalAnnotator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (fileContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContent", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        if (externalAnnotator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalAnnotator", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        JSLinterInput<T> jSLinterInput = new JSLinterInput<T>(project, psiFile, document, fileContent, state, colorsScheme, externalAnnotator);
        if (jSLinterInput == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/JSLinterInput", "create"));
        }
        return jSLinterInput;
    }
}

