/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintExternalAnnotator;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.JSLinterReformatterTask;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintReformatterTask
extends JSLinterReformatterTask {
    private final EslintState myState;
    private final EslintExternalAnnotator myAnnotator;

    public EsLintReformatterTask(@Nullable Project project, @NotNull Collection<VirtualFile> roots) {
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "com/intellij/lang/javascript/linter/eslint/EsLintReformatterTask", "<init>"));
        }
        super(project, JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), roots);
        this.myState = (EslintState)EslintConfiguration.getInstance(this.myProject).getExtendedState().getState();
        this.myAnnotator = EslintExternalAnnotator.getInstanceForBatchInspection();
    }

    @Override
    protected void runLinter(@NotNull PsiFile psiFile, @NotNull Document document) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/javascript/linter/eslint/EsLintReformatterTask", "runLinter"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/javascript/linter/eslint/EsLintReformatterTask", "runLinter"));
        }
        VirtualFile file = psiFile.getVirtualFile();
        JSLinterInput<EslintState> input = JSLinterInput.create(this.myProject, psiFile, document, psiFile.getText(), this.myState, null, this.myAnnotator);
        JSLinterAnnotationResult<EslintState> result = new EsLintExternalRunner(false, true).execute(input);
        this.processLinterRunnerOutput(file, result);
    }
}

