/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.json.JsonLanguage;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.linter.JSLinterConfigLangSubstitutor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class EslintUtil {
    public static final String DEFAULT_IGNORE_FILENAME = ".eslintignore";
    public static final String PACKAGE_NAME = "eslint";
    public static final String DEFAULT_CONFIG_PREFIX = ".eslintrc";
    private static final String[] CONFIG_EXTENSIONS = new String[]{"", ".js", ".yaml", ".yml", ".json"};
    private static final String[] CONFIG_FILENAMES = new String[CONFIG_EXTENSIONS.length];
    private static final String PLUGINS = "plugins";
    private static final String HTML = "html";

    private EslintUtil() {
    }

    @NotNull
    public static String getAbsoluteOrRelativePathToProjectRoot(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        VirtualFile root = project.getBaseDir();
        if (root != null && VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)true)) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
                }
                return string;
            }
            String string = root.getName() + File.separatorChar + relativePath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "getAbsoluteOrRelativePathToProjectRoot"));
        }
        return string;
    }

    public static boolean isEslintConfigFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        PsiFile file = element.getContainingFile();
        if (file != null) {
            file = file.getOriginalFile();
        }
        return file != null && EslintUtil.isEslintConfigFile(file);
    }

    public static boolean isEslintConfigFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        return EslintUtil.isEslintConfigFile(file.getViewProvider().getVirtualFile());
    }

    public static boolean isEslintConfigFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "isEslintConfigFile"));
        }
        if (!file.isValid() || file.isDirectory()) {
            return false;
        }
        CharSequence name = file.getNameSequence();
        if (StringUtil.startsWith((CharSequence)name, (CharSequence)DEFAULT_CONFIG_PREFIX)) {
            for (String ext : CONFIG_EXTENSIONS) {
                if (name.length() != DEFAULT_CONFIG_PREFIX.length() + ext.length() || !StringUtil.endsWith((CharSequence)name, (CharSequence)ext)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsUpFileSystem(@NotNull VirtualFile fileToLint) {
        if (fileToLint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileToLint", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsUpFileSystem"));
        }
        List configs = ContainerUtil.newSmartList();
        for (VirtualFile dir = fileToLint.getParent(); dir != null; dir = dir.getParent()) {
            EslintUtil.addAllConfigsFromDir(dir, configs);
        }
        List list = configs;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsUpFileSystem"));
        }
        return list;
    }

    private static void addAllConfigsFromDir(@NotNull VirtualFile dir, @NotNull List<VirtualFile> configs) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "addAllConfigsFromDir"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "addAllConfigsFromDir"));
        }
        for (String name : CONFIG_FILENAMES) {
            VirtualFile file = dir.findChild(name);
            if (file == null || !file.isValid() || file.isDirectory()) continue;
            configs.add(file);
        }
    }

    @NotNull
    public static List<VirtualFile> findAllConfigsInScope(@NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsInScope"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsInScope"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (String name : CONFIG_FILENAMES) {
            Collection files = FilenameIndex.getVirtualFilesByName((Project)project, (String)name, (GlobalSearchScope)scope);
            for (VirtualFile file : files) {
                if (!file.isValid() || file.isDirectory() || JSLibraryUtil.isProbableLibraryFile(file, project)) continue;
                result.add(file);
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "findAllConfigsInScope"));
        }
        return arrayList;
    }

    public static boolean configAllowsHtml(@NotNull Project project, @NotNull List<VirtualFile> configs) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configAllowsHtml"));
        }
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/javascript/linter/eslint/EslintUtil", "configAllowsHtml"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile config : configs) {
            Boolean cached = (Boolean)ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile psiFile = psiManager.findFile(config);
                if (psiFile == null) {
                    return null;
                }
                CachedValueProvider provider = () -> {
                    block9: {
                        if (config.getLength() >= (long)FileUtilRt.LARGE_FOR_CONTENT_LOADING) {
                            return null;
                        }
                        if (JSLinterConfigLangSubstitutor.YamlLanguageHolder.INSTANCE.equals(psiFile.getLanguage())) {
                            try {
                                String text = VfsUtilCore.loadText((VirtualFile)config);
                                int pluginsIdx = text.indexOf(PLUGINS);
                                if (pluginsIdx >= 0 && text.indexOf(HTML, pluginsIdx) >= 0) {
                                    return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{psiFile});
                                }
                                break block9;
                            }
                            catch (IOException e) {
                                return null;
                            }
                        }
                        if (psiFile.getLanguage().isKindOf((Language)JsonLanguage.INSTANCE)) {
                            PsiElement[] children;
                            JsonFile file = (JsonFile)ObjectUtils.tryCast((Object)psiFile, JsonFile.class);
                            if (file == null) {
                                return null;
                            }
                            for (PsiElement child : children = file.getChildren()) {
                                JsonProperty plugins;
                                JsonObject objectLiteralExpression = (JsonObject)ObjectUtils.tryCast((Object)child, JsonObject.class);
                                if (objectLiteralExpression == null || (plugins = objectLiteralExpression.findProperty(PLUGINS)) == null || !(plugins.getValue() instanceof JsonArray)) continue;
                                List list = ((JsonArray)plugins.getValue()).getValueList();
                                for (JsonValue value : list) {
                                    if (!(value instanceof JsonLiteral) || !((JsonLiteral)value).isQuotedString() || !HTML.equals(StringUtil.unquoteString((String)value.getText()))) continue;
                                    return CachedValueProvider.Result.create((Object)true, (Object[])new Object[]{psiFile});
                                }
                            }
                        }
                    }
                    return null;
                };
                return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiFile, (CachedValueProvider)provider);
            });
            if (cached == null) continue;
            return Boolean.TRUE.equals(cached);
        }
        return false;
    }

    static {
        for (int i = 0; i < CONFIG_EXTENSIONS.length; ++i) {
            EslintUtil.CONFIG_FILENAMES[i] = DEFAULT_CONFIG_PREFIX + CONFIG_EXTENSIONS[i];
        }
    }
}

