/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.tslint;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.idea.RareLogger;
import com.intellij.javascript.nodejs.NodePackageVersionUtil;
import com.intellij.lang.javascript.linter.FilesMirror;
import com.intellij.lang.javascript.linter.JSLinterAnnotationResult;
import com.intellij.lang.javascript.linter.JSLinterErrorBase;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.tslint.TsLintBinFileVersionManager;
import com.intellij.lang.javascript.linter.tslint.TsLintConfigFileChangeTracker;
import com.intellij.lang.javascript.linter.tslint.TsLintConfigFileSearcher;
import com.intellij.lang.javascript.linter.tslint.TsLintOutputParser;
import com.intellij.lang.javascript.linter.tslint.TsLintState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.Producer;
import com.intellij.util.PsiErrorElementUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.util.CommandLineUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class TsLintExternalRunner {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.linter.tslint.TsLint");
    private static final String INTERNAL_ERROR = "Internal TSLint problem. Please report the problem and attach the log using \"Help | Show Log in " + ShowFilePathAction.getFileManagerName() + "\"";
    public static final int TIMEOUT_IN_MILLISECONDS = (int)TimeUnit.SECONDS.toMillis(10L);
    private static final Logger RARE_LOGGER = RareLogger.wrap((Logger)LOG, (boolean)false);
    private static final SemVer VERSION_2_4_0 = new SemVer("2.4.0", 2, 4, 0);
    private final JSLinterInput<TsLintState> myInputInfo;
    private final FilesMirror myCodeFilesMirror;
    private final FilesMirror myConfigFilesMirror;
    private final TsLintBinFileVersionManager myBinFileVersionManager;
    private final Project myProject;
    private final List<Producer<JSLinterAnnotationResult<TsLintState>>> mySteps;
    private File myActualConfigFile;
    private File myActualCodeFile;
    private VirtualFile myConfigVirtualFile;
    private VirtualFile myCodeVirtualFile;
    private File myNodeFile;
    private File myPackageDir;
    private File myTsLintFile;
    private SemVer myTsLintVersion;
    private boolean myFix;
    private boolean mySkip;

    public TsLintExternalRunner(@NotNull JSLinterInput<TsLintState> inputInfo, @NotNull FilesMirror codeFilesMirror, @NotNull FilesMirror configFilesMirror, @NotNull TsLintBinFileVersionManager binFileVersionManager, @NotNull Project project) {
        if (inputInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputInfo", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (codeFilesMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeFilesMirror", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (configFilesMirror == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configFilesMirror", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (binFileVersionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binFileVersionManager", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/linter/tslint/TsLintExternalRunner", "<init>"));
        }
        this.myInputInfo = inputInfo;
        this.myCodeFilesMirror = codeFilesMirror;
        this.myConfigFilesMirror = configFilesMirror;
        this.myBinFileVersionManager = binFileVersionManager;
        this.myProject = project;
        this.mySteps = new ArrayList<Producer<JSLinterAnnotationResult<TsLintState>>>();
        this.mySteps.add(this.checkExePath());
        this.mySteps.add(this.checkTargetVirtualFile());
        this.mySteps.add(this.checkConfigPath());
        this.mySteps.add(this.checkIfTargetFileChanged());
        this.mySteps.add(this.runExternalProcess());
    }

    public JSLinterAnnotationResult<TsLintState> execute() {
        for (Producer<JSLinterAnnotationResult<TsLintState>> step : this.mySteps) {
            JSLinterAnnotationResult result = (JSLinterAnnotationResult)step.produce();
            if (result != null) {
                return result;
            }
            if (!this.mySkip) continue;
            return null;
        }
        return null;
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> runExternalProcess() {
        return () -> {
            CapturingProcessHandler processHandler;
            File workingDirectory = this.myActualCodeFile.getParentFile();
            if (workingDirectory == null) {
                LOG.debug("Skipped TSLint file analysis: can not find working directory for file: " + this.myActualCodeFile.getPath());
                this.mySkip = true;
                return null;
            }
            TsLintConfigFileChangeTracker.getInstance(this.myProject).startIfNeeded();
            GeneralCommandLine commandLine = this.createCommandLine(workingDirectory);
            try {
                processHandler = new CapturingProcessHandler(commandLine);
            }
            catch (ExecutionException e) {
                return this.createError("Can not start TSLint process: " + e.getMessage());
            }
            boolean zeroBasedRowCol = this.myTsLintVersion != null && (this.myTsLintVersion.getMajor() < 2 || this.myTsLintVersion.getMajor() == 2 && this.myTsLintVersion.getMinor() <= 1);
            TsLintOutputParser parser = new TsLintOutputParser(this.myActualCodeFile.getPath(), zeroBasedRowCol);
            processHandler.addProcessListener((ProcessListener)parser);
            ProcessOutput processOutput = processHandler.runProcess(TIMEOUT_IN_MILLISECONDS);
            if (processOutput.isTimeout()) {
                return JSLinterAnnotationResult.createLinterFailResult(this.myInputInfo, "Process timed out after " + DateFormatUtil.formatDuration((long)TIMEOUT_IN_MILLISECONDS), this.myConfigVirtualFile);
            }
            parser.process();
            JSLinterErrorBase error = parser.getGlobalError();
            if (error != null) {
                if (this.isInnerProblem(error)) {
                    if (PsiErrorElementUtil.hasErrors((Project)this.myProject, (VirtualFile)this.myCodeVirtualFile)) {
                        return JSLinterAnnotationResult.createLinterResult(this.myInputInfo, Collections.emptyList(), this.myConfigVirtualFile);
                    }
                    return JSLinterAnnotationResult.createLinterFailResult(this.myInputInfo, INTERNAL_ERROR, null);
                }
                return JSLinterAnnotationResult.createLinterFailResult(this.myInputInfo, error, this.myConfigVirtualFile);
            }
            return JSLinterAnnotationResult.createLinterResult(this.myInputInfo, parser.getErrors(), this.myConfigVirtualFile);
        };
    }

    private boolean isInnerProblem(JSLinterErrorBase error) {
        String description = error.getDescription();
        if (this.isStackTrace(description)) {
            String version = this.myTsLintVersion == null ? "unknown" : this.myTsLintVersion.getRawVersion();
            RARE_LOGGER.info("TsLint inner error. TsLint version: " + version + "\n\n" + description);
            return true;
        }
        return false;
    }

    private boolean isStackTrace(String description) {
        String[] lines = StringUtil.splitByLines((String)description);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains("Error") || i >= lines.length - 1 || !lines[i + 1].trim().startsWith("at ")) continue;
            return true;
        }
        return false;
    }

    private GeneralCommandLine createCommandLine(File workingDir) {
        boolean passOldFileFlag;
        String rulesDirectory;
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        CommandLineUtil.configureShellEnvironment((GeneralCommandLine)commandLine, (boolean)true, Collections.emptyMap());
        commandLine.withWorkDirectory(workingDir);
        commandLine.setExePath(this.myNodeFile.getAbsolutePath());
        commandLine.addParameter(this.myTsLintFile.getAbsolutePath());
        commandLine.addParameters(new String[]{"-t json"});
        if (this.myActualConfigFile != null) {
            commandLine.addParameters(new String[]{"-c", this.myActualConfigFile.getAbsolutePath()});
        }
        if (!StringUtil.isEmptyOrSpaces((String)(rulesDirectory = this.myInputInfo.getState().getRulesDirectory()))) {
            commandLine.addParameters(new String[]{"-r", rulesDirectory});
        }
        boolean bl = passOldFileFlag = this.myTsLintVersion != null && this.myTsLintVersion.compareTo(VERSION_2_4_0) < 0;
        if (passOldFileFlag) {
            commandLine.addParameter("-f");
        }
        commandLine.addParameters(new String[]{this.myActualCodeFile.getAbsolutePath()});
        return commandLine;
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkIfTargetFileChanged() {
        return () -> {
            PsiFile psiFile = this.myInputInfo.getPsiFile();
            this.myActualCodeFile = this.myCodeFilesMirror.getOrCreateFileWithActualContent(this.myCodeVirtualFile, this.myInputInfo.getFileContent());
            if (this.myActualCodeFile == null) {
                LOG.debug("Skipped TSLint file analysis: can not mirror target file in temp directory: " + psiFile.getName());
                this.mySkip = true;
            }
            return null;
        };
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkConfigPath() {
        return () -> {
            TsLintState state = this.myInputInfo.getState();
            if (state.isCustomConfigFileUsed()) {
                String configFilePath = state.getCustomConfigFilePath();
                if (StringUtil.isEmptyOrSpaces((String)configFilePath)) {
                    return this.createError("Configuration file for TSLint is not specified");
                }
                File configFile = new File(configFilePath);
                this.myConfigVirtualFile = VfsUtil.findFileByIoFile((File)configFile, (boolean)false);
                if (this.myConfigVirtualFile == null) {
                    return this.createError("Can not find configuration file for TSLint by path: " + configFilePath);
                }
            } else {
                TsLintConfigFileSearcher searcher = new TsLintConfigFileSearcher();
                this.myConfigVirtualFile = searcher.lookup(this.myInputInfo.getPsiFile().getVirtualFile());
                if (this.myConfigVirtualFile == null) {
                    return this.createError("Configuration file for TSLint is not found");
                }
            }
            this.myActualConfigFile = this.myConfigFilesMirror.getOrCreateFileWithActualContent(this.myConfigVirtualFile, null);
            if (this.myActualConfigFile == null) {
                LOG.debug("Skipped TSLint file analysis: can not mirror config file in temp directory: " + this.myConfigVirtualFile.getPath());
                this.mySkip = true;
            }
            return null;
        };
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkTargetVirtualFile() {
        return () -> {
            PsiFile psiFile = this.myInputInfo.getPsiFile();
            this.myCodeVirtualFile = psiFile.getVirtualFile();
            if (this.myCodeVirtualFile == null || !this.myCodeVirtualFile.isValid()) {
                LOG.debug("Skipped TSLint file analysis: can not load target file as virtual file: " + psiFile.getName());
                this.mySkip = true;
                return null;
            }
            return null;
        };
    }

    private Producer<JSLinterAnnotationResult<TsLintState>> checkExePath() {
        return () -> {
            TsLintState state = this.myInputInfo.getState();
            String nodePath = state.getNodePath();
            if (StringUtil.isEmptyOrSpaces((String)nodePath)) {
                return this.createError("Node interpreter file is not specified");
            }
            this.myNodeFile = new File(nodePath);
            if (!(this.myNodeFile.isFile() && this.myNodeFile.isAbsolute() && this.myNodeFile.canExecute())) {
                return this.createError("Node interpreter file is not found");
            }
            String packagePath = state.getPackagePath();
            if (StringUtil.isEmptyOrSpaces((String)packagePath)) {
                return this.createError("TSLint package directory is not specified");
            }
            this.myPackageDir = new File(packagePath);
            if (this.myPackageDir.isDirectory()) {
                if (!this.myPackageDir.isAbsolute()) {
                    return this.createError("TSLint package directory is not found");
                }
                this.myTsLintFile = new File(this.myPackageDir, "bin" + File.separator + "tslint");
                this.myTsLintVersion = NodePackageVersionUtil.getPackageVersion(this.myPackageDir);
            } else {
                this.myTsLintFile = this.myPackageDir;
                try {
                    this.myTsLintVersion = this.myBinFileVersionManager.getVersion(this.myNodeFile.getAbsolutePath(), this.myTsLintFile, Collections.singletonList("--version"), 10000L);
                }
                catch (ExecutionException e) {
                    LOG.info("Cannot fetch version of " + this.myTsLintFile.getAbsolutePath(), (Throwable)e);
                }
            }
            if (!this.myTsLintFile.exists()) {
                if (this.myTsLintFile == this.myPackageDir) {
                    return this.createError("Provided TSLint path does not exist");
                }
                return this.createError("Can not find 'tslint' script file under TSLint package directory");
            }
            return null;
        };
    }

    private JSLinterAnnotationResult<TsLintState> createError(String error) {
        return JSLinterAnnotationResult.createLinterFailResult(this.myInputInfo, error, this.myConfigVirtualFile);
    }
}

