/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class LastImportInScope {
    private PsiElement myLastRequireElement;
    private PsiElement myLastImportElement;
    private final boolean myPreferImport;
    private String myRequireName = "require";
    private boolean myNoticeRequire = true;

    public LastImportInScope(boolean preferImport) {
        this.myPreferImport = preferImport;
    }

    public LastImportInScope withRequireName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/modules/LastImportInScope", "withRequireName"));
        }
        this.myRequireName = name;
        return this;
    }

    public LastImportInScope withNoticeRequire(boolean value) {
        this.myNoticeRequire = value;
        return this;
    }

    public PsiElement findAndSelect(PsiElement scopeElement) {
        PsiElement[] topChildren;
        this.myLastRequireElement = null;
        this.myLastImportElement = null;
        for (PsiElement topChild : topChildren = scopeElement.getChildren()) {
            if (this.myNoticeRequire && topChild instanceof JSVarStatement) {
                JSVariable[] variables;
                for (JSVariable variable : variables = ((JSVarStatement)topChild).getVariables()) {
                    if (!this.isRequireExpression(variable.getInitializer())) continue;
                    this.myLastRequireElement = topChild;
                }
            } else if (this.myNoticeRequire && topChild instanceof JSExpressionStatement) {
                if (this.isRequireExpression(((JSExpressionStatement)topChild).getExpression())) {
                    this.myLastRequireElement = topChild;
                }
            } else if (topChild instanceof ES6ImportDeclaration) {
                this.myLastImportElement = topChild;
            }
            if (this.myLastImportElement != null && this.myLastRequireElement != null) break;
        }
        return this.selectVariant();
    }

    private boolean isRequireExpression(JSExpression initializer) {
        if (initializer instanceof JSCallExpression && ((JSCallExpression)initializer).getArguments().length == 1) {
            for (PsiElement element : initializer.getChildren()) {
                if (!(element instanceof JSReferenceExpression) || !JSSymbolUtil.isAccurateReferenceExpressionName((JSReferenceExpression)element, this.myRequireName)) continue;
                return true;
            }
        }
        return false;
    }

    protected PsiElement selectVariant() {
        if (this.myPreferImport) {
            return this.myLastImportElement != null ? this.myLastImportElement : this.myLastRequireElement;
        }
        return this.myLastRequireElement != null ? this.myLastRequireElement : this.myLastImportElement;
    }

    public PsiElement getLastRequireElement() {
        return this.myLastRequireElement;
    }

    public PsiElement getLastImportElement() {
        return this.myLastImportElement;
    }

    public static PsiElement lastCommentAnchorCorrection(@NotNull PsiElement anchor) {
        PsiElement lastAfterComment;
        JSSourceElement sourceElement;
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/lang/javascript/modules/LastImportInScope", "lastCommentAnchorCorrection"));
        }
        JSSourceElement jSSourceElement = sourceElement = anchor instanceof JSSourceElement ? (JSSourceElement)anchor : (JSSourceElement)PsiTreeUtil.getParentOfType((PsiElement)anchor, JSSourceElement.class);
        if (sourceElement != null && (lastAfterComment = new CommentsMover(sourceElement).getLastAfterComment()) != null) {
            return lastAfterComment;
        }
        return anchor;
    }
}

