/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringContainer;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSDestructuringObject;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSDestructuringProperty;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.impl.JSDestructuringElementImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.stubs.impl.JSDestructuringParameterStubImpl;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayTypeImpl;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.lang.javascript.psi.types.JSRecordTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDestructuringParameterImpl
extends JSDestructuringElementImpl<JSDestructuringParameterStubImpl>
implements JSDestructuringParameter,
StubBasedPsiElement<JSDestructuringParameterStubImpl> {
    public JSDestructuringParameterImpl(ASTNode node) {
        super(node);
    }

    public JSDestructuringParameterImpl(JSDestructuringParameterStubImpl stub) {
        super(stub, JSStubElementTypes.DESTRUCTURING_PARAMETER);
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "accept"));
        }
        if (visitor instanceof JSElementVisitor) {
            ((JSElementVisitor)visitor).visitJSDestructuringAssignment((JSDestructuringElement)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String getName() {
        return this.getTarget().getText();
    }

    public boolean isOptional() {
        JSDestructuringParameterStubImpl stub = (JSDestructuringParameterStubImpl)this.getStub();
        if (stub != null) {
            return stub.isOptional();
        }
        return this.getInitializer() != null || this.getNode().findChildByType(JSTokenTypes.QUEST) != null;
    }

    public boolean isRest() {
        return false;
    }

    @NotNull
    public JSParameterTypeDecorator getTypeDecorator() {
        JSParameterTypeDecoratorImpl jSParameterTypeDecoratorImpl = new JSParameterTypeDecoratorImpl(this.getType(), this.isOptional(), this.isRest(), true);
        if (jSParameterTypeDecoratorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "getTypeDecorator"));
        }
        return jSParameterTypeDecoratorImpl;
    }

    @Nullable
    public JSType getTypeIncludingOverridden() {
        return this.getType();
    }

    @Override
    @Nullable
    public JSExpression getInitializer() {
        return JSPsiImplUtils.getInitializer(this.getNode());
    }

    @Override
    @Nullable
    public JSType getType() {
        JSType type = super.getType();
        if (type != null) {
            return type;
        }
        return this.buildTypeFromDestructuring();
    }

    @NotNull
    private JSType buildTypeFromDestructuring() {
        JSDestructuringContainer target = this.getTarget();
        Object object = target != null ? JSDestructuringParameterImpl.buildElement(this, (JSElement)target) : JSAnyType.get((PsiElement)this, true);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildTypeFromDestructuring"));
        }
        return object;
    }

    private static JSType buildDestructuringObject(@NotNull JSElement context, @NotNull JSDestructuringObject object) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildDestructuringObject"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildDestructuringObject"));
        }
        ArrayList member = ContainerUtil.newArrayList();
        for (JSDestructuringProperty property : object.getProperties()) {
            String name = property.getName();
            if (StringUtil.isEmpty((String)name)) continue;
            JSInitializerOwner element = property.getDestructuringElement();
            JSType type = JSDestructuringParameterImpl.buildElement(context, (JSElement)element);
            boolean optional = element.getInitializer() != null;
            member.add(new JSRecordTypeImpl.PropertySignatureImpl(name, type, optional |= element instanceof JSParameter && ((JSParameter)element).isOptional()));
        }
        return new JSRecordTypeImpl(JSTypeSourceFactory.createTypeSource((PsiElement)object, true), member);
    }

    @NotNull
    private static JSType buildElement(@NotNull JSElement context, @Nullable JSElement element) {
        JSType elementType;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildElement"));
        }
        if (element instanceof JSDestructuringObject) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringObject(context, (JSDestructuringObject)element);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildElement"));
            }
            return jSType;
        }
        if (element instanceof JSDestructuringArray) {
            JSType jSType = JSDestructuringParameterImpl.buildDestructuringArray(context, (JSDestructuringArray)element);
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildElement"));
            }
            return jSType;
        }
        if (element instanceof JSParameter && !DialectDetector.isTypeScript((PsiElement)context) && (elementType = ((JSParameter)element).getType()) != null) {
            JSType jSType = elementType;
            if (jSType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildElement"));
            }
            return jSType;
        }
        JSAnyType jSAnyType = JSAnyType.get((PsiElement)context, true);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildElement"));
        }
        return jSAnyType;
    }

    private static JSType buildDestructuringArray(@NotNull JSElement context, @NotNull JSDestructuringArray element) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildDestructuringArray"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "buildDestructuringArray"));
        }
        JSInitializerOwner[] elements = element.getElements();
        List<JSTypeUtils.TypeProvider> providers = Arrays.stream(elements).filter(el -> el != null).map(el -> {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "lambda$buildDestructuringArray$2"));
            }
            return () -> {
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/psi/impl/JSDestructuringParameterImpl", "lambda$null$1"));
                }
                return JSDestructuringParameterImpl.buildElement(context, (JSElement)el);
            };
        }).collect(Collectors.toList());
        JSType commonType = JSTypeUtils.getCommonType(providers, (PsiElement)context, true);
        return new JSArrayTypeImpl(commonType, JSTypeSourceFactory.createTypeSource((PsiElement)element, true));
    }
}

