/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.psi.ResolveResult;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public class JSTaggedResolveResult
implements Comparable<JSTaggedResolveResult> {
    @NotNull
    public final ResolveResult result;
    @NotNull
    public final EnumSet<ResolveResultTag> tags;

    JSTaggedResolveResult(@NotNull ResolveResult result, @NotNull EnumSet<ResolveResultTag> tags) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/javascript/psi/resolve/JSTaggedResolveResult", "<init>"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "com/intellij/lang/javascript/psi/resolve/JSTaggedResolveResult", "<init>"));
        }
        this.result = result;
        this.tags = tags;
    }

    @Override
    public int compareTo(@NotNull JSTaggedResolveResult o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/lang/javascript/psi/resolve/JSTaggedResolveResult", "compareTo"));
        }
        int priorityTo = this.comparePriorityTo(o);
        if (priorityTo != 0) {
            return priorityTo;
        }
        if (this.tags.contains((Object)ResolveResultTag.CURRENT_FILE) && !o.tags.contains((Object)ResolveResultTag.CURRENT_FILE)) {
            return -1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.CURRENT_FILE) && o.tags.contains((Object)ResolveResultTag.CURRENT_FILE)) {
            return 1;
        }
        return 0;
    }

    int comparePriorityTo(@NotNull JSTaggedResolveResult o) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/lang/javascript/psi/resolve/JSTaggedResolveResult", "comparePriorityTo"));
        }
        if (this.result.isValidResult() && !o.result.isValidResult()) {
            return -1;
        }
        if (!this.result.isValidResult() && o.result.isValidResult()) {
            return 1;
        }
        if (!this.result.isValidResult() && !o.result.isValidResult() && this.result instanceof JSResolveResult && o.result instanceof JSResolveResult) {
            String problem = ((JSResolveResult)this.result).getResolveProblemKey();
            String otherProblem = ((JSResolveResult)o.result).getResolveProblemKey();
            if (problem == "javascript.element.need.to.be.imported" && otherProblem != "javascript.element.need.to.be.imported") {
                return -1;
            }
            if (problem != "javascript.element.need.to.be.imported" && otherProblem == "javascript.element.need.to.be.imported") {
                return 1;
            }
            if (problem == "javascript.element.need.to.be.exported" && otherProblem != "javascript.element.need.to.be.exported") {
                return -1;
            }
            if (problem != "javascript.element.need.to.be.exported" && otherProblem == "javascript.element.need.to.be.exported") {
                return 1;
            }
        }
        if (this.tags.contains((Object)ResolveResultTag.PARTIAL) && !o.tags.contains((Object)ResolveResultTag.PARTIAL)) {
            return 1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.PARTIAL) && o.tags.contains((Object)ResolveResultTag.PARTIAL)) {
            return -1;
        }
        if (this.tags.contains((Object)ResolveResultTag.DEFINITION) && !o.tags.contains((Object)ResolveResultTag.DEFINITION)) {
            return 1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.DEFINITION) && o.tags.contains((Object)ResolveResultTag.DEFINITION)) {
            return -1;
        }
        if (this.tags.contains((Object)ResolveResultTag.MINOR_IMPORTANCE) && !o.tags.contains((Object)ResolveResultTag.MINOR_IMPORTANCE)) {
            return 1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.MINOR_IMPORTANCE) && o.tags.contains((Object)ResolveResultTag.MINOR_IMPORTANCE)) {
            return -1;
        }
        if (this.tags.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY) && !o.tags.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY)) {
            return 1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY) && o.tags.contains((Object)ResolveResultTag.RECORD_TYPE_PROPERTY)) {
            return -1;
        }
        if (this.tags.contains((Object)ResolveResultTag.CONTEXT_MATCHES) && !o.tags.contains((Object)ResolveResultTag.CONTEXT_MATCHES)) {
            return -1;
        }
        if (!this.tags.contains((Object)ResolveResultTag.CONTEXT_MATCHES) && o.tags.contains((Object)ResolveResultTag.CONTEXT_MATCHES)) {
            return 1;
        }
        return 0;
    }

    public boolean hasTag(ResolveResultTag tag) {
        return this.tags.contains((Object)tag);
    }

    public static enum ResolveResultTag {
        CURRENT_FILE,
        PARTIAL,
        MINOR_IMPORTANCE,
        DEFINITION,
        RECORD_TYPE_PROPERTY,
        CONTEXT_MATCHES;

    }
}

