/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve.accessibility;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.AccessibilityProcessingHandler;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.accessibility.JSAccessibilityChecker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptModuleAccessibilityChecker
extends JSAccessibilityChecker {
    public static final TypeScriptModuleAccessibilityChecker INSTANCE = new TypeScriptModuleAccessibilityChecker();
    private Collection<Class<? extends JSElement>> myClasses = ContainerUtil.newArrayList((Object[])new Class[]{JSVariable.class, JSFunction.class, TypeScriptImportStatement.class, TypeScriptClass.class, TypeScriptInterface.class, TypeScriptEnum.class, TypeScriptTypeAlias.class, TypeScriptModule.class});

    @Override
    @NotNull
    protected Collection<Class<? extends JSElement>> getSuitableClasses() {
        Collection<Class<? extends JSElement>> collection = this.myClasses;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptModuleAccessibilityChecker", "getSuitableClasses"));
        }
        return collection;
    }

    public static boolean checkElementCanBeExported(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptModuleAccessibilityChecker", "checkElementCanBeExported"));
        }
        return element instanceof JSAttributeListOwner && !(element instanceof TypeScriptTypeMember) && !(element instanceof JSParameter) && !(element instanceof JSProperty) && !(element instanceof JSField) && !(element instanceof TypeScriptType);
    }

    @Override
    @Nullable
    protected String checkImpl(@Nullable PsiElement place, @NotNull PsiElement element) {
        JSElement parent;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/psi/resolve/accessibility/TypeScriptModuleAccessibilityChecker", "checkImpl"));
        }
        if (place == null) {
            return null;
        }
        if (!TypeScriptModuleAccessibilityChecker.checkElementCanBeExported(element) || element instanceof TypeScriptImplicitModule) {
            return null;
        }
        JSAttributeList attributeList = ((JSAttributeListOwner)element).getAttributeList();
        if (attributeList == null || attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC) {
            return null;
        }
        if (element instanceof JSVariable || element instanceof JSFunction) {
            PsiElement elementParent = element.getParent();
            if (elementParent instanceof JSVarStatement) {
                elementParent = elementParent.getParent();
            }
            if (elementParent instanceof JSClass) {
                return null;
            }
        }
        if (!((parent = ES6PsiUtil.getExportScope(element)) instanceof TypeScriptModule)) {
            return null;
        }
        TypeScriptModule module = (TypeScriptModule)parent;
        if (element instanceof TypeScriptModule && module instanceof TypeScriptImplicitModule) {
            return null;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)module, (PsiElement)place, (boolean)false)) {
            return null;
        }
        return "javascript.element.is.not.accessible.message";
    }

    @Override
    public boolean isAvailable(AccessibilityProcessingHandler handler, SinkResolveProcessor resolveProcessor) {
        return ((ResultSink)resolveProcessor.getResultSink()).isTypeScript();
    }
}

