/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSEvaluableType;
import com.intellij.lang.javascript.psi.types.JSIntersectionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptTypeOfJSTypeImpl
extends JSSimpleTypeBaseImpl
implements JSEvaluableType {
    private final String myText;

    public TypeScriptTypeOfJSTypeImpl(String typeOfText, @NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "<init>"));
        }
        super(source);
        this.myText = typeOfText;
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.CODE || format == JSType.TypeTextFormat.PRESENTABLE) {
            String string = "typeof " + this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeText"));
            }
            return string;
        }
        if (format == JSType.TypeTextFormat.SERIALIZED) {
            String string = "#tstypeof(" + this.myText + ")";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeText"));
            }
            return string;
        }
        String string = this.substitute().getTypeText(format);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "getTypeText"));
        }
        return string;
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "isDirectlyAssignableTypeImpl"));
        }
        return this.substitute().isDirectlyAssignableType(elementType, processingContext);
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "copyWithNewSource"));
        }
        TypeScriptTypeOfJSTypeImpl typeScriptTypeOfJSTypeImpl = new TypeScriptTypeOfJSTypeImpl(this.myText, source);
        if (typeScriptTypeOfJSTypeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "copyWithNewSource"));
        }
        return typeScriptTypeOfJSTypeImpl;
    }

    @Override
    protected boolean isEquivalentToImpl(@NotNull JSType type, ProcessingContext context, boolean allowResolve) {
        JSTypeSource typeSource;
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "isEquivalentToImpl"));
        }
        JSTypeSource source = type.getSource();
        PsiElement element = source.getSourceElement();
        if (element == null || !element.isValid()) {
            return false;
        }
        if (type instanceof TypeScriptTypeOfJSTypeImpl && ((TypeScriptTypeOfJSTypeImpl)type).myText.equals(this.myText) && (typeSource = type.getSource()).getSourceElement() == element) {
            return true;
        }
        if (!allowResolve) {
            return false;
        }
        return this.substitute().isEquivalentTo(type, context, true);
    }

    @Override
    @NotNull
    public JSType substitute() {
        PsiElement sourceElement = this.getSource().getSourceElement();
        if (sourceElement == null || !sourceElement.isValid()) {
            JSAnyType jSAnyType = JSAnyType.get(sourceElement, false);
            if (jSAnyType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "substitute"));
            }
            return jSAnyType;
        }
        JSTypeResolveResult result = JSDialectSpecificHandlersFactory.forElement(sourceElement).getImportHandler().resolveName(this.myText, sourceElement);
        if (result.hasElements()) {
            List<JSType> results = result.getElements().stream().filter(el -> el != null && !(el instanceof TypeScriptInterface) && !(el instanceof TypeScriptTypeAlias) && (!(el instanceof TypeScriptModule) || ((TypeScriptModule)el).isInstantiated())).map(el -> {
                if (el instanceof TypeScriptModule) {
                    return TypeScriptTypeParser.buildTypeForModule((TypeScriptModule)el);
                }
                JSTypeEvaluationResult type = JSTypeEvaluator.getElementType(el);
                return type != null ? type.getType() : null;
            }).filter(el -> el != null).collect(Collectors.toList());
            JSIntersectionTypeImpl jSIntersectionTypeImpl = results.size() == 1 ? (JSType)results.get(0) : new JSIntersectionTypeImpl(this.getSource(), results);
            if (jSIntersectionTypeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "substitute"));
            }
            return jSIntersectionTypeImpl;
        }
        JSAnyType jSAnyType = JSAnyType.get(sourceElement, false);
        if (jSAnyType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/TypeScriptTypeOfJSTypeImpl", "substitute"));
        }
        return jSAnyType;
    }
}

