/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types.primitives;

import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.types.JSDecoratedTypeImpl;
import com.intellij.lang.javascript.psi.types.JSSimpleTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSNullType
extends JSSimpleTypeBaseImpl {
    public JSNullType(JSTypeSource source) {
        super(source);
    }

    @NotNull
    public String getTypeText(JSType.TypeTextFormat format) {
        if (format == JSType.TypeTextFormat.CODE && this.isTypeScript()) {
            if ("any" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "getTypeText"));
            }
            return "any";
        }
        if ("null" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "getTypeText"));
        }
        return "null";
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @Nullable ProcessingContext processingContext) {
        JSDecoratedTypeImpl decoratedType;
        if (elementType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementType", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "isDirectlyAssignableTypeImpl"));
        }
        if (elementType instanceof JSDecoratedTypeImpl && (decoratedType = (JSDecoratedTypeImpl)elementType).getDecorations().contains((Object)JSDecoratedTypeImpl.TypeDecoration.NULLABLE)) {
            return true;
        }
        if (this.getSource().getLanguage() == JSTypeSource.SourceLanguage.TS) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    @Override
    public boolean isEquivalentToImpl(@NotNull JSType type, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "isEquivalentToImpl"));
        }
        return type instanceof JSNullType;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "copyWithNewSource"));
        }
        JSNullType jSNullType = new JSNullType(source);
        if (jSNullType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/psi/types/primitives/JSNullType", "copyWithNewSource"));
        }
        return jSNullType;
    }
}

