/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSNamespaceDeclaration;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.refactoring.JSRefactoringFilterProvider;
import com.intellij.lang.javascript.refactoring.changeSignature.JSChangeSignatureHandler;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionHandler;
import com.intellij.lang.javascript.refactoring.introduceField.JSIntroduceFieldHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceVariable.JSIntroduceVariableHandler;
import com.intellij.lang.refactoring.RefactoringSupportProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.changeSignature.ChangeSignatureHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavascriptRefactoringSupportProvider
extends RefactoringSupportProvider {
    public boolean isSafeDeleteAvailable(@NotNull PsiElement element) {
        boolean simpleElement;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JavascriptRefactoringSupportProvider", "isSafeDeleteAvailable"));
        }
        boolean bl = simpleElement = element instanceof JSFunction || element instanceof JSVariable || element instanceof JSNamespaceDeclaration || element instanceof JSDefinitionExpression || element instanceof JSProperty || element instanceof JSClass;
        if (element instanceof JSImplicitElement) {
            simpleElement = ((JSImplicitElement)element).getType() != JSImplicitElement.Type.Tag;
        }
        return simpleElement && ((PsiNamedElement)element).getName() != null;
    }

    @Nullable
    public RefactoringActionHandler getIntroduceVariableHandler() {
        return new JSIntroduceVariableHandler();
    }

    @Nullable
    public RefactoringActionHandler getExtractMethodHandler() {
        return new JSExtractFunctionHandler();
    }

    public boolean isInplaceRenameAvailable(@NotNull PsiElement element, PsiElement context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/refactoring/JavascriptRefactoringSupportProvider", "isInplaceRenameAvailable"));
        }
        return false;
    }

    public RefactoringActionHandler getIntroduceParameterHandler() {
        return new JSIntroduceParameterHandler();
    }

    public ChangeSignatureHandler getChangeSignatureHandler() {
        return new JSChangeSignatureHandler();
    }

    public RefactoringActionHandler getIntroduceFieldHandler() {
        return new JSIntroduceFieldHandler();
    }

    public boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/javascript/refactoring/JavascriptRefactoringSupportProvider", "isAvailable"));
        }
        JSRefactoringFilterProvider refactoringFilterProvider = null;
        PsiElement container = PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{PsiFile.class, JSEmbeddedContent.class});
        if (container == null) {
            container = context.getContainingFile();
        }
        if (container != null) {
            refactoringFilterProvider = (JSRefactoringFilterProvider)JSRefactoringFilterProvider.INSTANCE.forLanguage(container.getLanguage());
        }
        if (refactoringFilterProvider == null) {
            refactoringFilterProvider = JSRefactoringFilterProvider.DEFAULT_INSTANCE;
        }
        if (!refactoringFilterProvider.isRefactoringEnabled(JavascriptRefactoringSupportProvider.class)) {
            return false;
        }
        return super.isAvailable(context);
    }
}

