/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.findUsages.JSReadWriteAccessDetector;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.JSDeclarationsAtScopeStartInspection;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSThrowStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.resolve.ActionScriptResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.extractMethod.DefaultJSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.extractMethod.ExtractedFunctionSignatureGenerator;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionDialog;
import com.intellij.lang.javascript.refactoring.extractMethod.JSExtractFunctionSettings;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSExtractFunctionHandler
implements RefactoringActionHandler {
    private static final Class[] classTypes = new Class[]{JSObjectLiteralExpression.class, JSClass.class, JSFile.class, JSBlockStatement.class, XmlTagChild.class, TypeScriptModule.class};
    private boolean ecmaL4;
    private JSLanguageDialect dialect;
    private static final String VOID_TYPE_NAME = "void";
    protected static boolean GLOBAL_SCOPE_WAS_SELECTED = false;

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        JSExtractFunctionSettings settings;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "invoke"));
        }
        if (!JSRefactoringUtil.checkReadOnlyStatus((PsiElement)file, editor, JSBundle.message((String)"javascript.refactoring.extract.function.title", (Object[])new Object[0]))) {
            return;
        }
        this.dialect = JSUtils.getDialect(file);
        boolean bl = this.ecmaL4 = this.dialect == JavaScriptSupportLoader.ECMA_SCRIPT_L4;
        if (!editor.getSelectionModel().hasSelection()) {
            editor.getSelectionModel().selectLineAtCaret();
        }
        if ((settings = this.getSettings(file, editor, project)) == null) {
            return;
        }
        this.doRefactoringInWriteAction(project, editor, settings);
    }

    protected void doRefactoringInWriteAction(Project project, Editor editor, @NotNull JSExtractFunctionSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "doRefactoringInWriteAction"));
        }
        CommandProcessor.getInstance().executeCommand(project, () -> {
            if (settings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "lambda$doRefactoringInWriteAction$0"));
            }
            AccessToken l = WriteAction.start();
            try {
                this.doRefactoring(project, editor, settings);
            }
            finally {
                l.finish();
            }
        }, JSBundle.message((String)"javascript.extract.method.title", (Object[])new Object[0]), null);
    }

    @Nullable
    protected JSExtractFunctionSettings getSettings(final PsiFile file, final Editor editor, final @Nullable Project project) {
        Pass<IntroductionScope> callback;
        final ContextInfo ci = new ContextInfo(editor);
        if (!this.possibleToExtract(editor, ci)) {
            return null;
        }
        final ExtractedFunctionSignatureGenerator signatureGenerator = this.getSignatureGenerator();
        IntroductionScope scope = this.getIntroductionScope(editor, signatureGenerator, ci.ecmaL4, ci.introductionScopes, ci.anchor, callback = new Pass<IntroductionScope>(){

            public void pass(IntroductionScope scope) {
                GLOBAL_SCOPE_WAS_SELECTED = scope.isGlobal();
                JSExtractFunctionSettings settings = JSExtractFunctionHandler.this.showDialog(file, ci, signatureGenerator, scope);
                if (settings != null) {
                    JSExtractFunctionHandler.this.doRefactoringInWriteAction(project, editor, settings);
                }
            }
        }, "extracted");
        if (scope != null) {
            return this.showDialog(file, ci, signatureGenerator, scope);
        }
        return null;
    }

    protected JSExtractFunctionSettings showDialog(PsiFile file, ContextInfo ci, ExtractedFunctionSignatureGenerator signatureGenerator, @NotNull IntroductionScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "showDialog"));
        }
        JSExtractFunctionDialog dialog = new JSExtractFunctionDialog((PsiElement)file, signatureGenerator, ci, scope);
        dialog.show();
        if (dialog.getExitCode() != 0) {
            return null;
        }
        return dialog;
    }

    @Nullable
    public IntroductionScope getIntroductionScope(final Editor editor, ExtractedFunctionSignatureGenerator signatureGenerator, boolean ecmaL4, List<IntroductionScope> introductionScopes, PsiElement anchorElement, Pass<IntroductionScope> callback, @NotNull String functionName) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "getIntroductionScope"));
        }
        if (ecmaL4) {
            return JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, false);
        }
        if (introductionScopes.size() == 1) {
            return introductionScopes.get(0);
        }
        if (introductionScopes.size() > 1) {
            final LogicalPosition initialPos = editor.offsetToLogicalPosition(editor.getCaretModel().getOffset());
            ArrayList<IntroductionScope> scopesInList = new ArrayList<IntroductionScope>(introductionScopes);
            Collections.reverse(scopesInList);
            JBList list = new JBList(scopesInList);
            final Ref lastHint = Ref.create(null);
            list.setSelectedValue(JSExtractFunctionHandler.getDefaultSuggestedScope(introductionScopes, true), true);
            ArrayList<String> signatures = new ArrayList<String>(scopesInList.size());
            for (IntroductionScope scope : scopesInList) {
                DefaultJSExtractFunctionSettings defaultSettings = new DefaultJSExtractFunctionSettings(functionName, scope);
                signatures.add(signatureGenerator.fun(defaultSettings, ecmaL4, anchorElement));
            }
            list.addListSelectionListener(new ListSelectionListener((JList)list, scopesInList, anchorElement, editor, signatures, lastHint){
                final /* synthetic */ JList val$list;
                final /* synthetic */ List val$scopesInList;
                final /* synthetic */ PsiElement val$anchorElement;
                final /* synthetic */ Editor val$editor;
                final /* synthetic */ List val$signatures;
                final /* synthetic */ Ref val$lastHint;
                {
                    this.val$list = jList;
                    this.val$scopesInList = list;
                    this.val$anchorElement = psiElement;
                    this.val$editor = editor;
                    this.val$signatures = list2;
                    this.val$lastHint = ref;
                }

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    int index = this.val$list.getSelectedIndex();
                    if (index < 0) {
                        return;
                    }
                    IntroductionScope scope = (IntroductionScope)this.val$scopesInList.get(index);
                    PsiElement anchor = JSExtractFunctionHandler.findFunctionAnchor(scope.parent, this.val$anchorElement);
                    assert (anchor != null) : "ci.anchor: " + anchor + "; parent: " + scope.parent;
                    int hintPosition = anchor.getTextRange().getStartOffset();
                    if (JSExtractFunctionHandler.this.needInsertAfter(scope.parent, anchor)) {
                        PsiElement nextSibling = anchor.getNextSibling();
                        if (nextSibling instanceof PsiWhiteSpace) {
                            nextSibling = nextSibling.getNextSibling();
                        }
                        hintPosition = nextSibling != null ? nextSibling.getTextRange().getStartOffset() : anchor.getTextRange().getEndOffset();
                    }
                    LogicalPosition position = this.val$editor.offsetToLogicalPosition(hintPosition);
                    this.val$editor.getScrollingModel().scrollTo(position, ScrollType.MAKE_VISIBLE);
                    this.val$editor.getScrollingModel().runActionOnScrollingFinished(() -> {
                        JComponent label = HintUtil.createInformationLabel((String)((String)this.val$signatures.get(index)));
                        LightweightHint hint = new LightweightHint(label);
                        this.val$lastHint.set((Object)hint);
                        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
                        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)this.val$editor, (LogicalPosition)position, (short)3);
                        hintManager.showEditorHint(hint, this.val$editor, p, 48, 0, false, HintManagerImpl.createHintHint((Editor)this.val$editor, (Point)p, (LightweightHint)hint, (short)3).setContentActive(false).setAwtTooltip(true).setShowImmediately(true));
                    });
                }
            });
            list.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Component rendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    IntroductionScope scope = (IntroductionScope)value;
                    PsiElement expr = scope.parent;
                    if (expr.isValid()) {
                        this.setText(scope.presentation);
                    }
                    return rendererComponent;
                }
            });
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("Choose Destination Scope").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> JSExtractFunctionHandler.lambda$getIntroductionScope$1(callback, (JList)list)).addListener((JBPopupListener)new JBPopupAdapter(){

                public void onClosed(LightweightWindowEvent event) {
                    editor.getScrollingModel().scrollTo(initialPos, ScrollType.CENTER);
                    if (!lastHint.isNull()) {
                        ((LightweightHint)lastHint.get()).hide();
                    }
                }
            }).createPopup().showInBestPositionFor(editor);
        }
        return null;
    }

    private static IntroductionScope getDefaultSuggestedScope(List<IntroductionScope> introductionScopes, boolean checkLastSelectedScope) {
        IntroductionScope nearestScope = introductionScopes.get(0);
        boolean insidePackageStatement = PsiTreeUtil.getParentOfType((PsiElement)nearestScope.getParent(), (Class[])new Class[]{JSPackageStatement.class, JSClass.class}) instanceof JSPackageStatement;
        for (IntroductionScope scope : introductionScopes) {
            if (scope.isClassContext()) {
                return scope;
            }
            if (!scope.isGlobal() || insidePackageStatement || checkLastSelectedScope && !GLOBAL_SCOPE_WAS_SELECTED) continue;
            return scope;
        }
        return nearestScope;
    }

    protected boolean possibleToExtract(Editor editor, ContextInfo ci) {
        if (ci.getProblem() != null) {
            CommonRefactoringUtil.showErrorHint((Project)editor.getProject(), (Editor)editor, (String)ci.getProblem(), (String)JSBundle.message((String)"javascript.refactoring.extract.function.title", (Object[])new Object[0]), (String)"refactoring.extractFunction");
            return false;
        }
        return true;
    }

    private boolean notAllowedStatement(PsiElement n) {
        return n instanceof JSPackageStatement || n instanceof JSImportStatement || n instanceof JSBlockStatement && n.getParent() instanceof JSFunction || n instanceof JSFunction;
    }

    protected PsiElement findStatement(PsiElement elementAt, int start, int end) {
        if ((elementAt instanceof PsiComment || elementAt instanceof PsiWhiteSpace) && (elementAt.getParent() instanceof JSBlockStatement || elementAt.getParent() instanceof JSFile)) {
            return elementAt;
        }
        JSStatement statement = (JSStatement)PsiTreeUtil.getParentOfType((PsiElement)elementAt, JSStatement.class);
        if (this.notAllowedStatement((PsiElement)statement)) {
            return null;
        }
        return statement;
    }

    static JSExtractFunctionSettings.ParametersInfo createDefaultParametersInfo(IntroductionScope scope) {
        JSExtractFunctionSettings.ParametersInfo parametersInfo = new JSExtractFunctionSettings.ParametersInfo();
        parametersInfo.variables.addAll(scope.usedVars);
        return parametersInfo;
    }

    protected int getExtractFragmentStartOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionStart();
    }

    protected int getExtractFragmentEndOffset(Editor editor) {
        SelectionModel selectionModel = editor.getSelectionModel();
        return selectionModel.getSelectionEnd();
    }

    public static boolean isPropertyContext(PsiElement parent) {
        return parent instanceof JSObjectLiteralExpression;
    }

    public static boolean isClassContext(PsiElement parent) {
        return parent instanceof ES6Class;
    }

    private void doRefactoring(Project project, Editor editor, @NotNull JSExtractFunctionSettings settings) {
        ASTNode fromText;
        PsiElement parent;
        ContextInfo contextInfo;
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "doRefactoring"));
        }
        IntroductionScope introductionScope = settings.getIntroductionScope();
        if (settings instanceof JSExtractFunctionDialog) {
            contextInfo = ((JSExtractFunctionDialog)settings).getContextInfo();
        } else {
            contextInfo = new ContextInfo(editor);
            int scopeNumber = introductionScope.presentation == null ? 0 : Integer.parseInt(introductionScope.presentation);
            IntroductionScope actualScope = contextInfo.introductionScopes.get(scopeNumber);
            if (introductionScope.parent != null) {
                for (IntroductionScope contextScope : contextInfo.introductionScopes) {
                    if (contextScope.parent != introductionScope.parent) continue;
                    actualScope = contextScope;
                    break;
                }
            }
            introductionScope.outputVars = actualScope.outputVars;
            introductionScope.usedVars = actualScope.usedVars;
            introductionScope.returnType = actualScope.returnType;
            introductionScope.forceMakeFunExpr = actualScope.forceMakeFunExpr;
            introductionScope.presentation = actualScope.presentation;
            introductionScope.parent = actualScope.parent;
            if (!this.possibleToExtract(editor, contextInfo)) {
                return;
            }
        }
        ExtractedFunctionSignatureGenerator signatureGenerator = this.getSignatureGenerator();
        editor.getSelectionModel().removeSelection();
        boolean doReformat = !(introductionScope.parent instanceof XmlBackedJSClass);
        int startOffset = contextInfo.possibleRange.getStartOffset();
        String origText = editor.getDocument().getCharsSequence().subSequence(startOffset, contextInfo.possibleRange.getEndOffset()).toString();
        String text = origText.trim();
        int leftTrim = origText.indexOf(text);
        TextRange trimmedPossibleRange = new TextRange(startOffset += leftTrim, startOffset + text.length());
        StringBuilder b = new StringBuilder(text);
        JSExtractFunctionSettings.ParametersInfo parametersInfo = JSExtractFunctionHandler.getNotNullParametersInfo(settings);
        String semicolon = this.getStatementTerminator(contextInfo);
        for (Map.Entry e : contextInfo.parameterReferences.entrySet()) {
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(e.getValue());
            if (parameterInfo == null) continue;
            RangeMarker range = (RangeMarker)e.getKey();
            b.replace(range.getStartOffset() - startOffset, range.getEndOffset() - startOffset, parameterInfo.name);
            startOffset += ((JSVariable)e.getValue()).getName().length() - parameterInfo.name.length();
        }
        for (RangeMarker range : contextInfo.continueStatementsToReplaceWithReturn) {
            int rangeStart = range.getStartOffset();
            int rangeEnd = range.getEndOffset();
            String toInsert = "return" + semicolon;
            b.replace(rangeStart - startOffset, rangeEnd - startOffset, toInsert);
            startOffset += rangeEnd - rangeStart - toInsert.length();
        }
        text = b.toString();
        String callArgs = "";
        String callPrefix = "";
        String callSuffix = "";
        if (contextInfo.isExpression) {
            boolean exprIsVoid = VOID_TYPE_NAME.equals(introductionScope.returnType);
            text = (exprIsVoid ? "" : this.getReturnStatementPrefix()) + text;
            if (!text.endsWith(semicolon)) {
                text = text + semicolon;
            }
        } else {
            ArrayList<JSVariable> outputVars = new ArrayList<JSVariable>(introductionScope.outputVars);
            Iterator i = outputVars.iterator();
            while (i.hasNext()) {
                JSVariable var = (JSVariable)i.next();
                JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
                if (parameterInfo == null || parameterInfo.used) continue;
                i.remove();
            }
            if (outputVars.size() == 1) {
                JSVariable var = (JSVariable)outputVars.iterator().next();
                JSType type = var.getType();
                text = text + "\nreturn " + var.getName() + semicolon;
                boolean createVar = contextInfo.possibleRange.contains(var.getTextRange());
                callPrefix = (createVar ? this.getVariableDeclarationPrefix() : "") + var.getName();
                if (this.ecmaL4 && createVar && type != null) {
                    callPrefix = callPrefix + ":" + type.getTypeText();
                }
                callPrefix = callPrefix + " = ";
            } else if (outputVars.size() > 1) {
                text = text + "\nreturn {";
                for (JSVariable outVar : outputVars) {
                    String __ret = "__ret";
                    if (callPrefix.length() > 0) {
                        text = text + ", ";
                        callSuffix = callSuffix + "\n";
                    } else {
                        callPrefix = this.getVariableDeclarationPrefix() + __ret + (this.ecmaL4 ? ":Object" : "") + " = ";
                        callSuffix = "\n";
                    }
                    String varName = outVar.getName();
                    text = text + (String)varName + ":" + (String)varName;
                    callSuffix = callSuffix + (contextInfo.possibleRange.contains(outVar.getTextRange()) ? this.getVariableDeclarationPrefix() : "") + (String)varName + " = " + __ret + "." + (String)varName + semicolon;
                }
                text = text + "}" + semicolon;
            }
        }
        String signature = signatureGenerator.fun(settings, contextInfo.ecmaL4, contextInfo.anchor);
        boolean makeProperty = JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) && settings.makeFunctionExpression();
        String introducedFunctionText = signature;
        boolean referencesArguments = false;
        for (JSVariable var : JSExtractFunctionHandler.getOrderedParameters(parametersInfo)) {
            if (JSExtractFunctionHandler.isArgumentsReference(var)) {
                referencesArguments = true;
                continue;
            }
            JSExtractFunctionSettings.ParameterInfo parameterInfo = parametersInfo.variableOptions.get(var);
            if (parameterInfo != null && !parameterInfo.used) continue;
            if (callArgs.length() > 0) {
                callArgs = callArgs + ",";
            }
            callArgs = callArgs + var.getName();
        }
        if (referencesArguments) {
            if (callArgs.length() > 0) {
                callArgs = callArgs + ",";
            }
            callArgs = callArgs + "arguments";
        }
        if (contextInfo.hasReturnInside) {
            callPrefix = callPrefix + this.getReturnStatementPrefix();
        }
        if (makeProperty) {
            introducedFunctionText = "x = {\n" + introducedFunctionText;
        }
        if (settings.makeFunctionExpression() && (makeProperty || ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.anchor, introductionScope.parent) != null)) {
            callPrefix = callPrefix + "this.";
        }
        introducedFunctionText = this.addBodyToSignature(introducedFunctionText, text);
        if (settings.makeFunctionExpression() && !JSExtractFunctionHandler.isPropertyContext(introductionScope.parent) && !introductionScope.isClassContext()) {
            introducedFunctionText = introducedFunctionText + semicolon;
        }
        FormatFixer formatFixer = FormatFixer.create(contextInfo.file, contextInfo.possibleRange, editor.getDocument(), FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
        Pair expressionDescriptor = null;
        JSBaseIntroduceHandler.Replacer replacer = null;
        if (contextInfo.isExpression) {
            PsiElement psiElement = contextInfo.extractedElements.get(0);
            if (psiElement.getTextRange().equals((Object)trimmedPossibleRange)) {
                expressionDescriptor = new Pair((Object)((JSExpression)psiElement), null);
            } else {
                while (!psiElement.getTextRange().contains(contextInfo.possibleRange) && (parent = psiElement.getParent()) instanceof JSExpression && (psiElement = parent) != null) {
                }
                if (psiElement != null) {
                    expressionDescriptor = Pair.create((Object)((JSExpression)psiElement), (Object)contextInfo.possibleRange);
                }
            }
            if (expressionDescriptor != null) {
                replacer = new JSBaseIntroduceHandler.Replacer((Pair<JSExpression, TextRange>)expressionDescriptor);
            }
        }
        if ((fromText = this.createAstNodeForIntroducedFunctionText(project, introductionScope, introducedFunctionText)) != null) {
            Object element;
            parent = introductionScope.parent;
            if (makeProperty) {
                JSExpression expression = ((JSAssignmentExpression)((JSExpressionStatement)fromText.getPsi()).getExpression()).getROperand();
                fromText = ((JSObjectLiteralExpression)expression).getFirstProperty().getNode();
            } else if (JSExtractFunctionHandler.isPropertyContext(introductionScope.parent)) {
                parent = PsiTreeUtil.getParentOfType((PsiElement)contextInfo.anchor, JSBlockStatement.class);
            }
            PsiElement functionAnchor = JSExtractFunctionHandler.findFunctionAnchor(parent, contextInfo.anchor);
            Object object = element = this.needInsertAfter(parent, functionAnchor) ? parent.addAfter(fromText.getPsi(), functionAnchor) : parent.addBefore(fromText.getPsi(), functionAnchor);
            if (contextInfo.ecmaL4 && element instanceof JSFunction) {
                PsiElement typeElement = ((JSFunction)element).getReturnTypeElement();
                String typeName = JSResolveUtil.getShortTypeName(introductionScope.returnType, true);
                if (typeElement != null && introductionScope.returnType.indexOf(46) != -1 && !introductionScope.returnType.equals(typeName)) {
                    ImportUtils.doImport(typeElement, introductionScope.returnType, false);
                }
            }
            if (doReformat) {
                CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(parent.getNode(), element.getNode());
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        } else assert (false) : introducedFunctionText;
        String callString = this.createMethodCallStringAfterExtractMethod(settings, contextInfo, callArgs, callPrefix);
        PsiElement call = JSChangeUtil.createStatementFromText(project, callString + semicolon, this.dialect).getPsi();
        if (contextInfo.isExpression) {
            if (expressionDescriptor != null) {
                replacer.replaceExpr((JSExpression)expressionDescriptor.first, ((JSExpressionStatement)call).getExpression());
            }
        } else if (contextInfo.extractedElements.size() == 1) {
            contextInfo.extractedElements.iterator().next().replace(call);
        } else {
            contextInfo.anchor = contextInfo.anchor.getParent().addBefore(call, contextInfo.anchor);
            for (PsiElement s : contextInfo.extractedElements) {
                if (!s.isValid()) continue;
                PsiElement prev = s.getPrevSibling();
                if (prev instanceof PsiWhiteSpace) {
                    prev.delete();
                }
                s.delete();
            }
            SmartPsiElementPointer pointer = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(contextInfo.anchor);
            contextInfo.anchor = pointer.getElement();
        }
        if (callSuffix.length() > 0) {
            PsiElement callEpilogue = JSChangeUtil.createJSTreeFromText(project, callSuffix, this.dialect).getPsi();
            PsiElement last = callEpilogue.getNextSibling();
            while (last.getNextSibling() != null) {
                last = last.getNextSibling();
            }
            contextInfo.anchor.getParent().addRangeAfter(callEpilogue, last, contextInfo.anchor);
            CodeStyleManager.getInstance((Project)project).reformatNewlyAddedElement(contextInfo.anchor.getParent().getNode(), contextInfo.anchor.getNode());
        }
    }

    protected String createMethodCallStringAfterExtractMethod(JSExtractFunctionSettings settings, ContextInfo contextInfo, String callArgs, String callPrefix) {
        boolean shouldProvideDirectThis;
        IntroductionScope scope = settings.getIntroductionScope();
        if (scope.isClassContext() && !contextInfo.ecmaL4) {
            String prefix = settings.makeStatic() ? ((JSClass)scope.getParent()).getName() : "this";
            return prefix + "." + settings.getMethodName() + "(" + callArgs + ")";
        }
        PsiElement parent = settings.getIntroductionScope().parent;
        boolean bl = shouldProvideDirectThis = !settings.makeFunctionExpression() || settings.makeFunctionExpression() && ExtractedFunctionSignatureGenerator.findClassRefForScope(contextInfo.anchor, parent) == null && !JSExtractFunctionHandler.isPropertyContext(parent);
        if (shouldProvideDirectThis && !this.ecmaL4 && contextInfo.hasThisUsage) {
            return callPrefix + settings.getMethodName() + ".call(this" + (callArgs.isEmpty() ? "" : ", ") + callArgs + ")";
        }
        return callPrefix + settings.getMethodName() + "(" + callArgs + ")";
    }

    protected ASTNode createAstNodeForIntroducedFunctionText(Project project, IntroductionScope introductionScope, String introducedFunctionText) {
        PsiElement parent;
        if (introductionScope.isClassContext() && !DialectDetector.isActionScript(parent = introductionScope.getParent())) {
            return JSChangeUtil.createClassMemberFromText(project, introducedFunctionText, JSUtils.getDialect(parent.getContainingFile()));
        }
        return JSChangeUtil.createJSTreeFromText(project, introducedFunctionText, this.dialect);
    }

    protected String getStatementTerminator(ContextInfo contextInfo) {
        return JSCodeStyleSettings.getSemicolon(contextInfo.file);
    }

    protected String getReturnStatementPrefix() {
        return "return ";
    }

    protected ExtractedFunctionSignatureGenerator getSignatureGenerator() {
        return new ExtractedFunctionSignatureGenerator();
    }

    protected String getVariableDeclarationPrefix() {
        return "var ";
    }

    protected String addBodyToSignature(String signature, String body) {
        return signature + "{\n" + body + "\n}";
    }

    public static PsiElement findFunctionAnchor(PsiElement parent, PsiElement functionAnchor) {
        InspectionProfileImpl inspectionProfile;
        LocalInspectionToolWrapper localInspectionToolWrapper;
        PsiElement grandParent;
        PsiComment docComment;
        while (functionAnchor != null && functionAnchor.getParent() != parent) {
            functionAnchor = functionAnchor.getParent();
        }
        if (functionAnchor instanceof JSProperty && (docComment = JSDocumentationUtils.findDocComment(functionAnchor)) != null) {
            functionAnchor = docComment;
        }
        if ((grandParent = parent.getParent()) instanceof JSFunction && (localInspectionToolWrapper = (LocalInspectionToolWrapper)(inspectionProfile = InspectionProjectProfileManager.getInstance((Project)grandParent.getProject()).getCurrentProfile()).getInspectionTool(JSDeclarationsAtScopeStartInspection.SHORT_NAME, grandParent)) != null && inspectionProfile.isToolEnabled(HighlightDisplayKey.find((String)JSDeclarationsAtScopeStartInspection.SHORT_NAME), functionAnchor)) {
            JSStatement statement = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement(functionAnchor);
            while (statement instanceof JSVarStatement && !PsiTreeUtil.isAncestor((PsiElement)statement, (PsiElement)grandParent, (boolean)true) || statement instanceof PsiWhiteSpace || statement instanceof PsiComment) {
                statement = statement.getNextSibling();
            }
            if (statement != null) {
                return statement;
            }
        }
        return functionAnchor;
    }

    protected boolean needInsertAfter(PsiElement parent, PsiElement functionAnchor) {
        return parent instanceof JSClass || functionAnchor instanceof JSPackageStatement;
    }

    static boolean isArgumentsReference(JSVariable var) {
        return "arguments".equals(var.getName()) && !(var instanceof JSParameter);
    }

    private static PsiElement getBase(JSVariable var) {
        return PsiTreeUtil.getParentOfType((PsiElement)var, (Class[])new Class[]{JSFunction.class, JSObjectLiteralExpression.class, XmlTagChild.class, JSClass.class, JSFile.class});
    }

    private static String getExpressionElementPresentation(PsiElement element) {
        if (element instanceof JSFunctionExpression) {
            element = ((JSFunctionExpression)element).getBody()[0];
        }
        String compactedText = element.getText().replaceAll("[\\n|\\r| ]+", " ");
        return "starting with " + compactedText.substring(0, Math.min(compactedText.length(), 30));
    }

    @Nullable
    protected IntroductionScope createPairWithPresentation(PsiElement parent) {
        if (parent == null) {
            return null;
        }
        String presentation = null;
        boolean forceMakeFunExpr = false;
        PsiElement element = parent;
        Class[] classes = (Class[])ArrayUtil.append((Object[])this.getScopeTypes(), JSFunction.class);
        while (element instanceof JSBlockStatement) {
            element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])classes);
        }
        if (element instanceof JSObjectLiteralExpression) {
            PsiElement objectParent = element.getParent();
            JSExpression assignedTo = null;
            if (objectParent instanceof JSAssignmentExpression) {
                assignedTo = ((JSAssignmentExpression)objectParent).getLOperand();
            } else if (objectParent instanceof JSVariable) {
                assignedTo = ((JSVariable)objectParent).getNameIdentifier();
            }
            presentation = "object " + (assignedTo == null ? JSExtractFunctionHandler.getExpressionElementPresentation(element) : "assigned to " + assignedTo.getText());
            forceMakeFunExpr = true;
        } else if (element instanceof JSClass) {
            presentation = "class " + ((JSClass)element).getName();
        } else if (element instanceof JSFile) {
            presentation = "global";
        } else if (element instanceof XmlTagChild) {
            String string = presentation = element instanceof JSEmbeddedContent ? "global" : "xml tag";
            if (element instanceof XmlTag) {
                presentation = presentation + " " + ((XmlTag)element).getName();
            }
        } else if (element instanceof JSFunction) {
            String functionName = ((JSFunction)element).getQualifiedName();
            presentation = "function " + (functionName == null ? JSExtractFunctionHandler.getExpressionElementPresentation(element) : functionName);
        } else if (element instanceof TypeScriptModule) {
            presentation = "module " + ((TypeScriptModule)element).getName();
        }
        IntroductionScope scope = new IntroductionScope();
        scope.parent = parent;
        scope.presentation = presentation;
        scope.forceMakeFunExpr = forceMakeFunExpr;
        return scope;
    }

    protected Class[] getScopeTypes() {
        return classTypes;
    }

    protected boolean acceptBlockStatementAsScope(JSBlockStatement blockStatement) {
        return false;
    }

    @Nullable
    public IntroductionScope findBase(PsiElement at, boolean findAll) {
        PsiElement classFromContext;
        PsiElement decorator = PsiTreeUtil.getParentOfType((PsiElement)at, ES6Decorator.class);
        if (decorator != null) {
            IntroductionScope base = this.findBase(decorator, findAll);
            while (base != null && base.getParent() instanceof JSClass) {
                base = this.findBase(base.getParent(), findAll);
            }
            return base;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)at, (Class[])this.getScopeTypes());
        boolean stopOnNextParent = false;
        while (parent instanceof JSBlockStatement) {
            if (this.acceptBlockStatementAsScope((JSBlockStatement)parent) || stopOnNextParent) {
                return this.createPairWithPresentation(parent);
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSFunction) {
                if (findAll) {
                    return this.createPairWithPresentation(parent);
                }
                PsiElement ref = ExtractedFunctionSignatureGenerator.findClassRef(parent);
                if (ref != null) {
                    stopOnNextParent = true;
                    parent = grandParent;
                } else if (grandParent instanceof JSFunctionExpression && !ActionScriptResolveUtil.isAnonymousEventHandler((JSFunctionExpression)grandParent)) {
                    PsiElement grandParent2 = grandParent.getParent();
                    if (grandParent2 instanceof JSParenthesizedExpression) {
                        grandParent2 = grandParent2.getParent();
                    }
                    if (grandParent2 instanceof JSCallExpression) {
                        return this.createPairWithPresentation(parent);
                    }
                }
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])this.getScopeTypes());
        }
        if (parent instanceof JSFile && parent.getContext() != null && (classFromContext = JSResolveUtil.getClassReferenceForXmlFromContext(parent)) != null) {
            parent = classFromContext;
        }
        if (at instanceof XmlBackedJSClass) {
            return null;
        }
        return this.createPairWithPresentation(parent);
    }

    public List<IntroductionScope> findBases(PsiElement at) {
        ArrayList<IntroductionScope> scopes = new ArrayList<IntroductionScope>();
        IntroductionScope currentScope = this.findBase(at, true);
        while (currentScope != null && !(currentScope.parent instanceof JSFile) && !(currentScope.parent instanceof XmlTagChild)) {
            scopes.add(currentScope);
            currentScope = this.findBase(currentScope.parent, true);
        }
        if (currentScope != null) {
            scopes.add(currentScope);
        }
        return scopes;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/refactoring/extractMethod/JSExtractFunctionHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }

    public static JSExtractFunctionSettings.ParametersInfo getNotNullParametersInfo(JSExtractFunctionSettings settings) {
        JSExtractFunctionSettings.ParametersInfo parametersInfo = settings.getParametersInfo();
        if (parametersInfo != null) {
            return parametersInfo;
        }
        return JSExtractFunctionHandler.createDefaultParametersInfo(settings.getIntroductionScope());
    }

    public static List<JSVariable> getOrderedParameters(JSExtractFunctionSettings.ParametersInfo parametersInfo) {
        ArrayList<JSVariable> parameters = new ArrayList<JSVariable>(parametersInfo.variables);
        if (parametersInfo.variables.size() != parametersInfo.variableOptions.size()) {
            return parameters;
        }
        Collections.sort(parameters, (o1, o2) -> parametersInfo.variableOptions.get((Object)o1).index - parametersInfo.variableOptions.get((Object)o2).index);
        return parameters;
    }

    private static /* synthetic */ void lambda$getIntroductionScope$1(Pass callback, JList list) {
        callback.pass((Object)((IntroductionScope)list.getSelectedValue()));
    }

    public static class IntroductionScope {
        PsiElement parent;
        String presentation;
        boolean forceMakeFunExpr;
        Set<JSVariable> usedVars = new LinkedHashSet<JSVariable>();
        Set<JSVariable> outputVars = new LinkedHashSet<JSVariable>();
        String returnType;

        public IntroductionScope() {
        }

        public IntroductionScope(PsiElement parent, String presentation) {
            this.parent = parent;
            this.presentation = presentation;
        }

        public String toString() {
            return this.presentation;
        }

        public boolean isClassContext() {
            return this.parent instanceof JSClass;
        }

        public boolean isGlobal() {
            return this.parent instanceof JSFile || this.parent instanceof JSEmbeddedContent;
        }

        public PsiElement getParent() {
            return this.parent;
        }
    }

    public class ContextInfo {
        final List<PsiElement> extractedElements = new ArrayList<PsiElement>();
        private final TextRange possibleRange;
        private final List<RangeMarker> continueStatementsToReplaceWithReturn = new ArrayList<RangeMarker>();
        private final Map<RangeMarker, JSVariable> parameterReferences = new LinkedHashMap<RangeMarker, JSVariable>();
        public final List<IntroductionScope> introductionScopes;
        final PsiFile file;
        public final boolean ecmaL4;
        boolean isExpression;
        public PsiElement anchor;
        boolean hasReturnInside;
        boolean hasThisUsage;
        private String myProblem;
        public DialectOptionHolder holder;

        public ContextInfo(Editor editor) {
            PsiElement statement;
            PsiElement at;
            final Document document = editor.getDocument();
            int start = JSExtractFunctionHandler.this.getExtractFragmentStartOffset(editor);
            int end = JSExtractFunctionHandler.this.getExtractFragmentEndOffset(editor);
            this.possibleRange = new TextRange(start, end);
            this.file = PsiDocumentManager.getInstance((Project)editor.getProject()).getPsiFile(document);
            this.holder = DialectDetector.dialectOfElement((PsiElement)this.file);
            this.ecmaL4 = this.holder != null && this.holder.isECMA4;
            PsiElement nonEmptyAt = at = this.file.findElementAt(start);
            while (nonEmptyAt instanceof PsiWhiteSpace || nonEmptyAt instanceof PsiComment) {
                nonEmptyAt = nonEmptyAt.getNextSibling();
            }
            PsiElement elementToSearchScope = nonEmptyAt;
            this.anchor = statement = JSExtractFunctionHandler.this.findStatement(at, start, end);
            if (statement instanceof PsiWhiteSpace) {
                this.anchor = statement.getNextSibling();
            }
            PsiElement statement2 = JSExtractFunctionHandler.this.findStatement(this.file.findElementAt(end - 1), start, end);
            this.isExpression = false;
            JSExpression node = null;
            final TextRange extractionRange = new TextRange(start, end);
            if (statement == statement2 && statement != null) {
                JSExpression expression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)nonEmptyAt, JSExpression.class, (boolean)false);
                while (expression != null && extractionRange.contains(expression.getTextRange())) {
                    node = expression;
                    expression = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)expression, JSExpression.class);
                }
                if (node != null && !extractionRange.contains(statement.getTextRange())) {
                    this.extractedElements.add((PsiElement)node);
                    PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)node, (boolean)true);
                    while (nextLeaf != null && extractionRange.contains(nextLeaf.getTextRange())) {
                        JSExpression parentExpr = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)nextLeaf, JSExpression.class);
                        PsiElement nextExpr = null;
                        while (parentExpr != null && extractionRange.contains(parentExpr.getTextRange())) {
                            nextExpr = parentExpr;
                            parentExpr = (JSExpression)PsiTreeUtil.getParentOfType((PsiElement)parentExpr, JSExpression.class);
                        }
                        if (nextExpr != null) {
                            this.extractedElements.add(nextExpr);
                        }
                        nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)(nextExpr != null ? nextExpr : nextLeaf), (boolean)true);
                    }
                    this.isExpression = true;
                    elementToSearchScope = node;
                }
            }
            this.introductionScopes = JSExtractFunctionHandler.this.findBases(elementToSearchScope);
            final Ref returnType = new Ref();
            JSRecursiveElementVisitor elementVisitor = new JSRecursiveElementVisitor(){
                final Set<JSVariable> processed = new THashSet();
                JSFunction currentFunction;

                public void visitJSReferenceExpression(JSReferenceExpression node) {
                    PsiElement element;
                    if (node.getQualifier() == null && !JSResolveUtil.isSelfReference((PsiElement)node) && (element = node.resolve()) instanceof JSVariable && element.getContainingFile().getOriginalFile().equals(node.getContainingFile().getOriginalFile())) {
                        JSVariable var = (JSVariable)element;
                        this.handleVariable(var, true);
                        ContextInfo.this.parameterReferences.put(document.createRangeMarker(node.getTextRange()), var);
                    }
                    super.visitJSReferenceExpression(node);
                }

                public void visitJSBreakStatement(JSBreakStatement node) {
                    JSStatement statementToBreak = node.getStatementToBreak();
                    if (statementToBreak == null || !extractionRange.contains(statementToBreak.getTextRange())) {
                        ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.break.statement", (Object[])new Object[0]);
                    }
                    super.visitJSBreakStatement(node);
                }

                public void visitJSContinueStatement(JSContinueStatement node) {
                    JSStatement statementToContinue = node.getStatementToContinue();
                    boolean continueFromCompletelyExtractedLoopBody = false;
                    if (statementToContinue instanceof JSLoopStatement && !extractionRange.contains(statementToContinue.getTextRange())) {
                        JSStatement body;
                        JSStatement firstChild = body = ((JSLoopStatement)statementToContinue).getBody();
                        JSStatement lastChild = body;
                        if (body instanceof JSBlockStatement) {
                            firstChild = body.getFirstChild();
                            lastChild = body.getLastChild();
                            if (firstChild.getNode().getElementType() == JSTokenTypes.LBRACE && (firstChild = firstChild.getNextSibling()) instanceof PsiWhiteSpace) {
                                firstChild = firstChild.getNextSibling();
                            }
                            if (lastChild.getNode().getElementType() == JSTokenTypes.RBRACE && (lastChild = lastChild.getPrevSibling()) instanceof PsiWhiteSpace) {
                                lastChild = lastChild.getPrevSibling();
                            }
                        }
                        if (firstChild != null && lastChild != null && extractionRange.contains(new TextRange(firstChild.getTextOffset(), lastChild.getTextRange().getEndOffset()))) {
                            continueFromCompletelyExtractedLoopBody = true;
                            ContextInfo.this.continueStatementsToReplaceWithReturn.add(document.createRangeMarker(node.getTextRange()));
                        }
                    }
                    if (statementToContinue == null || !continueFromCompletelyExtractedLoopBody && !extractionRange.contains(statementToContinue.getTextRange())) {
                        ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.continue.statement", (Object[])new Object[0]);
                    }
                    super.visitJSContinueStatement(node);
                }

                public void visitJSVariable(JSVariable node) {
                    super.visitJSVariable(node);
                    this.handleVariable(node, false);
                }

                public void visitJSReturnStatement(JSReturnStatement node) {
                    super.visitJSReturnStatement(node);
                    if (this.currentFunction == null) {
                        if (!ContextInfo.this.isExpression && ContextInfo.this.extractedElements.get(ContextInfo.this.extractedElements.size() - 1) != node) {
                            ContextInfo.this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.conditional.return", (Object[])new Object[0]);
                        }
                        returnType.set((Object)JSResolveUtil.getExpressionType(node.getExpression(), ContextInfo.this.file));
                        ContextInfo.this.hasReturnInside = true;
                    }
                }

                public void visitJSFunctionExpression(JSFunctionExpression node) {
                    JSFunction prevCurrentFunction = this.currentFunction;
                    this.currentFunction = node;
                    super.visitJSFunctionExpression(node);
                    this.currentFunction = prevCurrentFunction;
                }

                public void visitJSFunctionDeclaration(JSFunction node) {
                    JSFunction prevCurrentFunction = this.currentFunction;
                    this.currentFunction = node;
                    super.visitJSFunctionDeclaration(node);
                    this.currentFunction = prevCurrentFunction;
                }

                public void visitJSThrowStatement(JSThrowStatement node) {
                    super.visitJSThrowStatement(node);
                }

                public void visitJSThisExpression(JSThisExpression node) {
                    if (this.currentFunction == null) {
                        ContextInfo.this.hasThisUsage = true;
                    }
                    super.visitJSThisExpression(node);
                }

                private void handleVariable(JSVariable var, boolean referencedInFragment) {
                    if (!this.processed.contains(var)) {
                        if (JSResolveUtil.findParent((PsiElement)var) instanceof JSClass) {
                            this.processed.add(var);
                            return;
                        }
                        boolean hasReadsOutOfBlock = false;
                        THashSet hasWritesInBlock = new THashSet();
                        if (!referencedInFragment && var.getInitializer() != null) {
                            hasWritesInBlock.addAll(ContextInfo.this.introductionScopes);
                        }
                        PsiElement varBase = JSExtractFunctionHandler.getBase(var);
                        THashSet varIsReachableFrom = new THashSet();
                        for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                            if (!ContextInfo.this.reachableFromExtractScope(varBase, scope.parent)) continue;
                            varIsReachableFrom.add(scope);
                        }
                        for (PsiReference ref : ReferencesSearch.search((PsiElement)var, (SearchScope)JSRefactoringUtil.getElementSearchScope((PsiElement)var))) {
                            TextRange textRange = ref.getElement().getTextRange();
                            ReadWriteAccessDetector.Access access = JSReadWriteAccessDetector.ourInstance.getExpressionAccess(ref.getElement());
                            if (!(access == ReadWriteAccessDetector.Access.Write && !JSResolveUtil.isSelfReference(ref.getElement()) || extractionRange.contains(textRange) && !this.isInsideLoop(ref.getElement(), varBase))) {
                                hasReadsOutOfBlock = true;
                            }
                            if (access == ReadWriteAccessDetector.Access.Read || !extractionRange.contains(textRange)) continue;
                            for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                                if (varIsReachableFrom.contains(scope)) continue;
                                hasWritesInBlock.add(scope);
                            }
                        }
                        if (hasReadsOutOfBlock) {
                            for (IntroductionScope scope : hasWritesInBlock) {
                                scope.outputVars.add(var);
                            }
                        }
                        if (referencedInFragment) {
                            for (IntroductionScope scope : ContextInfo.this.introductionScopes) {
                                if (varIsReachableFrom.contains(scope)) continue;
                                scope.usedVars.add(var);
                            }
                        }
                        this.processed.add(var);
                    }
                }

                private boolean isInsideLoop(PsiElement element, PsiElement varBase) {
                    PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{JSLoopStatement.class, varBase.getClass()});
                    while (parent instanceof JSLoopStatement) {
                        if (!extractionRange.contains(parent.getTextRange())) {
                            return true;
                        }
                        parent = PsiTreeUtil.getParentOfType((PsiElement)parent, (Class[])new Class[]{JSLoopStatement.class, varBase.getClass()});
                    }
                    return false;
                }
            };
            if (this.isExpression) {
                for (PsiElement element2 : this.extractedElements) {
                    element2.accept((PsiElementVisitor)elementVisitor);
                }
            }
            while (statement != null) {
                TextRange textRange = statement.getTextRange();
                if (!extractionRange.contains(textRange)) {
                    boolean nonws;
                    boolean intersects = textRange.intersectsStrict(extractionRange);
                    boolean bl = nonws = !(statement instanceof PsiWhiteSpace);
                    if (nonws || !intersects) {
                        if (!nonws || !intersects || textRange.contains(extractionRange)) break;
                        this.extractedElements.clear();
                        break;
                    }
                }
                this.extractedElements.add(statement);
                statement.accept((PsiElementVisitor)elementVisitor);
                if (statement == statement2) break;
                PsiElement n = statement.getNextSibling();
                statement = null;
                while (n != null) {
                    if (!(n instanceof PsiWhiteSpace)) {
                        statement = n;
                        break;
                    }
                    if (n == statement2) break;
                    n = n.getNextSibling();
                }
                if (n == null) break;
                if (!JSExtractFunctionHandler.this.notAllowedStatement(n)) continue;
                this.extractedElements.clear();
                break;
            }
            if (this.isExpression) {
                JSExpression expression = (JSExpression)this.extractedElements.get(0);
                returnType.set((Object)(expression.getParent() instanceof JSExpressionStatement ? JSExtractFunctionHandler.VOID_TYPE_NAME : JSResolveUtil.getExpressionType(expression, this.file)));
            } else {
                for (IntroductionScope scope : this.introductionScopes) {
                    int outputVarsSize = scope.outputVars.size();
                    String scopeReturnType = (String)returnType.get();
                    if (outputVarsSize == 1) {
                        JSVariable next = scope.outputVars.iterator().next();
                        JSType type = next.getType();
                        String string = scopeReturnType = type == null ? null : type.getTypeText(JSType.TypeTextFormat.CODE);
                        if (scopeReturnType == null) {
                            scopeReturnType = "*";
                        }
                    } else if (outputVarsSize > 1) {
                        scopeReturnType = "Object";
                    }
                    scope.returnType = scopeReturnType;
                }
            }
            for (IntroductionScope scope : this.introductionScopes) {
                if (scope.returnType != null) continue;
                scope.returnType = returnType.get() == null ? JSExtractFunctionHandler.VOID_TYPE_NAME : (String)returnType.get();
            }
            if (this.extractedElements.size() == 0 || this.anchor == null || ContainerUtil.and(this.extractedElements, element -> element instanceof PsiWhiteSpace)) {
                this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.bad.selection", (Object[])new Object[0]);
            }
            if (this.continueStatementsToReplaceWithReturn.size() != 0) {
                boolean allScopesReturnVoid = true;
                for (IntroductionScope scope : this.introductionScopes) {
                    if (JSExtractFunctionHandler.VOID_TYPE_NAME.equals(scope.returnType)) continue;
                    allScopesReturnVoid = false;
                }
                if (!allScopesReturnVoid) {
                    this.myProblem = JSBundle.message((String)"javascript.refactoring.extract.function.code.contain.continue.statement", (Object[])new Object[0]);
                }
            }
        }

        private boolean reachableFromExtractScope(PsiElement varScope, PsiElement parent) {
            if (parent == varScope || parent.getParent() == varScope) {
                return true;
            }
            return PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)varScope) == varScope;
        }

        public String getProblem() {
            return this.myProblem;
        }
    }
}

