/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.introduceParameter;

import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.documentation.JSDocumentationProcessor;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTag;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseInplaceIntroducer;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceDialog;
import com.intellij.lang.javascript.refactoring.introduce.JSBaseIntroduceHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterHandler;
import com.intellij.lang.javascript.refactoring.introduceParameter.JSIntroduceParameterSettings;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import gnu.trove.THashSet;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class JSParameterInplaceIntroducer
extends JSBaseInplaceIntroducer<JSIntroduceParameterSettings> {
    private boolean myIsOptional = JSIntroduceParameterHandler.ourLastOptionalParam;
    private boolean myAddJsDoc = JSIntroduceParameterHandler.ourLastAddJsDoc;
    private final String myInitialInitialValue = ((JSIntroduceParameterSettings)this.myInitialSettings).getInitialValue();

    public JSParameterInplaceIntroducer(Editor editor, Project project, JSExpression[] occurrences, JSBaseIntroduceHandler<JSElement, JSIntroduceParameterSettings, ? extends JSBaseIntroduceDialog> handler, JSBaseIntroduceHandler.BaseIntroduceContext<JSIntroduceParameterSettings> context) {
        super(project, editor, (JSExpression)context.expressionDescriptor.first, occurrences, (FileType)JavaScriptFileType.INSTANCE, handler, context);
    }

    @Override
    protected JSIntroduceParameterSettings getInplaceIntroduceSettings(final String name) {
        return new JSIntroduceParameterSettings(){

            @Override
            public boolean addOptionalParameter() {
                return JSParameterInplaceIntroducer.this.myIsOptional;
            }

            @Override
            public boolean addJsDoc() {
                return JSParameterInplaceIntroducer.this.myAddJsDoc;
            }

            @Override
            public String getInitialValue() {
                return JSParameterInplaceIntroducer.this.myInitialInitialValue;
            }

            @Override
            public JSFunction functionForIntroduceParameter() {
                return ((JSIntroduceParameterSettings)JSParameterInplaceIntroducer.this.myInitialSettings).functionForIntroduceParameter();
            }

            @Override
            public boolean isReplaceAllOccurrences() {
                return JSParameterInplaceIntroducer.this.isReplaceAllOccurrences();
            }

            @Override
            public String getVariableName() {
                return name;
            }

            @Override
            public String getVariableType() {
                return ((JSIntroduceParameterSettings)JSParameterInplaceIntroducer.this.myInitialSettings).getVariableType();
            }
        };
    }

    protected JComponent getComponent() {
        JPanel panel = new JPanel();
        panel.setBorder(null);
        panel.setLayout(new BoxLayout(panel, 1));
        JCheckBox addJsDoc = new JCheckBox("Generate JSDoc");
        addJsDoc.setMnemonic('g');
        addJsDoc.setFocusable(false);
        addJsDoc.setSelected(JSIntroduceParameterHandler.ourLastAddJsDoc);
        addJsDoc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSIntroduceParameterHandler.ourLastAddJsDoc = JSParameterInplaceIntroducer.this.myAddJsDoc = ((JCheckBox)e.getSource()).isSelected();
                JSParameterInplaceIntroducer.this.restartInplaceIntroduceTemplate();
            }
        });
        panel.add(addJsDoc);
        JCheckBox optional = new JCheckBox("Optional parameter");
        optional.setMnemonic('o');
        optional.setFocusable(false);
        optional.setSelected(JSIntroduceParameterHandler.ourLastOptionalParam);
        optional.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSIntroduceParameterHandler.ourLastOptionalParam = JSParameterInplaceIntroducer.this.myIsOptional = ((JCheckBox)e.getSource()).isSelected();
                JSParameterInplaceIntroducer.this.restartInplaceIntroduceTemplate();
            }
        });
        panel.add(optional);
        return panel;
    }

    @Override
    protected void deleteTemplateField(JSVariable psiField) {
        if (!this.myDeleteSelf) {
            return;
        }
        JSFunction fun = ((JSIntroduceParameterSettings)this.myInitialSettings).functionForIntroduceParameter();
        ((JSIntroduceParameterHandler)this.myIntroduceHandler).removeOptionalParameterInitializer();
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)fun);
        if (comment instanceof JSDocComment) {
            Document document = fun.getContainingFile().getViewProvider().getDocument();
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)fun.getProject());
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            THashSet set = new THashSet();
            String name = ((JSIntroduceParameterSettings)this.myInitialSettings).getVariableName();
            JSDocTag[] tags = ((JSDocComment)comment).getTags();
            for (int i = 0; i < tags.length; ++i) {
                JSDocTag tag = tags[i];
                JSDocumentationUtils.DocTag docTag = JSDocumentationUtils.getDocTag(tag.getText());
                if (docTag == null || docTag.type != JSDocumentationProcessor.MetaDocType.PARAMETER || !StringUtil.equals((CharSequence)name, (CharSequence)docTag.matchName)) continue;
                set.add(i);
            }
            JSDocumentationUtils.createOrUpdateTagsInDocComment((PsiElement)fun, null, null, (Set<Integer>)set);
            documentManager.commitAllDocuments();
        }
        super.deleteTemplateField(psiField);
    }

    protected void collectAdditionalElementsToRename(List<Pair<PsiElement, TextRange>> stringUsages) {
        super.collectAdditionalElementsToRename(stringUsages);
        JSAssignmentExpression occurrence = ((JSIntroduceParameterHandler)this.myIntroduceHandler).getOptionalInitializer();
        if (occurrence != null) {
            PsiElement ref = occurrence.getFirstChild();
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)ref, (Object)new TextRange(0, ref.getTextLength())));
            PsiElement param = occurrence.getROperand().getFirstChild();
            stringUsages.add((Pair<PsiElement, TextRange>)Pair.create((Object)param, (Object)new TextRange(0, param.getTextLength())));
        }
    }

    protected void addReferenceAtCaret(Collection<PsiReference> refs) {
    }
}

