/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.ui;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.parsing.JavaScriptParserBase;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSExpressionCodeFragment;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.CompletionResultSink;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.refactoring.ui.JSEditorTextField;
import com.intellij.lang.javascript.ui.JSClassChooserDialog;
import com.intellij.lang.javascript.ui.JSPackageChooserDialog;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.ComboboxEditorTextField;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSReferenceEditor
extends ComponentWithBrowseButton<JComponent>
implements TextAccessor {
    private final Project myProject;
    private final String myRecentsKey;
    private GlobalSearchScope myScope;
    @Nullable
    private String myChooserBlockMessage;

    protected abstract ActionListener createActionListener();

    private JSReferenceEditor(String text, @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope, @Nullable JavaScriptParserBase.ForceContext typeContext, @Nullable Condition<PsiElement> filter, final @NotNull String chooserTitle, boolean needPackages, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "<init>"));
        }
        if (chooserTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooserTitle", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "<init>"));
        }
        super((JComponent)(recentsKey != null ? JSReferenceEditor.createEditorCombo(project, JSReferenceEditor.createDocument(StringUtil.notNullize((String)text), project, scope, typeContext, filter, needPackages, context)) : new JSEditorTextField(project, JSReferenceEditor.createDocument(StringUtil.notNullize((String)text), project, scope, typeContext, filter, needPackages, context))), null);
        this.myProject = project;
        this.myRecentsKey = recentsKey;
        this.myScope = scope;
        if (this.myRecentsKey != null) {
            List recentEntries = RecentsManager.getInstance((Project)this.myProject).getRecentEntries(recentsKey);
            if (recentEntries != null) {
                ((EditorComboBox)this.getChildComponent()).setHistory(ArrayUtil.toStringArray((Collection)recentEntries));
            }
            if (text != null) {
                ((EditorComboBox)this.getChildComponent()).prependItem(text);
            }
        }
        final ActionListener actionListener = this.createActionListener();
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (JSReferenceEditor.this.myChooserBlockMessage != null) {
                    Messages.showErrorDialog((String)JSReferenceEditor.this.myChooserBlockMessage, (String)chooserTitle);
                } else {
                    actionListener.actionPerformed(e);
                }
            }
        });
    }

    public void setScope(GlobalSearchScope scope) {
        this.myScope = scope;
        PsiFile codeFragment = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument());
        ((PsiCodeFragment)codeFragment).forceResolveScope(scope);
        this.invalidateHighlight();
    }

    public void invalidateHighlight() {
        this.setText(this.getText(), true);
    }

    public void setChooserBlockingMessage(@Nullable String message) {
        this.myChooserBlockMessage = message;
    }

    @Deprecated
    public void setHeightProvider(Computable<Integer> heightProvider) {
        if (this.getChildComponent() instanceof MyEditorComboBox) {
            ((MyEditorComboBox)((Object)this.getChildComponent())).setHeightProvider(heightProvider);
        }
    }

    public static EditorComboBox createEditorCombo(Project project, Document document) {
        return new MyEditorComboBox(document, project);
    }

    private static Document createDocument(String text, Project project, GlobalSearchScope scope, @Nullable JavaScriptParserBase.ForceContext typeContext, final @Nullable Condition<PsiElement> filter, final boolean needPackages, @Nullable PsiElement context) {
        JSExpressionCodeFragment fragment = JSElementFactory.createExpressionCodeFragment(project, text, null, JavaScriptSupportLoader.ECMA_SCRIPT_L4, scope, JSElementFactory.TopLevelCompletion.NO, typeContext);
        fragment.putUserData(JSResolveUtil.contextKey, context);
        fragment.putUserData(ResolveProcessor.PROCESSING_OPTIONS, new ResolveProcessor.ProcessingOptions(){

            @Override
            public boolean needPackages() {
                return needPackages;
            }

            @Override
            @Nullable
            public Condition<PsiElement> getFilter() {
                return filter;
            }
        });
        return PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)fragment);
    }

    public void addDocumentListener(DocumentListener listener) {
        this.getDocument().addDocumentListener(listener);
    }

    public PsiFile getPsiFile() {
        return PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.getDocument());
    }

    private Document getDocument() {
        return this.getChildComponent() instanceof EditorComboBox ? ((EditorComboBox)this.getChildComponent()).getDocument() : ((EditorTextField)this.getChildComponent()).getDocument();
    }

    public String getText() {
        return this.getDocument().getText().trim();
    }

    public void setText(String text) {
        this.setText(text, false);
    }

    private void setText(String text, boolean keepCaret) {
        if (text == null) {
            text = "";
        }
        if (this.getChildComponent() instanceof EditorComboBox) {
            EditorEx editor;
            ((EditorComboBox)this.getChildComponent()).setText(text);
            if (!keepCaret && StringUtil.isNotEmpty((String)text) && (editor = ((EditorComboBox)this.getChildComponent()).getEditorEx()) != null) {
                editor.getCaretModel().moveToOffset(text.length());
            }
        } else {
            Editor editor;
            ((EditorTextField)this.getChildComponent()).setText(text);
            if (!keepCaret && StringUtil.isNotEmpty((String)text) && (editor = ((EditorTextField)this.getChildComponent()).getEditor()) != null) {
                editor.getCaretModel().moveToOffset(text.length());
            }
        }
    }

    public void updateRecents() {
        if (this.myRecentsKey != null) {
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(this.myRecentsKey, this.getText());
        }
    }

    protected GlobalSearchScope getScope() {
        return this.myScope;
    }

    public static JSReferenceEditor forClassName(String text, @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope, @Nullable JavaScriptParserBase.ForceContext typeContext, @Nullable Condition<JSClass> classFilter, @NotNull String chooserTitle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "forClassName"));
        }
        if (chooserTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooserTitle", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "forClassName"));
        }
        return JSReferenceEditor.forClassName(text, project, recentsKey, scope, typeContext, classFilter, chooserTitle, null);
    }

    public static JSReferenceEditor forClassName(String text, final @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope, @Nullable JavaScriptParserBase.ForceContext typeContext, final @Nullable Condition<JSClass> classFilter, final @NotNull String chooserTitle, @Nullable PsiElement context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "forClassName"));
        }
        if (chooserTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooserTitle", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "forClassName"));
        }
        return new JSReferenceEditor(text, project, recentsKey, scope, typeContext, CompletionResultSink.createFilter(classFilter), chooserTitle, false, context){

            @Override
            protected ActionListener createActionListener() {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JSClass clazz;
                        if (DumbService.getInstance((Project)project).isDumb()) {
                            Messages.showWarningDialog((String)JSBundle.message((String)"class.chooser.not.available.in.dumb.mode", (Object[])new Object[0]), (String)chooserTitle);
                            return;
                        }
                        PsiElement initialClass = this.getText() != null ? JSDialectSpecificHandlersFactory.forLanguage(JavaScriptSupportLoader.ECMA_SCRIPT_L4).getClassResolver().findClassByQName(this.getText(), this.getScope()) : null;
                        JSClassChooserDialog chooser = new JSClassChooserDialog(project, chooserTitle, this.getScope(), initialClass instanceof JSClass ? (JSClass)initialClass : null, (Condition<JSClass>)classFilter);
                        if (chooser.showDialog() && (clazz = chooser.getSelectedClass()) != null) {
                            this.setText(clazz.getQualifiedName());
                        }
                    }
                };
            }
        };
    }

    public static JSReferenceEditor forPackageName(String text, final @NotNull Project project, @Nullable String recentsKey, GlobalSearchScope scope, final @NotNull String chooserTitle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "forPackageName"));
        }
        if (chooserTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chooserTitle", "com/intellij/lang/javascript/refactoring/ui/JSReferenceEditor", "forPackageName"));
        }
        return new JSReferenceEditor(text, project, recentsKey, scope, null, Conditions.alwaysTrue(), chooserTitle, true, null){

            @Override
            protected ActionListener createActionListener() {
                return new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JSPackageChooserDialog chooser = new JSPackageChooserDialog(chooserTitle, project, this.getScope());
                        chooser.selectPackage(this.getText());
                        chooser.show();
                        String aPackage = chooser.getSelectedPackage();
                        if (aPackage != null) {
                            this.setText(aPackage);
                        }
                    }
                };
            }
        };
    }

    private static class MyEditorComboBox
    extends EditorComboBox {
        private Computable<Integer> myHeightProvider;

        public MyEditorComboBox(Document document, Project project) {
            super(document, project, (FileType)JavaScriptSupportLoader.JAVASCRIPT);
        }

        public void setHeightProvider(Computable<Integer> heightProvider) {
            this.myHeightProvider = heightProvider;
        }

        public Dimension getPreferredSize() {
            Dimension result = new Dimension(super.getPreferredSize());
            if (this.myHeightProvider != null) {
                result.height = (Integer)this.myHeightProvider.compute();
            }
            return result;
        }

        protected ComboboxEditorTextField createEditorTextField(final Document document, final Project project, FileType fileType, boolean isViewer) {
            return new ComboboxEditorTextField(document, project, fileType, isViewer){

                protected EditorEx createEditor() {
                    EditorEx e = super.createEditor();
                    PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
                    e.setHighlighter(EditorHighlighterFactory.getInstance().createEditorHighlighter(project, file.getName()));
                    return e;
                }
            };
        }
    }
}

