/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.lang.javascript.service.JSLanguageService;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageServiceToolWindowInfoReporter
implements JSLanguageService.ServiceInfoReporter {
    private final Project myProject;
    @NotNull
    private final JSLanguageServiceToolWindowManager myManager;
    private final boolean myActive;

    public JSLanguageServiceToolWindowInfoReporter(Project project, @NotNull JSLanguageServiceToolWindowManager manager, boolean setActive) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter", "<init>"));
        }
        this.myProject = project;
        this.myManager = manager;
        this.myActive = setActive;
    }

    @Override
    public void logError(@NotNull String error) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/lang/javascript/service/JSLanguageServiceToolWindowInfoReporter", "logError"));
        }
        this.myManager.logCurrentErrors((List<JSLanguageServiceAnnotationResult>)JSLanguageServiceAnnotationResult.buildError(error), this.myActive);
    }

    @Override
    public void setProcess(@Nullable String text) {
        ApplicationManager.getApplication().invokeLater(() -> this.myManager.setProgressText(text), this.myProject.getDisposed());
    }
}

