/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

class FlowJSConfigurationPanel {
    private JPanel myPanel;
    private JCheckBox myEnableService;
    private TextFieldWithHistoryWithBrowseButton myFlowExecutableCombobox;
    private JCheckBox myFlowResolveCheckBox;

    public FlowJSConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel", "<init>"));
        }
        this.myEnableService = new JBCheckBox(JSBundle.message((String)"js.flow.enable.flow.service", (Object[])new Object[0]), false);
        this.myEnableService.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                FlowJSConfigurationPanel.this.updateEnabled(FlowJSConfigurationPanel.this.myEnableService.isSelected());
            }
        });
        this.myFlowExecutableCombobox = SwingHelper.createTextFieldWithHistoryWithBrowseButton((Project)project, (String)JSBundle.message((String)"js.flow.settings.executable", (Object[])new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor(), () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel", "lambda$new$0"));
            }
            return FlowJSSettingsManager.calcPossibleFlowExecutableFiles(project);
        });
        JBCheckBox checkBox = new JBCheckBox(JSBundle.message((String)"js.flow.enable.flow.resolve", (Object[])new Object[0]), false);
        checkBox.setToolTipText(JSBundle.message((String)"js.flow.enable.flow.resolve.description", (Object[])new Object[0]));
        this.myFlowResolveCheckBox = checkBox;
        this.myPanel = FormBuilder.createFormBuilder().setVerticalGap(10).addSeparator().addComponent((JComponent)this.myEnableService).addLabeledComponent("&Flow executable:", (JComponent)this.myFlowExecutableCombobox).addComponent((JComponent)this.myFlowResolveCheckBox).getPanel();
        this.myPanel.setVisible(false);
    }

    JPanel getPanel() {
        return this.myPanel;
    }

    public FlowJSSettings getFlowSettings() {
        return new FlowJSSettings.Builder().setEnabled(this.myEnableService.isSelected()).setFlowExecutablePath(this.myFlowExecutableCombobox.getText()).setFlowResolveEnable(this.myFlowResolveCheckBox.isSelected()).build();
    }

    public void setFlowSettings(@NotNull FlowJSSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/javascript/settings/FlowJSConfigurationPanel", "setFlowSettings"));
        }
        String path = settings.getFlowExecutablePath();
        this.myEnableService.setSelected(settings.isEnabled());
        this.myFlowExecutableCombobox.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)path));
        this.myFlowResolveCheckBox.setSelected(settings.getFlowResolveEnable());
        this.updateEnabled(settings.isEnabled());
    }

    private void updateEnabled(boolean enabled) {
        this.myFlowExecutableCombobox.setEnabled(enabled);
        this.myFlowResolveCheckBox.setEnabled(enabled);
    }
}

