/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.settings.FlowJSConfigurationPanel;
import com.intellij.lang.javascript.settings.JSLanguageVersionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRootConfigurationPanel {
    JPanel myMainPanel;
    JComboBox myJSLanguageVersion;
    private JEditorPane myDescription;
    private JBCheckBox myPreferStrict;
    private JBCheckBox myOnlyTypeBasedCompletion;
    @NotNull
    private FlowJSConfigurationPanel myFlowSettings;

    public JSRootConfigurationPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/JSRootConfigurationPanel", "<init>"));
        }
        JLabel versionLabel = new JLabel(JSBundle.message((String)"js.language.version.label", (Object[])new Object[0]));
        this.myJSLanguageVersion = new ComboBox((ComboBoxModel)new JSLanguageVersionModel());
        this.myJSLanguageVersion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ComboBoxModel model = ((JComboBox)e.getSource()).getModel();
                if (model instanceof JSLanguageVersionModel) {
                    JSLanguageVersionModel jsModel = (JSLanguageVersionModel)model;
                    JSLanguageLevel level = jsModel.getSelectedItem();
                    boolean isFlow = level == JSLanguageLevel.FLOW;
                    JSRootConfigurationPanel.this.myFlowSettings.getPanel().setVisible(isFlow);
                    JSRootConfigurationPanel.this.updateDescription(level);
                }
            }
        });
        versionLabel.setLabelFor(this.myJSLanguageVersion);
        this.myDescription = SwingHelper.createHtmlViewer((boolean)true, null, null, null);
        GridBagLayout layout = new GridBagLayout();
        JPanel languageVersionPanel = new JPanel(layout);
        GridBagConstraints c0 = new GridBagConstraints();
        c0.insets = JBUI.insetsRight((int)10);
        languageVersionPanel.add((Component)versionLabel, c0);
        GridBagConstraints c1 = new GridBagConstraints();
        c1.insets = JBUI.insetsRight((int)10);
        languageVersionPanel.add((Component)this.myJSLanguageVersion, c1);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.fill = 1;
        c2.weightx = 1.0;
        languageVersionPanel.add((Component)this.myDescription, c2);
        this.myPreferStrict = new JBCheckBox(JSBundle.message((String)"settings.javascript.prefer.strict", (Object[])new Object[0]));
        this.myOnlyTypeBasedCompletion = new JBCheckBox(JSBundle.message((String)"settings.javascript.only.type.based.completion", (Object[])new Object[0]));
        this.myOnlyTypeBasedCompletion.setToolTipText(JSBundle.message((String)"settings.javascript.only.type.based.completion.tooptip", (Object[])new Object[0]));
        this.myFlowSettings = new FlowJSConfigurationPanel(project);
        this.myMainPanel = FormBuilder.createFormBuilder().setVerticalGap(8).addComponent((JComponent)languageVersionPanel).addComponent((JComponent)this.myPreferStrict).addComponent((JComponent)this.myOnlyTypeBasedCompletion).addComponent((JComponent)this.myFlowSettings.getPanel()).addComponentFillVertically((JComponent)new JPanel(), 0).getPanel();
    }

    public JPanel getPanel() {
        return this.myMainPanel;
    }

    @NotNull
    public JSLanguageLevel getLanguageLevel() {
        JSLanguageLevel jSLanguageLevel = (JSLanguageLevel)((Object)this.myJSLanguageVersion.getModel().getSelectedItem());
        if (jSLanguageLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurationPanel", "getLanguageLevel"));
        }
        return jSLanguageLevel;
    }

    public void setLanguageLevel(JSLanguageLevel level) {
        this.myJSLanguageVersion.getModel().setSelectedItem((Object)level);
        this.updateDescription(level);
    }

    public void setPreferStrict(boolean preferStrict) {
        this.myPreferStrict.setSelected(preferStrict);
    }

    public boolean isPreferStrict() {
        return this.myPreferStrict.isSelected();
    }

    public void setOnlyTypeBasedCompletion(boolean selected) {
        this.myOnlyTypeBasedCompletion.setSelected(selected);
    }

    public boolean getOnlyTypeBasedCompletion() {
        return this.myOnlyTypeBasedCompletion.isSelected();
    }

    private void updateDescription(@Nullable JSLanguageLevel level) {
        if (level != null) {
            SwingHelper.setHtml((JEditorPane)this.myDescription, (String)level.getDescription(), null);
        }
    }

    @NotNull
    public FlowJSConfigurationPanel getFlowPanel() {
        FlowJSConfigurationPanel flowJSConfigurationPanel = this.myFlowSettings;
        if (flowJSConfigurationPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurationPanel", "getFlowPanel"));
        }
        return flowJSConfigurationPanel;
    }
}

