/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ui;

import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.JSVisibilityUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiFormatUtilBase;
import com.intellij.util.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFormatUtil
extends PsiFormatUtilBase {
    @NotNull
    public static String formatClass(@NotNull JSClass clazz, int options) {
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatClass"));
        }
        if (JSFormatUtil.testOption((int)options, (int)2048)) {
            String qualifiedName = clazz.getQualifiedName();
            String string = qualifiedName != null ? qualifiedName : JSBundle.message((String)"class.name.invalid", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatClass"));
            }
            return string;
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            String name = clazz.getName();
            String string = name != null ? name : JSBundle.message((String)"class.name.invalid", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatClass"));
            }
            return string;
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatClass"));
        }
        return "";
    }

    @NotNull
    public static String formatField(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatField"));
        }
        String string = JSFormatUtil.formatField(field, options, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatField"));
        }
        return string;
    }

    @NotNull
    public static String formatField(@NotNull JSTypeDeclarationOwner field, int options, @Nullable JSClass parentClassOverrride) {
        String returnType;
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatField"));
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)2) && !JSFormatUtil.testOption((int)options, (int)4) && (returnType = JSFormatUtil.getType(field, options)) != null) {
            text.append(returnType);
        }
        if (JSFormatUtil.testOption((int)options, (int)4096)) {
            String s;
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverrride != null ? parentClassOverrride : JSResolveUtil.getClassOfContext((PsiElement)field);
            if (clazz != null && (s = JSFormatUtil.formatClass(clazz, options)).length() > 0) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
                text.append(s).append('.');
            }
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            if (!JSFormatUtil.testOption((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            text.append(field.getName());
        }
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2, 4}) && (returnType = JSFormatUtil.getType(field, options)) != null) {
            text.append(':');
            text.append(returnType);
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatField"));
        }
        return string;
    }

    public static String formatMember(@NotNull JSPsiElementBase member, int options) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMember"));
        }
        if (member instanceof JSFunction) {
            return JSFormatUtil.formatMethod((JSFunction)member, options, 0);
        }
        if (member instanceof JSField) {
            return JSFormatUtil.formatField((JSTypeDeclarationOwner)((JSField)member), options);
        }
        return member.getName();
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMethod"));
        }
        String string = JSFormatUtil.formatMethod(method, options, parametersOptions, 7, null);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMethod"));
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions, @Nullable JSClass parentClassOverrride) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMethod"));
        }
        String string = JSFormatUtil.formatMethod(method, options, parametersOptions, 7, parentClassOverrride);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMethod"));
        }
        return string;
    }

    @NotNull
    public static String formatMethod(@NotNull JSFunction method, int options, int parametersOptions, int maxParameters, @Nullable JSClass parentClassOverrride) {
        String returnType;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMethod"));
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)2) && !JSFormatUtil.testOption((int)options, (int)4) && (returnType = JSFormatUtil.getReturnType(method, options)) != null) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(returnType);
        }
        if (JSFormatUtil.testOption((int)options, (int)4096)) {
            String s;
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverrride != null ? parentClassOverrride : JSResolveUtil.getClassOfContext((PsiElement)method);
            if (clazz != null && (s = JSFormatUtil.formatClass(clazz, options)).length() > 0) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
                text.append(s).append('.');
            }
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            String name;
            if (!JSFormatUtil.testOption((int)options, (int)4096)) {
                JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            }
            if ((name = method.getName()) == null) {
                name = "<anonymous>";
            }
            text.append(name);
        }
        if (JSFormatUtil.testOption((int)options, (int)256) && method.getKind() != JSFunction.FunctionKind.GETTER && method.getKind() != JSFunction.FunctionKind.SETTER) {
            text.append('(');
            if (method.getParameterList() != null) {
                boolean first = true;
                JSParameterListElement[] params = method.getParameters();
                for (int i = 0; i < Math.min(params.length, maxParameters); ++i) {
                    if (!first) {
                        text.append(", ");
                    }
                    first = false;
                    text.append(JSFormatUtil.formatParameter(params[i], parametersOptions));
                }
            }
            text.append(')');
        }
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2, 4}) && (returnType = JSFormatUtil.getReturnType(method, options)) != null) {
            text.append(':');
            text.append(returnType);
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatMethod"));
        }
        return string;
    }

    private static String formatParameter(JSParameterListElement parameter, int options) {
        if (JSFormatUtil.testOption((int)options, (int)2) && !parameter.getContainingFile().getLanguage().isKindOf((Language)JavaScriptSupportLoader.ECMA_SCRIPT_L4)) {
            options &= 0xFFFFFFFD;
            options |= 1;
        }
        StringBuilder text = new StringBuilder();
        if (JSFormatUtil.testOption((int)options, (int)2) && !JSFormatUtil.testOption((int)options, (int)4)) {
            if (parameter.isRest() && DialectDetector.isActionScript((PsiElement)parameter)) {
                text.append("Array");
            } else {
                text.append(JSFormatUtil.formatType(parameter.getType(), options, (PsiElement)parameter));
            }
        }
        if (JSFormatUtil.testOption((int)options, (int)1)) {
            JSFormatUtil.appendSpaceIfNeeded((StringBuilder)text);
            text.append(parameter.getName());
        }
        if (JSFormatUtil.testAll((int)options, (int[])new int[]{2, 4})) {
            text.append(':');
            if (parameter.isRest() && DialectDetector.isActionScript((PsiElement)parameter)) {
                text.append("Array");
            } else {
                text.append(JSFormatUtil.formatType(parameter.getType(), options, (PsiElement)parameter));
            }
        }
        return text.toString();
    }

    @Nullable
    private static String getReturnType(@NotNull JSFunction method, int options) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/ui/JSFormatUtil", "getReturnType"));
        }
        if (method.getKind() == JSFunction.FunctionKind.SETTER) {
            if (method.getParameterList() != null && method.getParameters().length > 0) {
                return JSFormatUtil.formatType(method.getParameters()[0].getType(), options, (PsiElement)method);
            }
            return null;
        }
        if (method.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
            return null;
        }
        JSType returnType = method.getReturnType();
        return JSFormatUtil.formatType(returnType, options, (PsiElement)method);
    }

    @Nullable
    private static String getType(@NotNull JSTypeDeclarationOwner field, int options) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/intellij/lang/javascript/ui/JSFormatUtil", "getType"));
        }
        return JSFormatUtil.formatType(field.getType(), options, (PsiElement)field);
    }

    @Nullable
    private static String formatType(@Nullable JSType type, int options, PsiElement context) {
        if (type != null) {
            String typeName = type.getTypeText();
            return JSFormatUtil.testOption((int)options, (int)8192) ? typeName : JSResolveUtil.getShortTypeName(typeName, true);
        }
        return "*";
    }

    @Nullable
    public static Icon getPropertyIcon(@NotNull JSFunction method, boolean getterAndSetterMerged) {
        boolean isStatic;
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/lang/javascript/ui/JSFormatUtil", "getPropertyIcon"));
        }
        boolean bl = isStatic = method.getAttributeList() != null && method.getAttributeList().hasModifier(JSAttributeList.ModifierType.STATIC);
        if (method.getKind() == JSFunction.FunctionKind.GETTER) {
            if (getterAndSetterMerged && JSUtils.getMemberContainingClass((PsiElement)method).findFunctionByNameAndKind(method.getName(), JSFunction.FunctionKind.SETTER) != null) {
                return isStatic ? AllIcons.Nodes.PropertyReadWriteStatic : AllIcons.Nodes.PropertyReadWrite;
            }
            return isStatic ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
        }
        if (method.getKind() == JSFunction.FunctionKind.SETTER) {
            return isStatic ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
        }
        return null;
    }

    public static String formatVisibility(JSAttributeList.AccessType accessType, @Nullable PsiElement context) {
        String s = JSVisibilityUtil.accessTypeToKeyword(accessType, context != null ? DialectDetector.dialectOfElement(context) : null);
        if (StringUtil.isEmpty((String)s)) {
            return "";
        }
        return JSBundle.message((String)("javascript.visibility." + s), (Object[])new Object[0]);
    }

    public static String formatVisibility(JSAttributeList.AccessType accessType) {
        return JSFormatUtil.formatVisibility(accessType, null);
    }

    public static String formatVisibility(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/javascript/ui/JSFormatUtil", "formatVisibility"));
        }
        return JSFormatUtil.formatVisibility(((JSAttributeListOwner)element).getAttributeList().getAccessType(), element);
    }

    public static String getFunctionLongDescription(JSFunction jsFunction, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride) {
        boolean isMethod;
        int options = 257;
        boolean bl = isMethod = JSUtils.getMemberContainingClass((PsiElement)jsFunction) != null;
        if (includeParent && isMethod) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatMethod(jsFunction, options, 2, parentClassOverride);
        if (htmlEmphasize) {
            name = StringUtil.htmlEmphasize((String)name);
        }
        if (isMethod) {
            if (jsFunction.getKind() == JSFunction.FunctionKind.GETTER || jsFunction.getKind() == JSFunction.FunctionKind.SETTER) {
                return JSBundle.message((String)"property.description", (Object[])new Object[]{name});
            }
            if (jsFunction.getKind() == JSFunction.FunctionKind.CONSTRUCTOR) {
                return JSBundle.message((String)"constructor.description", (Object[])new Object[]{name});
            }
            return JSBundle.message((String)"method.description", (Object[])new Object[]{name});
        }
        if (includeParent) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext((PsiElement)jsFunction);
            if (clazz != null) {
                String className = JSFormatUtil.formatClass(clazz, 1);
                if (htmlEmphasize) {
                    className = StringUtil.htmlEmphasize((String)className);
                }
                return JSBundle.message((String)"function.in.class.description", (Object[])new Object[]{name, className});
            }
        }
        if (JSResolveUtil.isFileLocalSymbol((PsiElement)jsFunction)) {
            return JSBundle.message((String)"inner.function.description", (Object[])new Object[]{name});
        }
        return JSBundle.message((String)"function.description", (Object[])new Object[]{name});
    }

    public static String getVariableLongDescription(JSVariable jsVariable, boolean includeParent, boolean htmlEmphasize, @Nullable JSClass parentClassOverride) {
        boolean isField;
        int options = 1;
        boolean bl = isField = JSUtils.getMemberContainingClass((PsiElement)jsVariable) != null;
        if (includeParent && isField) {
            options |= 0x1000;
        }
        String name = JSFormatUtil.formatField((JSTypeDeclarationOwner)jsVariable, options, parentClassOverride);
        if (htmlEmphasize) {
            name = StringUtil.htmlEmphasize((String)name);
        }
        if (isField) {
            return JSBundle.message((String)(jsVariable.isConst() ? "constant.description" : "field.description"), (Object[])new Object[]{name});
        }
        if (includeParent) {
            JSClass clazz;
            JSClass jSClass = clazz = parentClassOverride != null ? parentClassOverride : JSResolveUtil.getClassOfContext((PsiElement)jsVariable);
            if (clazz != null) {
                String className = JSFormatUtil.formatClass(clazz, 1);
                if (htmlEmphasize) {
                    className = StringUtil.htmlEmphasize((String)className);
                }
                return JSBundle.message((String)(jsVariable.isConst() ? "constant.in.class.description" : "variable.in.class.description"), (Object[])new Object[]{name, className});
            }
        }
        String key = jsVariable instanceof JSParameter ? "parameter.description" : (JSResolveUtil.isFileLocalSymbol((PsiElement)jsVariable) ? (jsVariable.isConst() ? "inner.constant.description" : "inner.variable.description") : (jsVariable.isConst() ? "constant.description" : "variable.description"));
        return JSBundle.message((String)key, (Object[])new Object[]{name});
    }

    public static String formatPackage(String packageName) {
        return packageName.length() > 0 ? JSBundle.message((String)"package.description", (Object[])new Object[]{packageName}) : JSBundle.message((String)"top.level.package", (Object[])new Object[0]);
    }

    public static PsiElement findInsertionPlaceStartingFrom(PsiElement anchor, boolean skipFirstWs, Function<PsiElement, Boolean> skipFilter) {
        block3: {
            PsiElement nextSibling;
            PsiElement anchorNextSibling;
            if (skipFirstWs && anchor instanceof PsiWhiteSpace && ((Boolean)skipFilter.fun((Object)(anchorNextSibling = anchor.getNextSibling()))).booleanValue()) {
                anchor = anchorNextSibling;
            }
            while (true) {
                if ((nextSibling = (anchorNextSibling = anchor.getNextSibling())) instanceof PsiWhiteSpace) {
                    nextSibling = nextSibling.getNextSibling();
                }
                if (!((Boolean)skipFilter.fun((Object)nextSibling)).booleanValue()) break;
                anchor = nextSibling;
            }
            if (anchorNextSibling == null) break block3;
            anchor = anchorNextSibling != nextSibling ? anchorNextSibling : nextSibling;
        }
        return anchor;
    }
}

