/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandler;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceEvents;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptLanguageServiceCompletionContributor;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import java.util.Arrays;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptGoToDeclarationHandler
implements GotoDeclarationHandler {
    @Nullable
    public PsiElement[] getGotoDeclarationTargets(@Nullable PsiElement sourceElement, int offset, Editor editor) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (sourceElement == null) {
            return null;
        }
        Project project = editor.getProject();
        PsiElement parent = sourceElement.getParent();
        if (parent instanceof JSReferenceExpression) {
            if (project == null || !TypeScriptLanguageServiceUtil.isServiceEnabled(editor.getProject())) {
                return null;
            }
            TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
            if (!service.checkCanUseService()) {
                return null;
            }
            ResolveResult[] results = ((JSReferenceExpression)parent).multiResolve(false);
            if (results.length == 0) {
                Future<TypeScriptResponseCommon.FileSpan[]> future = TypeScriptLanguageServiceEvents.getService(project).getDeclaration(sourceElement, editor.getDocument());
                if (future == null) {
                    return null;
                }
                TypeScriptResponseCommon.FileSpan[] spans = TypeScriptLanguageServiceUtil.awaitFuture(future, TypeScriptLanguageServiceCompletionContributor.TIMEOUT_MILLS, TypeScriptLanguageServiceCompletionContributor.TIMEOUT_QUOTA, null);
                if (spans == null) {
                    return null;
                }
                PsiManager psiManager = PsiManager.getInstance((Project)project);
                return (PsiElement[])Arrays.stream(spans).map(el -> {
                    String path = el.file;
                    VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
                    if (file == null) {
                        return null;
                    }
                    PsiFile psiFile = psiManager.findFile(file);
                    if (psiFile == null) {
                        return null;
                    }
                    Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
                    if (document == null) {
                        return null;
                    }
                    return TypeScriptGoToDeclarationHandler.getElement(psiFile, document, el);
                }).filter(el -> el != null).toArray(PsiElement[]::new);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getElement(@NotNull PsiFile psiFile, @NotNull Document document, @NotNull TypeScriptResponseCommon.FileSpan span) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getElement"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getElement"));
        }
        if (span == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "span", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getElement"));
        }
        TypeScriptResponseCommon.Location start = span.start;
        TypeScriptResponseCommon.Location end = span.end;
        TypeScriptLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getPsiElementInfo(psiFile, document, start, end);
        if (info == null) {
            return null;
        }
        PsiElement element = info.getElement();
        if (element != null) {
            return element;
        }
        TextRange range = info.getRange();
        if (range == null) {
            return null;
        }
        return TypeScriptGoToDeclarationHandler.getPsiElementByRange(psiFile, range);
    }

    @Nullable
    public static PsiElement getPsiElementByRange(@NotNull PsiFile psiFile, TextRange range) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/typescript/TypeScriptGoToDeclarationHandler", "getPsiElementByRange"));
        }
        int rangeStartOffset = range.getStartOffset();
        PsiElement startElement = psiFile.findElementAt(rangeStartOffset);
        if (startElement == null) {
            return null;
        }
        PsiElement lastCandidate = startElement;
        int rangeEndOffset = range.getEndOffset();
        for (PsiElement currentElement = startElement; currentElement != null && !(currentElement instanceof PsiFile) && currentElement.getTextRange().getStartOffset() == rangeStartOffset && currentElement.getTextRange().getEndOffset() <= rangeEndOffset; currentElement = currentElement.getParent()) {
            if (currentElement.getTextRange().getEndOffset() == rangeEndOffset) {
                return currentElement;
            }
            lastCandidate = currentElement;
        }
        return lastCandidate;
    }

    @Nullable
    public String getActionText(DataContext context) {
        return null;
    }
}

