/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFixSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TypeScriptLanguageServiceAnnotationProvider {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final int CANNOT_FIND_NAME_CODE = 2304;

    TypeScriptLanguageServiceAnnotationProvider() {
    }

    @NotNull
    public DataToCompile createCompileData(@NotNull PsiFile file, @NotNull Editor editor, Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotationProvider", "createCompileData"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotationProvider", "createCompileData"));
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        List changedConfigs = null;
        for (Document document : manager.getUnsavedDocuments()) {
            VirtualFile docFile = manager.getFile(document);
            if (docFile == null || !TypeScriptCompilerConfigUtil.isConfig(docFile, docFile.getFileType())) continue;
            if (changedConfigs == null) {
                changedConfigs = ContainerUtil.newSmartList();
            }
            changedConfigs.add(docFile);
        }
        Document document = editor.getDocument();
        TypeScriptCompileInfoBuilder.FileHighlightingInfo input = TypeScriptCompileInfoBuilder.createInfoWithUnSavedFiles(project, file.getVirtualFile(), document, document.getModificationStamp());
        DataToCompile result = new DataToCompile();
        result.project = project;
        result.info = input;
        result.changedConfigs = changedConfigs;
        DataToCompile dataToCompile = result;
        if (dataToCompile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotationProvider", "createCompileData"));
        }
        return dataToCompile;
    }

    @Nullable
    public Future<List<JSLanguageServiceAnnotationResult>> getFutureByData(DataToCompile data) {
        if (null == data) {
            return null;
        }
        TypeScriptCompileInfoBuilder.FileHighlightingInfo collectedInfo = data.info;
        if (null == collectedInfo) {
            return null;
        }
        Project project = data.project;
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(project);
        return service.updateFilesAndGetErrors(collectedInfo, true);
    }

    public void apply(@NotNull PsiFile file, @Nullable List<JSLanguageServiceAnnotationResult> annotationResult, @NotNull AnnotationHolder holder) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotationProvider", "apply"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotationProvider", "apply"));
        }
        if (annotationResult == null) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = file.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (document == null) {
            WolfTheProblemSolver.getInstance((Project)project).clearProblems(virtualFile);
            return;
        }
        ArrayList errorHighlightInfos = ContainerUtil.newArrayList();
        for (JSLanguageServiceAnnotationResult result : annotationResult) {
            if (StringUtil.isEmpty((String)result.getFileAbsoluteSystemDependPath()) || !FileUtil.pathsEqual((String)result.getFileAbsoluteSystemDependPath(), (String)virtualFile.getCanonicalPath())) continue;
            try {
                TypeScriptLanguageServiceUtil.PsiElementInfo info = TypeScriptLanguageServiceUtil.getElementInfo(file, document, result.getLine(), result.getColumn(), result.getEndLine(), result.getEndColumn());
                if (info == null) continue;
                PsiElement element = info.getElement();
                TextRange range = info.getRange();
                if (element == null && range == null) continue;
                String message = result.getErrorText();
                if ("error".equals(result.getCategory())) {
                    Annotation annotation = element != null ? holder.createErrorAnnotation(element, message) : holder.createErrorAnnotation(range, message);
                    int code = result.getErrorCode();
                    if (code != -1) {
                        int[] codes;
                        if (message != null && 2304 == code) {
                            annotation.setHighlightType(ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
                        }
                        if ((codes = TypeScriptCompilerService.getService(project).getErrorCodeFixes()).length > 0 && Arrays.stream(codes).anyMatch(el -> el == code)) {
                            TypeScriptLanguageServiceFixSet set = new TypeScriptLanguageServiceFixSet(project, file.getManager(), virtualFile, result);
                            for (TypeScriptLanguageServiceFix fix : set.getFixes()) {
                                annotation.registerFix((IntentionAction)fix);
                            }
                        }
                    }
                    errorHighlightInfos.add(HighlightInfo.fromAnnotation((Annotation)annotation));
                    continue;
                }
                if (element != null) {
                    holder.createWarningAnnotation(element, message);
                    continue;
                }
                holder.createWarningAnnotation(range, message);
            }
            catch (Exception e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
        List problems = errorHighlightInfos.stream().map(el -> new ProblemImpl(virtualFile, el, true)).collect(Collectors.toList());
        WolfTheProblemSolver.getInstance((Project)project).reportProblems(virtualFile, problems);
    }

    static class DataToCompile {
        public Project project;
        @Nullable
        public TypeScriptCompileInfoBuilder.FileHighlightingInfo info;
        @Nullable
        public Collection<VirtualFile> changedConfigs;

        DataToCompile() {
        }
    }
}

