/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.javascript.ecmascript6.TypeScriptAnnotatorCheckerProvider;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.validation.JSEmptyTypeChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.validation.TypeScriptFunctionSignatureChecker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceAnnotatorCheckerProvider
extends TypeScriptAnnotatorCheckerProvider {
    private final Project myProject;
    @Nullable
    private final TypeScriptCompilerSettings mySettings;
    private final NotNullLazyValue<TypeScriptCompilerService> myCompilerService;

    public TypeScriptLanguageServiceAnnotatorCheckerProvider(@NotNull Project project, @Nullable TypeScriptCompilerSettings settings) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "<init>"));
        }
        this.myCompilerService = new NotNullLazyValue<TypeScriptCompilerService>(){

            @NotNull
            protected TypeScriptCompilerService compute() {
                TypeScriptCompilerService typeScriptCompilerService = TypeScriptCompilerService.getService(TypeScriptLanguageServiceAnnotatorCheckerProvider.this.myProject);
                if (typeScriptCompilerService == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider$1", "compute"));
                }
                return typeScriptCompilerService;
            }
        };
        this.myProject = project;
        this.mySettings = settings;
    }

    @Override
    protected boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "isAvailable"));
        }
        if (this.mySettings == null) {
            return false;
        }
        if (!TypeScriptLanguageServiceUtil.isServiceEnabled(this.myProject)) {
            return false;
        }
        PsiFile file = context.getContainingFile();
        if (!(file instanceof JSFile)) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return false;
        }
        TypeScriptCompilerService service = (TypeScriptCompilerService)this.myCompilerService.getValue();
        if (!service.checkCanUseService()) {
            return false;
        }
        service.initialize();
        return this.mySettings.isCompilerEnabledAndNeedTrackChanges() || TypeScriptConfigService.Provider.hasConfigs(this.myProject);
    }

    @Override
    @NotNull
    public JSTypeChecker<Annotation> getTypeChecker(@NotNull JSProblemReporter<Annotation> reporter) {
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "getTypeChecker"));
        }
        JSEmptyTypeChecker jSEmptyTypeChecker = JSEmptyTypeChecker.getInstance();
        if (jSEmptyTypeChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "getTypeChecker"));
        }
        return jSEmptyTypeChecker;
    }

    @Override
    @NotNull
    public TypeScriptFunctionSignatureChecker getSignatureChecker(@NotNull JSTypeChecker<Annotation> typeChecker, @NotNull JSProblemReporter<Annotation> reporter) {
        if (typeChecker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeChecker", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "getSignatureChecker"));
        }
        if (reporter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reporter", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "getSignatureChecker"));
        }
        TypeScriptFunctionSignatureChecker typeScriptFunctionSignatureChecker = new TypeScriptFunctionSignatureChecker(typeChecker, reporter){

            @Override
            public void checkFunction(@NotNull JSCallExpression node, @NotNull PsiElement element) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider$2", "checkFunction"));
                }
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider$2", "checkFunction"));
                }
            }

            @Override
            protected void checkCallArgumentType(JSParameterItem p, JSExpression exp, JSCallExpression node, PsiElement resolveResult) {
            }

            @Override
            protected void checkCallParameters(@NotNull JSCallExpression node, @Nullable PsiElement element) {
                if (node == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider$2", "checkCallParameters"));
                }
            }
        };
        if (typeScriptFunctionSignatureChecker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/TypeScriptLanguageServiceAnnotatorCheckerProvider", "getSignatureChecker"));
        }
        return typeScriptFunctionSignatureChecker;
    }

    @Override
    protected boolean skipErrors() {
        return true;
    }
}

