/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;

public class TypeScriptServiceSharedHighlightingStateHolder {
    private final Map<PsiFile, CalcState> myHolder = ContainerUtil.createConcurrentWeakMap();

    public CalcState getState(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptServiceSharedHighlightingStateHolder", "getState"));
        }
        return this.myHolder.get(file);
    }

    public void saveState(@NotNull PsiFile file, CalcState state) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptServiceSharedHighlightingStateHolder", "saveState"));
        }
        if (state == null) {
            this.reset(file);
            return;
        }
        this.myHolder.put(file, state);
    }

    public void reset(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/TypeScriptServiceSharedHighlightingStateHolder", "reset"));
        }
        this.myHolder.remove(file);
    }

    public void reset() {
        this.myHolder.clear();
    }

    public static class CalcState {
        @NotNull
        public final Future<List<JSLanguageServiceAnnotationResult>> future;
        public final long stamp;

        public CalcState(@NotNull Future<List<JSLanguageServiceAnnotationResult>> future, long docTimeStamp) {
            if (future == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/lang/typescript/compiler/TypeScriptServiceSharedHighlightingStateHolder$CalcState", "<init>"));
            }
            this.future = future;
            this.stamp = docTimeStamp;
        }
    }
}

