/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.action;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceResultContainer;
import com.intellij.lang.javascript.service.JSLanguageServiceUpdateContext;
import com.intellij.lang.javascript.service.ui.JSLanguageServiceToolWindowManager;
import com.intellij.lang.typescript.compiler.TypeScriptCompileInfoBuilder;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.action.TypeScriptCompileAllAction;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class TypeScriptCompileActionBase
extends AnAction {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");

    public TypeScriptCompileActionBase(@Nullable String text, @Nullable String description, @Nullable Icon icon) {
        super(text, description, icon);
    }

    protected void logErrors(@NotNull JSLanguageServiceToolWindowManager manager, @NotNull Collection<JSLanguageServiceAnnotationResult> infos) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "logErrors"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "logErrors"));
        }
        manager.logProjectErrors((ImmutableList<JSLanguageServiceAnnotationResult>)ContainerUtil.immutableList((List)ContainerUtil.newArrayList(infos)), true);
    }

    protected boolean compileFile(@NotNull VirtualFile file, @NotNull ProgressIndicator indicator, @NotNull TypeScriptCompilerService service, @NotNull Collection<JSLanguageServiceAnnotationResult> infos, @NotNull Collection<String> processedFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (service == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "service", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (infos == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infos", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        if (processedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processedFiles", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "compileFile"));
        }
        indicator.checkCanceled();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Action Compile: do compile for " + file.getName());
        }
        this.cleanCompilerCache(indicator, service);
        indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile", (Object[])new Object[]{file.getName()}));
        try {
            Future<JSLanguageServiceResultContainer> compile = service.compileFileAndGetErrors(file);
            if (compile != null) {
                JSLanguageServiceResultContainer container = compile.get(60L, TimeUnit.SECONDS);
                infos.addAll((Collection<JSLanguageServiceAnnotationResult>)container.getCompiledResults());
                List<String> compiledFiles = container.getCompiledFiles();
                if (compiledFiles != null) {
                    for (String s : compiledFiles) {
                        if (StringUtil.isEmpty((String)s)) continue;
                        processedFiles.add(FileUtil.toSystemIndependentName((String)s));
                    }
                }
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.checkCanceled();
            return false;
        }
    }

    protected void cleanCompilerCache(@NotNull ProgressIndicator indicator, TypeScriptCompilerService service) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "cleanCompilerCache"));
        }
        indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.clean", (Object[])new Object[0]));
    }

    protected boolean compileConfig(ProgressIndicator indicator, TypeScriptCompilerService service, TypeScriptConfig config, Collection<JSLanguageServiceAnnotationResult> infos) {
        indicator.checkCanceled();
        if (TypeScriptCompileAllAction.LOGGER.isDebugEnabled()) {
            TypeScriptCompileAllAction.LOGGER.debug("Action Compile: do compile for " + config.getConfigFile().getName());
        }
        try {
            JSLanguageServiceResultContainer container;
            this.cleanCompilerCache(indicator, service);
            indicator.setText2(JSBundle.message((String)"typescript.compiler.action.compile.all.compile.config", (Object[])new Object[]{config.getConfigFile().getPath()}));
            Future<JSLanguageServiceResultContainer> compile = service.compileConfigProjectAndGetErrors(config);
            if (compile != null && (container = compile.get(60L, TimeUnit.SECONDS)) != null) {
                infos.addAll((Collection<JSLanguageServiceAnnotationResult>)container.getCompiledResults());
            }
            return true;
        }
        catch (Exception e) {
            TypeScriptCompileAllAction.LOGGER.info(e.getMessage(), (Throwable)e);
            indicator.cancel();
            return false;
        }
    }

    protected void logErrors(Collection<JSLanguageServiceAnnotationResult> infos, TypeScriptCompilerService compilerService) {
        JSLanguageServiceToolWindowManager manager = compilerService.getToolWindowManager();
        if (manager != null) {
            ApplicationManager.getApplication().invokeLater(() -> {
                manager.init();
                this.logErrors(manager, infos);
            });
        }
    }

    public final synchronized void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DataContext context = e.getDataContext();
        this.runCompile(project, context);
    }

    public void runCompile(@NotNull Project project, @Nullable DataContext context) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runCompile"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        FileDocumentManager.getInstance().saveAllDocuments();
        final Consumer<ProgressIndicator> background = this.getBackgroundProcess(project, context);
        if (background == null) {
            return;
        }
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, "Compiling TypeScript Files", true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase$1", "run"));
                }
                try {
                    indicator.checkCanceled();
                    background.consume((Object)indicator);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                finally {
                    TypeScriptCompileActionBase.this.release();
                }
            }
        });
    }

    protected void release() {
    }

    @Nullable
    protected abstract Consumer<ProgressIndicator> getBackgroundProcess(@Nullable Project var1, @Nullable DataContext var2);

    protected void updateServerFiles(ProgressIndicator indicator, Project project, TypeScriptCompilerService compilerService) {
        JSLanguageServiceUpdateContext context = (JSLanguageServiceUpdateContext)ReadAction.compute(() -> TypeScriptCompileInfoBuilder.createUpdateContext(project));
        indicator.checkCanceled();
        compilerService.update(context);
        indicator.checkCanceled();
    }

    protected void runBeforeStartingCompile(@NotNull ProgressIndicator indicator, Project project, TypeScriptCompilerService compilerService) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/typescript/compiler/action/TypeScriptCompileActionBase", "runBeforeStartingCompile"));
        }
        this.updateServerFiles(indicator, project, compilerService);
    }
}

