/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.codeFixes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.codeFixes.TypeScriptLanguageServiceFix;
import com.intellij.lang.typescript.compiler.languageService.ide.TypeScriptLanguageServiceCompletionContributor;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixes;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetCodeFixesRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptCodeActionInfo;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptGetCodeFixesResponse;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceFixSet {
    private static final int MAX_QUICK_FIXES = 5;
    @NotNull
    private final Project myProject;
    @NotNull
    private final PsiManager myPsiManager;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final JSLanguageServiceAnnotationResult myResult;
    @NotNull
    private final List<TypeScriptLanguageServiceFix> myFixes;
    private long myPsiModCount;

    @NotNull
    public List<TypeScriptLanguageServiceFix> getFixes() {
        List<TypeScriptLanguageServiceFix> list = this.myFixes;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "getFixes"));
        }
        return list;
    }

    public TypeScriptLanguageServiceFixSet(@NotNull Project project, @NotNull PsiManager psiManager, @NotNull VirtualFile file, @NotNull JSLanguageServiceAnnotationResult result) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet", "<init>"));
        }
        this.myProject = project;
        this.myPsiManager = psiManager;
        this.myFile = file;
        this.myResult = result;
        ArrayList fixes = ContainerUtil.newArrayListWithCapacity((int)5);
        for (int i = 0; i < 5; ++i) {
            fixes.add(new TypeScriptLanguageServiceFix(this::refresh, i));
        }
        this.myFixes = fixes;
    }

    private void refresh() {
        long modCount = this.myPsiManager.getModificationTracker().getModificationCount();
        if (this.myPsiModCount == modCount) {
            return;
        }
        this.myPsiModCount = modCount;
        TypeScriptCompilerService service = TypeScriptCompilerService.getService(this.myProject);
        if (!service.checkCanUseService()) {
            return;
        }
        TypeScriptGetCodeFixesRequestArgs args = new TypeScriptGetCodeFixesRequestArgs();
        args.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(this.myFile);
        args.startOffset = this.myResult.getColumn() + 1;
        args.startLine = this.myResult.getLine() + 1;
        args.endOffset = this.myResult.getEndColumn() + 1;
        args.endLine = this.myResult.getEndLine() + 1;
        args.errorCodes = new int[]{this.myResult.getErrorCode()};
        this.myFixes.forEach(el -> el.update(null));
        Future<TypeScriptGetCodeFixesResponse> future = service.sendCommand(new TypeScriptGetCodeFixes(args), new JSLanguageServiceCommandResultProcessor<TypeScriptGetCodeFixesResponse>(){

            @Override
            @Nullable
            public TypeScriptGetCodeFixesResponse process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet$1", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/codeFixes/TypeScriptLanguageServiceFixSet$1", "process"));
                }
                if (answer.isEmpty()) {
                    return null;
                }
                JsonObject element = answer.getElement();
                return (TypeScriptGetCodeFixesResponse)JSLanguageServiceImpl.GSON.fromJson((JsonElement)element, TypeScriptGetCodeFixesResponse.class);
            }
        });
        TypeScriptGetCodeFixesResponse response = TypeScriptLanguageServiceUtil.awaitFuture(future, TypeScriptLanguageServiceCompletionContributor.TIMEOUT_MILLS, TypeScriptLanguageServiceCompletionContributor.TIMEOUT_QUOTA, null);
        if (response == null || response.body == null) {
            return;
        }
        int index = 0;
        for (TypeScriptCodeActionInfo info : response.body) {
            TypeScriptLanguageServiceFix fix = this.myFixes.get(index++);
            fix.update(new TypeScriptLanguageServiceFix.State(info));
            if (index >= 5) break;
        }
    }
}

