/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol;

import com.intellij.lang.javascript.service.JSLanguageServiceAnnotationResult;
import com.intellij.lang.javascript.service.JSLanguageServiceDefaultCacheData;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceCommand;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceSimpleCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptLanguageServiceUpdateFilesCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptUpdateFilesContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptLanguageServiceCacheImpl
extends JSLanguageServiceDefaultCacheData {
    private final Project myProject;
    private final Map<String, Long> myUpdateTimeStamps = ContainerUtil.newConcurrentMap();
    private final Map<String, ResultToTimeStamp> myCompileResults = ContainerUtil.newConcurrentMap();
    private Set<String> myOpenedFiles = ContainerUtil.newConcurrentSet();
    private Set<String> myLastModifiedFiles = ContainerUtil.newConcurrentSet();

    public TypeScriptLanguageServiceCacheImpl(Project project) {
        this.myProject = project;
    }

    @Override
    public synchronized JSLanguageServiceObject updateCacheAndGetServiceObject(@NotNull JSLanguageServiceCommand input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl", "updateCacheAndGetServiceObject"));
        }
        if (input instanceof TypeScriptLanguageServiceUpdateFilesCommand) {
            return this.getUpdateFilesServiceObject((TypeScriptLanguageServiceUpdateFilesCommand)input);
        }
        if (input instanceof JSLanguageServiceSimpleCommand) {
            String file;
            if (input instanceof TypeScriptOpenEditorCommand) {
                file = ((TypeScriptFileWithConfigArgs)((TypeScriptOpenEditorCommand)input).arguments).file;
                this.myOpenedFiles.add(file);
            }
            if (input instanceof TypeScriptCloseEditorCommand) {
                file = ((TypeScriptFileObject)((TypeScriptCloseEditorCommand)input).arguments).file;
                this.myOpenedFiles.remove(file);
                this.myUpdateTimeStamps.remove(file);
                this.myLastModifiedFiles.add(file);
            }
            return ((JSLanguageServiceSimpleCommand)input).toSerializableObject();
        }
        return null;
    }

    private JSLanguageServiceObject getUpdateFilesServiceObject(@NotNull TypeScriptLanguageServiceUpdateFilesCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCacheImpl", "getUpdateFilesServiceObject"));
        }
        HashMap newToCompileChangedFiles = ContainerUtil.newHashMap();
        Map<String, Long> changedFiles = command.myChangedFilesToTimeStamp;
        Map<String, Document> unsavedContents = command.myUnsavedFilesContent;
        HashSet filesToReloadContentFromDisk = ContainerUtil.newHashSet();
        for (String string : this.myLastModifiedFiles) {
            if (changedFiles.containsKey(string) || this.myOpenedFiles.contains(string)) continue;
            filesToReloadContentFromDisk.add(string);
            this.myCompileResults.remove(string);
            this.myUpdateTimeStamps.remove(string);
        }
        this.myLastModifiedFiles.clear();
        this.myLastModifiedFiles.addAll(changedFiles.keySet());
        for (Map.Entry entry : changedFiles.entrySet()) {
            String path = (String)entry.getKey();
            Document content = unsavedContents.get(path);
            if (content == null) continue;
            if ((Long)entry.getValue() < 0L) {
                newToCompileChangedFiles.put(path, content.getText());
                this.myUpdateTimeStamps.remove(path);
                continue;
            }
            long fixedModifiedStamp = (Long)entry.getValue();
            Long timeStamp = this.myUpdateTimeStamps.get(path);
            if (timeStamp != null && fixedModifiedStamp == timeStamp) continue;
            newToCompileChangedFiles.put(path, content.getText());
            this.myUpdateTimeStamps.put(path, (Long)entry.getValue());
        }
        return newToCompileChangedFiles.isEmpty() && filesToReloadContentFromDisk.isEmpty() ? null : new TypeScriptUpdateFilesContent(newToCompileChangedFiles, filesToReloadContentFromDisk);
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @Override
    public void clear() {
        this.myUpdateTimeStamps.clear();
    }

    static class ResultToTimeStamp {
        public List<JSLanguageServiceAnnotationResult> result;
        public long timestamp;

        ResultToTimeStamp() {
        }
    }
}

