/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService.protocol.commands;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCommandWithArguments;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCompileFileArgs;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompileCommand
extends TypeScriptCommandWithArguments<TypeScriptCompileFileArgs> {
    public static final String COMMAND = "ideCompile";

    public TypeScriptCompileCommand(@NotNull TypeScriptCompileFileArgs args) {
        if (args == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "args", "com/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCompileCommand", "<init>"));
        }
        super(COMMAND, args);
    }

    @Override
    @Nullable
    public String getPresentableText(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptCompileCommand", "getPresentableText"));
        }
        String fileName = ((TypeScriptCompileFileArgs)this.arguments).file;
        if (!StringUtil.isEmpty((String)fileName)) {
            return JSBundle.message((String)"typescript.language.service.compile.file", (Object[])new Object[]{TypeScriptLanguageServiceUtil.getRelativePath(project, fileName)});
        }
        String relativePath = TypeScriptLanguageServiceUtil.getRelativePath(project, ((TypeScriptCompileFileArgs)this.arguments).tsConfig);
        return JSBundle.message((String)"typescript.language.service.compile.project", (Object[])new Object[]{StringUtil.notNullize((String)relativePath)});
    }
}

