/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.protocol;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.ProjectFileDirMacro;
import com.intellij.ide.macro.ProjectNameMacro;
import com.intellij.ide.macro.ProjectPathMacro;
import com.intellij.ide.macro.UnixSeparatorsMacro;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswerConsumer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceProtocol;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.File;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypeScriptServiceProtocolBase
implements JSLanguageServiceProtocol {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    public static final int OBJECT_LENGTH = 0x3200000;
    protected static final String ANSWER_READY = "ready";
    protected static final String ANSWER_ERROR = "error";
    protected static final Set<Macro> PROJECT_LEVEL_MACRO = ContainerUtil.newHashSet((Object[])new Macro[]{new UnixSeparatorsMacro(), new ProjectFileDirMacro(), new ProjectNameMacro(), new ProjectPathMacro()});
    public static final String OUT_PARAM = "-out";
    protected final long mySessionId = System.currentTimeMillis();
    protected final Project myProject;
    protected final TypeScriptCompilerSettings mySettings;
    @Nullable
    protected String myInitializeError;
    protected JSLanguageServiceAnswerConsumer myDefaultConsumer = new JSLanguageServiceAnswerConsumer(){

        @Override
        public void consume(JSLanguageServiceAnswer message) {
            if (message != null) {
                LOGGER.debug(message.toString());
            }
        }
    };

    public TypeScriptServiceProtocolBase(Project project, TypeScriptCompilerSettings settings) {
        this.myProject = project;
        this.mySettings = settings;
    }

    protected static void setSkipForTSConfig(GeneralCommandLine line) {
        line.addParameter("-skip=true");
    }

    @Override
    @Nullable
    public String getInitializeError() {
        return this.myInitializeError;
    }

    @NotNull
    protected String expandOutputDirectoryMacro() throws Macro.ExecutionCancelledException {
        String outWithExpandedProjectMacro = FileUtil.toSystemIndependentName((String)this.mySettings.getOutDirectory());
        DataContext context = SimpleDataContext.getProjectContext((Project)this.myProject);
        for (Macro macro : PROJECT_LEVEL_MACRO) {
            String macroName = "$" + macro.getName() + "$";
            if (!outWithExpandedProjectMacro.contains(macroName)) continue;
            String expand = macro.expand(context);
            if (expand == null) {
                expand = "";
            }
            outWithExpandedProjectMacro = StringUtil.replace((String)outWithExpandedProjectMacro, (String)macroName, (String)expand);
        }
        String string = outWithExpandedProjectMacro;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase", "expandOutputDirectoryMacro"));
        }
        return string;
    }

    protected String getSessionIdParam() {
        return "-id=" + this.mySessionId;
    }

    @Nullable
    protected GeneralCommandLine createCommandLine() throws Macro.ExecutionCancelledException {
        String interpreter = TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject);
        if (StringUtil.isEmptyOrSpaces((String)interpreter)) {
            this.myInitializeError = JSBundle.message((String)"typescript.service.node.error", (Object[])new Object[0]);
            throw new RuntimeException(this.myInitializeError);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine(new String[]{interpreter});
        File file = new File(this.getEntryPointFolder(), this.getEntryPointFile());
        if (!file.exists()) {
            throw new RuntimeException("Cannot find resource start point: " + file.getAbsolutePath());
        }
        commandLine.withWorkDirectory(this.myProject.getBasePath());
        commandLine.addParameter(file.getAbsolutePath());
        commandLine.addParameter(this.getSessionIdParam());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Commandline " + commandLine.toString());
        }
        return commandLine;
    }

    protected File getEntryPointFolder() {
        return TypeScriptUtil.getTypeScriptCompilerFolderFile();
    }

    @NotNull
    protected abstract String getEntryPointFile();

    protected boolean waitingReadyNotification(OSProcessHandler processHandler, ThrowableRunnable<Exception> action, final ReadyChecker checker) throws Exception {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Ref result = new Ref((Object)false);
        ProcessAdapter listener = new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                checker.check(event, outputType, (Ref<Boolean>)result, countDownLatch);
            }

            public void processTerminated(ProcessEvent event) {
                countDownLatch.countDown();
            }
        };
        processHandler.addProcessListener((ProcessListener)listener);
        action.run();
        try {
            LOGGER.debug("Start waiting for ready start");
            countDownLatch.await(30L, TimeUnit.SECONDS);
            LOGGER.debug("End waiting for process starting. Result " + result.get());
        }
        catch (InterruptedException e) {
            LOGGER.debug("Process interrupted while waiting ready state");
        }
        processHandler.removeProcessListener((ProcessListener)listener);
        return (Boolean)result.get();
    }

    protected void checkReadyCommand(ProcessEvent event, Key outputType, Ref<Boolean> result, CountDownLatch countDownLatch) {
        if (outputType == ProcessOutputTypes.STDOUT && !StringUtil.isEmpty((String)event.getText())) {
            String prefix;
            LOGGER.debug("Starting language service output: " + event.getText());
            String text = event.getText().trim();
            if (this.toSystemCommand(ANSWER_READY).equals(text)) {
                result.set((Object)true);
                countDownLatch.countDown();
            }
            if (text.startsWith(prefix = this.toSystemCommand(ANSWER_ERROR))) {
                LOGGER.debug("Error initialization " + text.substring(prefix.length()));
                this.myInitializeError = text.substring(prefix.length());
                countDownLatch.countDown();
            }
        } else if (outputType == ProcessOutputTypes.STDERR) {
            LOGGER.debug("Starting language service output error: " + event.getText());
        }
    }

    @Nullable
    protected OSProcessHandler createProcessHandler(GeneralCommandLine line) throws Exception {
        if (line == null) {
            LOGGER.debug("Cannot create command line for typescript compiler");
            return null;
        }
        OSProcessHandler processHandler = new OSProcessHandler(line){

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                final BaseOutputReader.Options options = BaseOutputReader.Options.BLOCKING;
                BaseOutputReader.Options options2 = new BaseOutputReader.Options(){

                    public BaseDataReader.SleepingPolicy policy() {
                        return options.policy();
                    }

                    public boolean splitToLines() {
                        return options.splitToLines();
                    }

                    public boolean sendIncompleteLines() {
                        return false;
                    }

                    public boolean withSeparators() {
                        return true;
                    }
                };
                if (options2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase$3", "readerOptions"));
                }
                return options2;
            }
        };
        try {
            if (!this.waitingReadyNotification(processHandler, (ThrowableRunnable<Exception>)((ThrowableRunnable)() -> ((OSProcessHandler)processHandler).startNotify()), this::checkReadyCommand)) {
                processHandler.destroyProcess();
                return null;
            }
        }
        catch (Exception e) {
            processHandler.destroyProcess();
            throw e;
        }
        return processHandler;
    }

    protected String getServicePath() {
        VirtualFile libDirectory;
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        if (settings.getVersionType() == TypeScriptCompilerSettings.TypeScriptCompilerVersionType.EMBEDDED_OR_DETECTED && (libDirectory = TypeScriptLanguageServiceUtil.findTypeScriptLibDirectory(this.myProject)) != null) {
            return TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(libDirectory.getCanonicalPath()) + '/';
        }
        return TypeScriptCompilerSettings.getOSDependTypeScriptServicesPathByDirectory(settings.getTypeScriptServiceDirectoryOrDefault()) + '/';
    }

    protected boolean hasMainFile() {
        return this.mySettings.isUseMainFile() && !StringUtil.isEmpty((String)this.mySettings.getMainFilePath());
    }

    protected boolean hasOutputDirectory() {
        return this.mySettings.isHasOutDirectory() && !StringUtil.isEmpty((String)this.mySettings.getOutDirectory());
    }

    @NotNull
    protected String toSystemCommand(String command) {
        String string = this.mySessionId + " " + command;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase", "toSystemCommand"));
        }
        return string;
    }

    @NotNull
    protected Pair<String, String> getOutInformation(boolean hasMainFile) throws Macro.ExecutionCancelledException {
        int indexOfSeparator;
        int indexOfDot;
        String outFile = null;
        String outWithExpandedProjectMacro = this.expandOutputDirectoryMacro();
        if (hasMainFile && (indexOfDot = outWithExpandedProjectMacro.lastIndexOf(46)) > 0 && indexOfDot > (indexOfSeparator = outWithExpandedProjectMacro.lastIndexOf(47))) {
            if (indexOfSeparator >= 0) {
                outFile = VfsUtil.extractFileName((String)outWithExpandedProjectMacro);
                outWithExpandedProjectMacro = VfsUtil.getParentDir((String)outWithExpandedProjectMacro);
            } else {
                outFile = outWithExpandedProjectMacro;
                outWithExpandedProjectMacro = null;
            }
        }
        if (!StringUtil.isEmpty((String)outWithExpandedProjectMacro)) {
            String path = FileUtil.toSystemDependentName((String)outWithExpandedProjectMacro);
            Pair pair = Pair.create(outFile, (Object)path);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase", "getOutInformation"));
            }
            return pair;
        }
        Pair pair = Pair.create(outFile, null);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase", "getOutInformation"));
        }
        return pair;
    }

    @NotNull
    protected String getProjectPathString() {
        String path = this.myProject.getBasePath();
        String string = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)path));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/protocol/TypeScriptServiceProtocolBase", "getProjectPathString"));
        }
        return string;
    }

    protected boolean checkExistsCommandLineOut(String[] parse) {
        for (String s : parse) {
            if (!OUT_PARAM.equals(s)) continue;
            return true;
        }
        return false;
    }

    protected static interface ReadyChecker {
        public void check(ProcessEvent var1, Key var2, Ref<Boolean> var3, CountDownLatch var4);
    }
}

