/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.structureView;

import com.intellij.lang.javascript.documentation.JSSymbolPresentationUtils;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSNamedElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCallSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptIndexSignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptPropertySignature;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.javascript.structureView.JSStructureItemPresentation;
import com.intellij.lang.javascript.structureView.JSStructureViewElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

class TypeScriptStructureItemPresentation
extends JSStructureItemPresentation {
    public TypeScriptStructureItemPresentation(JSStructureViewElement jsStructureViewElement) {
        super(jsStructureViewElement);
    }

    @Override
    protected String buildPresentationForElement(PsiElement psiElement) {
        StringBuilder presentation = null;
        if (psiElement instanceof TypeScriptCallSignature) {
            presentation = new StringBuilder();
            presentation.append(((TypeScriptCallSignature)psiElement).isConstructor() ? "new" : "");
            presentation.append(JSSymbolPresentationUtils.buildFunctionSignaturePresentation((JSFunctionItem)((JSFunction)psiElement)));
        } else if (psiElement instanceof TypeScriptPropertySignature) {
            presentation = new StringBuilder();
            presentation.append(JSPsiImplUtils.getNameOrComputedPropertyName((JSNamedElementBase)((TypeScriptPropertySignature)psiElement)));
            JSTypeDeclaration type = ((TypeScriptPropertySignature)psiElement).getTypeDeclaration();
            if (type != null && !(type instanceof TypeScriptObjectType)) {
                presentation.append(":");
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation(type));
            }
        } else if (psiElement instanceof TypeScriptIndexSignature) {
            TypeScriptType parameterType;
            presentation = new StringBuilder("[");
            TypeScriptIndexSignature indexSignature = (TypeScriptIndexSignature)psiElement;
            PsiElement nameElement = indexSignature.getParameterNameElement();
            if (nameElement != null) {
                presentation.append(nameElement.getText());
            }
            if ((parameterType = indexSignature.getParameterType()) != null) {
                presentation.append(":");
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation((JSTypeDeclaration)parameterType));
            }
            presentation.append("]");
            TypeScriptType type = indexSignature.getType();
            if (type != null) {
                presentation.append(":");
                presentation.append(TypeScriptStructureItemPresentation.getTypePresentation((JSTypeDeclaration)type));
            }
        } else if (psiElement instanceof TypeScriptClass) {
            String name = ((TypeScriptClass)psiElement).getName();
            if (name == null) {
                name = TypeScriptStructureItemPresentation.getAnonymousName(psiElement);
            }
            presentation = new StringBuilder(name);
            TypeScriptClass typeScriptClass = (TypeScriptClass)psiElement;
            TypeScriptTypeParameterList list = typeScriptClass.getTypeParameterList();
            if (list != null) {
                presentation.append("<");
                presentation.append(StringUtil.join((Object[])list.getTypeParameters(), parameter -> StringUtil.notNullize((String)parameter.getName()), (String)", "));
                presentation.append(">");
            }
        }
        return presentation != null ? presentation.toString() : super.buildPresentationForElement(psiElement);
    }

    @NotNull
    private static String getTypePresentation(JSTypeDeclaration type) {
        String string = TypeScriptTypeParser.buildTypeFromTypeScript(type).getTypeText(JSType.TypeTextFormat.PRESENTABLE);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/structureView/TypeScriptStructureItemPresentation", "getTypePresentation"));
        }
        return string;
    }
}

