/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.tsconfig;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.index.TypeScriptImportPathsResolver;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.typescript.TypeScriptSettings;
import com.intellij.lang.typescript.library.TypeScriptLibraryProvider;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigsChangedListener;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptConfigServiceImpl
implements TypeScriptConfigService {
    public static final Logger LOGGER = Logger.getInstance(TypeScriptConfigService.class);
    private static final Function<PsiFile, TypeScriptConfig> MAP_TO_CONFIG = file -> {
        if (JSLibraryUtil.isProbableLibraryFile(file.getVirtualFile())) {
            return null;
        }
        return TypeScriptConfigImpl.getConfig(file);
    };
    @NotNull
    private final Project myProject;
    @NotNull
    private final CachedValue<Collection<TypeScriptConfig>> myConfigs;
    private final CachedValue<ConcurrentMap<VirtualFile, Map<VirtualFile, Boolean>>> myFilesMappings;
    private final CachedValue<ConcurrentMap<VirtualFile, Collection<TypeScriptConfig>>> myFileConfigsInclude;
    private final SimpleModificationTracker myTracker;
    @Nullable
    private final TypeScriptConfigLibraryUpdater myUpdater;
    @NotNull
    private final TypeScriptImportPathsResolver myImportPathsResolver;
    private final Collection<TypeScriptConfigsChangedListener> myListeners;

    public TypeScriptConfigServiceImpl(@NotNull Project project, @Nullable TypeScriptConfigLibraryUpdater updater, @NotNull TypeScriptImportPathsResolver importPathsResolver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "<init>"));
        }
        if (importPathsResolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importPathsResolver", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "<init>"));
        }
        this.myTracker = new SimpleModificationTracker();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myProject = project;
        this.myUpdater = updater;
        this.myImportPathsResolver = importPathsResolver;
        CachedValueProvider configsProvider = () -> {
            AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
            this.beforeUpdate();
            List configs = null;
            try {
                Object[] files = FilenameIndex.getFilesByName((Project)this.myProject, (String)"tsconfig.json", (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.myProject));
                configs = ContainerUtil.mapNotNull((Object[])files, MAP_TO_CONFIG);
                ArrayList depends = ContainerUtil.newArrayList((Object[])files);
                depends.add(JSProjectUtil.FILE_SYSTEM_STRUCTURE_MODIFICATION_TRACKER);
                CachedValueProvider.Result result = CachedValueProvider.Result.create((Object)configs, (Collection)depends);
                this.afterUpdate(configs);
                CachedValueProvider.Result result2 = result;
                return result2;
            }
            finally {
                token.finish();
            }
        };
        this.myConfigs = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(configsProvider, false);
        this.myFilesMappings = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
        this.myFileConfigsInclude = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> CachedValueProvider.Result.create((Object)ContainerUtil.newConcurrentMap(), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()}), false);
    }

    private void beforeUpdate() {
        this.myTracker.incModificationCount();
        if (this.myUpdater != null) {
            this.myUpdater.queueToUpdate();
        }
    }

    public boolean isEnabled() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        TypeScriptSettings settings = TypeScriptSettings.getSettings(this.myProject);
        if (settings == null) {
            return false;
        }
        return settings.isEnabledConfig();
    }

    @Override
    public boolean isAccessible(VirtualFile scope, VirtualFile referenced) {
        Boolean value;
        Map prevValue;
        if (scope.equals(referenced)) {
            return true;
        }
        if (!this.isEnabled() || DumbService.isDumb((Project)this.myProject)) {
            return true;
        }
        ConcurrentMap filesRefsMap = (ConcurrentMap)this.myFilesMappings.getValue();
        Map scopeFileMap = (Map)filesRefsMap.get(scope);
        if (scopeFileMap == null && (prevValue = filesRefsMap.putIfAbsent(scope, scopeFileMap = ContainerUtil.newConcurrentMap())) != null) {
            scopeFileMap = prevValue;
        }
        if ((value = (Boolean)scopeFileMap.get(referenced)) == null) {
            value = this.isAccessibleImpl(scope, referenced);
            scopeFileMap.put(referenced, value);
        }
        return value;
    }

    private boolean isAccessibleImpl(@NotNull VirtualFile scope, @NotNull VirtualFile file) {
        boolean isStandardLib;
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isAccessibleImpl"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isAccessibleImpl"));
        }
        String fileName = file.getName();
        boolean bl = isStandardLib = TypeScriptLibraryProvider.LIBS_D_TS.contains(fileName) || TypeScriptLibraryProvider.LIBS_EXTENDED.contains(fileName);
        if (isStandardLib && TypeScriptLibraryProvider.getAllPredefinedLibraryFiles().contains(file)) {
            return true;
        }
        Collection<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            return true;
        }
        boolean firstInclude = false;
        boolean bothIncludes = false;
        Collection<TypeScriptConfig> includesFirst = this.getConfigInclude(scope);
        for (TypeScriptConfig config : includesFirst) {
            firstInclude = true;
            if (!config.accept(file)) continue;
            bothIncludes = true;
            break;
        }
        if (bothIncludes) {
            return true;
        }
        if (TypeScriptUtil.isUnderNodeModules(file, this.myProject)) {
            if (!isStandardLib && !TypeScriptLibraryProvider.FILES_FROM_TYPESCRIPT.contains(fileName) && TypeScriptUtil.isDefinitionFile(fileName)) {
                PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (psiFile instanceof JSFile && ((JSFile)psiFile).isCommonJSModule()) {
                    return true;
                }
                if (!firstInclude && !TypeScriptUtil.isUnderNodeModules(scope, this.myProject)) {
                    return true;
                }
            }
        } else if (!firstInclude) {
            return true;
        }
        return this.checkReferencePaths(file, includesFirst);
    }

    private boolean checkReferencePaths(@NotNull VirtualFile startFile, @Nullable Collection<TypeScriptConfig> configs) {
        if (startFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkReferencePaths"));
        }
        if (!startFile.isValid()) {
            return false;
        }
        if (configs == null) {
            return false;
        }
        ConcurrentMap precalculatedIncludes = (ConcurrentMap)this.myFileConfigsInclude.getValue();
        HashSet visited = ContainerUtil.newHashSet();
        ArrayDeque<VirtualFile> toCheck = new ArrayDeque<VirtualFile>();
        toCheck.add(startFile);
        visited.add(startFile);
        while (!toCheck.isEmpty()) {
            ProgressIndicatorProvider.checkCanceled();
            VirtualFile fileToCheck = (VirtualFile)toCheck.pop();
            VirtualFile[] files = this.myImportPathsResolver.getIncludingFiles(fileToCheck);
            if (files == null || files.length == 0 || !TypeScriptConfigServiceImpl.checkPlainIncludeFilesAndFillToCheck(configs, files, visited, toCheck, precalculatedIncludes)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPlainIncludeFilesAndFillToCheck(@NotNull Collection<TypeScriptConfig> configs, @NotNull VirtualFile[] files, Set<VirtualFile> visited, Deque<VirtualFile> toCheck, @NotNull ConcurrentMap<VirtualFile, Collection<TypeScriptConfig>> fileConfigsIncludeCache) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkPlainIncludeFilesAndFillToCheck"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkPlainIncludeFilesAndFillToCheck"));
        }
        if (fileConfigsIncludeCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileConfigsIncludeCache", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "checkPlainIncludeFilesAndFillToCheck"));
        }
        for (VirtualFile virtualFile : files) {
            if (fileConfigsIncludeCache.containsKey(virtualFile)) {
                Collection calculated = (Collection)fileConfigsIncludeCache.get(virtualFile);
                if (!ContainerUtil.intersects(configs, (Collection)calculated)) continue;
                return true;
            }
            for (TypeScriptConfig config : configs) {
                if (!config.accept(virtualFile)) continue;
                return true;
            }
            if (!visited.add(virtualFile)) continue;
            toCheck.add(virtualFile);
        }
        return false;
    }

    private Collection<TypeScriptConfig> getConfigIncludeImpl(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigIncludeImpl"));
        }
        Collection<TypeScriptConfig> files = this.getConfigFiles();
        if (files.isEmpty()) {
            return ContainerUtil.emptyList();
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (TypeScriptConfig config : files) {
            if (!this.isConfigInclude(scopeFile, config)) continue;
            result.add(config);
        }
        return result;
    }

    @Override
    @NotNull
    public Collection<TypeScriptConfig> getConfigInclude(@NotNull VirtualFile scopeFile) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
        }
        ConcurrentMap fileConfigsIncludeCache = (ConcurrentMap)this.myFileConfigsInclude.getValue();
        if (fileConfigsIncludeCache.containsKey(scopeFile)) {
            Collection collection = (Collection)fileConfigsIncludeCache.get(scopeFile);
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
            }
            return collection;
        }
        Collection<TypeScriptConfig> includedConfigs = this.getConfigIncludeImpl(scopeFile);
        fileConfigsIncludeCache.put(scopeFile, includedConfigs);
        Collection<TypeScriptConfig> collection = includedConfigs;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigInclude"));
        }
        return collection;
    }

    @Override
    public boolean isConfigInclude(@NotNull VirtualFile scopeFile, @NotNull TypeScriptConfig config) {
        if (scopeFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeFile", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isConfigInclude"));
        }
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "isConfigInclude"));
        }
        return config.accept(scopeFile) || this.checkReferencePaths(scopeFile, ContainerUtil.createMaybeSingletonList((Object)config));
    }

    @Override
    public void addChangeListener(@NotNull TypeScriptConfigsChangedListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "addChangeListener"));
        }
        this.myListeners.add(listener);
    }

    @Override
    public boolean hasConfigs() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection configs = (Collection)this.myConfigs.getValue();
        return !configs.isEmpty();
    }

    @Override
    @Nullable
    public TypeScriptConfig getConfig(@NotNull VirtualFile file) {
        PsiFile psiFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfig"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (this.myConfigs.hasUpToDateValue()) {
            for (TypeScriptConfig config : (Collection)this.myConfigs.getValue()) {
                if (!file.equals(config.getConfigFile())) continue;
                return config;
            }
        }
        if ((psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file)) != null) {
            return TypeScriptConfigImpl.getConfig(psiFile);
        }
        return null;
    }

    private void afterUpdate(@NotNull Collection<TypeScriptConfig> configs) {
        if (configs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configs", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "afterUpdate"));
        }
        for (TypeScriptConfigsChangedListener listener : this.myListeners) {
            listener.afterUpdate(configs);
        }
    }

    @Override
    @NotNull
    public ModificationTracker getTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myTracker;
        if (simpleModificationTracker == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getTracker"));
        }
        return simpleModificationTracker;
    }

    @Override
    @NotNull
    public Collection<TypeScriptConfig> getConfigFiles() {
        Collection value = (Collection)this.myConfigs.getValue();
        Collection collection = value == null ? ContainerUtil.emptyList() : value;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/tsconfig/TypeScriptConfigServiceImpl", "getConfigFiles"));
        }
        return collection;
    }
}

