/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cloudConfig;

import com.intellij.cloudConfig.CloudConfigManager;
import com.intellij.cloudConfig.StatusInfo;
import com.intellij.ide.license.impl.JetprofileSource;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerColumnInfo;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.PluginTable;
import com.intellij.ide.plugins.PluginTableModel;
import com.intellij.ide.plugins.PluginsTableRenderer;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.GridBag;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusInfoDialog
extends DialogWrapper {
    private final StatusInfo myStatus;
    private Action myDisableAction;
    private Action myDisconnectAction;
    private JRadioButton myUseShared;
    private PluginModel myPluginModel;
    private final JCheckBox myAutoUpdatePlugins;

    public StatusInfoDialog(@Nullable Project project, @NotNull StatusInfo status) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/cloudConfig/StatusInfoDialog", "<init>"));
        }
        super(project);
        this.myAutoUpdatePlugins = new JCheckBox("Automatically update of plugins");
        if (status != StatusInfo.JBA_CONNECTED) {
            this.myDisableAction = new AbstractAction("Don't Show"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    StatusInfoDialog.this.close(1);
                    CloudConfigManager.getInstance().disable();
                }
            };
        }
        this.myStatus = status;
        this.setTitle("JBA Cloud Config");
        this.setResizable(false);
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBag bag = new GridBag().setDefaultFill(2);
        if (this.myStatus == StatusInfo.JBA_CONNECTED) {
            panel.add((Component)new JLabel("<html><body>Your <b>" + JetprofileSource.getSharedLogin() + "</b> JetBrains account<br/>used for shared <i>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</i> config (<b>Laf</b>, <b>Keymap</b> and <b>Color Schemes</b>)</html></body>"), bag.nextLine().next().coverLine());
            if (CloudConfigManager.getInstance().isAutoUpdatePlugins()) {
                this.myAutoUpdatePlugins.setSelected(true);
                this.addAutoUpdateAction(panel, bag);
            } else {
                PluginModel pluginModel = new PluginModel();
                if (pluginModel.getRowCount() > 0) {
                    this.addAutoUpdateAction(panel, bag);
                    PluginTable table = new PluginTable((PluginTableModel)pluginModel);
                    JScrollPane pane = ScrollPaneFactory.createScrollPane((Component)table);
                    pane.setPreferredSize(new Dimension(-1, 200));
                    panel.add((Component)pane, bag.nextLine().next().fillCell().insetBottom(10).coverLine());
                    this.myAutoUpdatePlugins.addActionListener(e -> table.setEnabled(!this.myAutoUpdatePlugins.isSelected()));
                    this.myPluginModel = pluginModel;
                } else {
                    this.addAutoUpdateAction(panel, bag);
                }
            }
            this.myDisconnectAction = new AbstractAction("Disconnect"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Messages.showYesNoDialog((String)"Disconnect this instance?", (String)"JBA Cloud Config", (String)"Yes", (String)"No", null, (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption(){

                        public boolean isToBeShown() {
                            return true;
                        }

                        public void setToBeShown(boolean toBeShown, int exitCode) {
                            if (exitCode == 0) {
                                StatusInfoDialog.this.close(1);
                                CloudConfigManager.getInstance().disconnect(!toBeShown, true);
                            }
                        }

                        public boolean canBeHidden() {
                            return true;
                        }

                        public boolean shouldSaveOptionsOnCancel() {
                            return false;
                        }

                        @NotNull
                        public String getDoNotShowMessage() {
                            if ("Remove data from cloud" == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog$2$1", "getDoNotShowMessage"));
                            }
                            return "Remove data from cloud";
                        }
                    });
                }
            };
            this.setOKButtonText("Done");
        } else if (this.myStatus == StatusInfo.JBA_NOT_CONNECTED) {
            panel.add((Component)new JLabel("<html><body>Share <i>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</i> config (<b>Laf</b>, <b>Keymap</b> and <b>Color Schemes</b>)<br/>to your <b>" + JetprofileSource.getSharedLogin() + "</b> JetBrains account?</body></html>"), bag.nextLine().next().coverLine());
            this.addAutoUpdateAction(panel, bag);
        } else {
            assert (this.myStatus == StatusInfo.JBA_THIS_NOT_CONNECTED);
            panel.add((Component)new JLabel("<html><body>Your <b>" + JetprofileSource.getSharedLogin() + "</b> JetBrains account<br/>contains <i>" + ApplicationNamesInfo.getInstance().getFullProductName() + "</i> config (<b>Laf</b>, <b>Keymap</b> and <b>Color Schemes</b>)<br/>Would your like:</html></body>"), bag.nextLine().next().coverLine());
            this.myUseShared = new JRadioButton("Replace local config and use shared");
            JRadioButton useLocal = new JRadioButton("Use local config and shared it");
            panel.add((Component)this.myUseShared, bag.nextLine().next().coverLine());
            panel.add((Component)useLocal, bag.nextLine().next().coverLine());
            ButtonGroup group = new ButtonGroup();
            group.add(this.myUseShared);
            group.add(useLocal);
            this.myUseShared.setSelected(true);
            this.addAutoUpdateAction(panel, bag);
        }
        panel.add((Component)new JLabel(), bag.nextLine().next().fillCellVertically().weighty(1.0).coverLine());
        return panel;
    }

    private void addAutoUpdateAction(JPanel panel, GridBag bag) {
        panel.add((Component)this.myAutoUpdatePlugins, bag.nextLine().next().insets(10, -1, 10, -1).coverLine());
    }

    @NotNull
    protected Action[] createLeftSideActions() {
        Action[] actionArray;
        if (this.myDisconnectAction == null) {
            actionArray = super.createLeftSideActions();
        } else {
            Action[] actionArray2 = new Action[1];
            actionArray = actionArray2;
            actionArray2[0] = this.myDisconnectAction;
        }
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createLeftSideActions"));
        }
        return actionArray;
    }

    @NotNull
    protected Action[] createActions() {
        if (this.myStatus == StatusInfo.JBA_CONNECTED) {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
            }
            return actionArray;
        }
        if (this.myDisableAction != null) {
            if (SystemInfo.isMac) {
                Action[] actionArray = new Action[]{this.myDisableAction, this.getCancelAction(), this.getOKAction()};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
                }
                return actionArray;
            }
            Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.myDisableAction};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
            }
            return actionArray;
        }
        Action[] actionArray = super.createActions();
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cloudConfig/StatusInfoDialog", "createActions"));
        }
        return actionArray;
    }

    public void showAndHandleResult() {
        if (!this.showAndGet()) {
            return;
        }
        CloudConfigManager manager = CloudConfigManager.getInstance();
        manager.setAutoUpdatePlugins(this.myAutoUpdatePlugins.isSelected());
        if (this.myStatus == StatusInfo.JBA_NOT_CONNECTED) {
            manager.connectFirstInstance(false);
        } else if (this.myStatus == StatusInfo.JBA_THIS_NOT_CONNECTED) {
            if (this.myUseShared.isSelected()) {
                manager.connectThisInstance(true);
            } else {
                manager.connectFirstInstance(true);
            }
        }
    }

    public void doCancelAction() {
        super.doCancelAction();
        this.executePlugins();
    }

    protected void doOKAction() {
        super.doOKAction();
        this.executePlugins();
    }

    private void executePlugins() {
        if (this.myPluginModel == null) {
            return;
        }
        CloudConfigManager manager = CloudConfigManager.getInstance();
        if (!manager.isAutoUpdatePlugins() && this.myAutoUpdatePlugins.isSelected()) {
            manager.executePlugins();
            return;
        }
        if (this.myPluginModel.myExecuteList.isEmpty()) {
            return;
        }
        ArrayList<IdeaPluginDescriptor> installList = new ArrayList<IdeaPluginDescriptor>();
        for (IdeaPluginDescriptor descriptor : this.myPluginModel.myExecuteList) {
            PluginState state = this.myPluginModel.myStateMap.get(descriptor);
            if (state == PluginState.Disable) {
                CloudConfigManager.disablePlugin(descriptor);
                continue;
            }
            if (state == PluginState.Delete) {
                CloudConfigManager.deletePlugin(descriptor);
                continue;
            }
            installList.add(descriptor);
        }
        if (installList.isEmpty()) {
            PluginManagerConfigurable.shutdownOrRestartApp();
        } else {
            manager.installPlugins(installList);
        }
    }

    private static class PluginModel
    extends PluginTableModel {
        final Map<IdeaPluginDescriptor, PluginState> myStateMap = new HashMap<IdeaPluginDescriptor, PluginState>();
        final Set<IdeaPluginDescriptor> myExecuteList = new HashSet<IdeaPluginDescriptor>();

        public PluginModel() {
            this.columns = new ColumnInfo[]{new PluginManagerColumnInfo(0, this){

                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return descriptor == null ? null : new PluginsTableRenderer(descriptor, false);
                }
            }, new ColumnInfo<IdeaPluginDescriptor, String>(""){

                @Nullable
                public String valueOf(IdeaPluginDescriptor descriptor) {
                    return myStateMap.get(descriptor).name();
                }

                @Nullable
                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return new DefaultTableCellRenderer(){

                        @Override
                        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                        }
                    };
                }
            }, new ColumnInfo<IdeaPluginDescriptor, Boolean>(""){

                @Nullable
                public Boolean valueOf(IdeaPluginDescriptor descriptor) {
                    return myExecuteList.contains(descriptor);
                }

                public Class<?> getColumnClass() {
                    return Boolean.class;
                }

                @Nullable
                public TableCellRenderer getRenderer(IdeaPluginDescriptor descriptor) {
                    return new BooleanTableCellRenderer();
                }

                public boolean isCellEditable(IdeaPluginDescriptor descriptor) {
                    return true;
                }

                @Nullable
                public TableCellEditor getEditor(IdeaPluginDescriptor descriptor) {
                    return new BooleanTableCellEditor();
                }

                public void setValue(IdeaPluginDescriptor descriptor, Boolean value) {
                    if (value.booleanValue()) {
                        myExecuteList.add(descriptor);
                    } else {
                        myExecuteList.remove(descriptor);
                    }
                }
            }};
            CloudConfigManager manager = CloudConfigManager.getInstance();
            this.addItems(manager.getNotInstalledPlugins(), PluginState.Install);
            this.addItems(manager.getNotDeletedPlugins(), PluginState.Delete);
            this.addItems(manager.getNotDisabledPlugins(), PluginState.Disable);
        }

        private void addItems(@NotNull List<IdeaPluginDescriptor> descriptors, @NotNull PluginState state) {
            if (descriptors == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/cloudConfig/StatusInfoDialog$PluginModel", "addItems"));
            }
            if (state == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/cloudConfig/StatusInfoDialog$PluginModel", "addItems"));
            }
            this.view.addAll(descriptors);
            this.myStateMap.putAll(ContainerUtil.map2Map(descriptors, descriptor -> {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/cloudConfig/StatusInfoDialog$PluginModel", "lambda$addItems$0"));
                }
                return Pair.create((Object)descriptor, (Object)((Object)state));
            }));
        }

        public void updatePluginsList(List<IdeaPluginDescriptor> list) {
        }

        public int getNameColumn() {
            return 0;
        }

        public boolean isPluginDescriptorAccepted(IdeaPluginDescriptor descriptor) {
            return true;
        }

        public boolean isSortable() {
            return false;
        }
    }

    static enum PluginState {
        Install,
        Delete,
        Disable;

    }
}

