/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.util;

import com.intellij.lang.aspectj.AspectJFileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileIndexUtil {
    private FileIndexUtil() {
    }

    public static boolean isAspectJSourceFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/lang/aspectj/util/FileIndexUtil", "isAspectJSourceFile"));
        }
        return FileIndexUtil.isAspectJSourceFile(psiFile.getVirtualFile(), psiFile.getProject());
    }

    public static boolean isAspectJSourceFile(@Nullable VirtualFile vFile, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/util/FileIndexUtil", "isAspectJSourceFile"));
        }
        if (vFile == null || vFile.getFileType() != AspectJFileType.INSTANCE) {
            return false;
        }
        if (FileTypeManager.getInstance().isFileIgnored(vFile)) {
            return false;
        }
        return ProjectRootManager.getInstance((Project)project).getFileIndex().isInSource(vFile);
    }
}

