/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.psi.PsiClass;
import com.intellij.spring.model.SpringImplicitBeanMarker;
import com.intellij.spring.model.jam.stereotype.CustomSpringComponent;
import org.jetbrains.annotations.NotNull;

public class SpringImplicitBean
extends CustomSpringComponent
implements SpringImplicitBeanMarker {
    @NotNull
    private final String myBeanName;
    @NotNull
    private final String myProviderName;

    public SpringImplicitBean(@NotNull String providerName, @NotNull PsiClass psiClass, @NotNull String beanName) {
        if (providerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providerName", "com/intellij/spring/model/SpringImplicitBean", "<init>"));
        }
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/model/SpringImplicitBean", "<init>"));
        }
        if (beanName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beanName", "com/intellij/spring/model/SpringImplicitBean", "<init>"));
        }
        super(psiClass);
        this.myProviderName = providerName;
        this.myBeanName = beanName;
    }

    @Override
    @NotNull
    public String getBeanName() {
        String string = this.myBeanName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBean", "getBeanName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getProviderName() {
        String string = this.myProviderName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringImplicitBean", "getProviderName"));
        }
        return string;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpringImplicitBean bean = (SpringImplicitBean)o;
        if (!this.myBeanName.equals(bean.myBeanName)) {
            return false;
        }
        return this.myProviderName.equals(bean.myProviderName);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myBeanName.hashCode();
        result = 31 * result + this.myProviderName.hashCode();
        return result;
    }
}

