/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.jam.JamSimpleReferenceConverter;
import com.intellij.jam.JamStringAttributeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanReferenceJamConverter
extends JamSimpleReferenceConverter<SpringBeanPointer> {
    private final String myBaseClass;

    public SpringBeanReferenceJamConverter(@Nullable String baseClass) {
        this.myBaseClass = baseClass;
    }

    public SpringBeanPointer fromString(@Nullable String s, JamStringAttributeElement<SpringBeanPointer> context) {
        if (StringUtil.isEmptyOrSpaces((String)s)) {
            return null;
        }
        CommonSpringModel model = this.getSpringModel((PsiElement)context.getPsiElement());
        return SpringModelSearchers.findBean(model, s);
    }

    public Collection<SpringBeanPointer> getVariants(JamStringAttributeElement<SpringBeanPointer> context) {
        PsiAnnotationMemberValue psiElement = context.getPsiElement();
        if (psiElement == null) {
            return Collections.emptyList();
        }
        if (this.myBaseClass == null) {
            CommonSpringModel model = this.getSpringModel((PsiElement)psiElement);
            return model.getAllCommonBeans();
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)psiElement.getProject()).findClass(this.myBaseClass, psiElement.getResolveScope());
        if (psiClass == null) {
            return Collections.emptyList();
        }
        CommonSpringModel model = this.getSpringModel((PsiElement)psiElement);
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass(psiClass).withInheritors().effectiveBeanTypes();
        return SpringModelSearchers.findBeans(model, searchParameters);
    }

    @NotNull
    protected LookupElement createLookupElementFor(@NotNull SpringBeanPointer target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/model/jam/converters/SpringBeanReferenceJamConverter", "createLookupElementFor"));
        }
        LookupElement variant = SpringConverterUtil.createCompletionVariant(target);
        LookupElement lookupElement = variant != null ? variant : super.createLookupElementFor((Object)target);
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/SpringBeanReferenceJamConverter", "createLookupElementFor"));
        }
        return lookupElement;
    }

    protected PsiElement getPsiElementFor(@NotNull SpringBeanPointer target) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/spring/model/jam/converters/SpringBeanReferenceJamConverter", "getPsiElementFor"));
        }
        return target.getSpringBean().getIdentifyingPsiElement();
    }

    @NotNull
    protected CommonSpringModel getSpringModel(PsiElement psiElement) {
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(psiElement);
        if (commonSpringModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/jam/converters/SpringBeanReferenceJamConverter", "getSpringModel"));
        }
        return commonSpringModel;
    }
}

