/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions;

import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ex.MessagesEx;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.actions.JavaToKotlinAction;
import org.jetbrains.kotlin.idea.j2k.IdeaJavaToKotlinServices;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessor;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J#\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allJavaFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "isAnyJavaFileSelected", "", "files", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vfs/VirtualFile;)Z", "selectedJavaFiles", "update", "Companion", "idea"})
public final class JavaToKotlinAction
extends AnAction {
    @NotNull
    private static final String title = "Convert Java to Kotlin";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List javaFiles = SequencesKt.toList(this.selectedJavaFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Project project = (Project)object;
        PsiErrorElement firstSyntaxError2 = (PsiErrorElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)javaFiles), (Function1)actionPerformed.firstSyntaxError.1.INSTANCE));
        if (firstSyntaxError2 != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Collection $receiver$iv;
            Iterable iterable = javaFiles;
            void var7_6 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                PsiJavaFile it = (PsiJavaFile)element$iv$iv;
                if (!PsiTreeUtil.hasErrorElements((PsiElement)((PsiElement)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            int count = $receiver$iv.size();
            String question = firstSyntaxError2.getContainingFile().getName() + (count > 1 ? " and " + (count - 1) + " more Java files" : " file") + " contain syntax errors, the conversion result may be incorrect";
            String okText = "Investigate Errors";
            String cancelText = "Proceed with Conversion";
            if (Messages.showOkCancelDialog((Project)project, (String)question, (String)Companion.getTitle(), (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon()) == 0) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)firstSyntaxError2.getNavigationElement());
                return;
            }
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.convertFiles$default(Companion, javaFiles, project2, false, 4, null);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return;
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Presentation presentation = e.getPresentation();
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        presentation.setEnabled(this.isAnyJavaFileSelected(project3, virtualFiles));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAnyJavaFileSelected(Project project, VirtualFile[] files2) {
        VirtualFile it;
        Object element$iv;
        Object[] $receiver$iv;
        int n;
        PsiManager manager = PsiManager.getInstance((Project)project);
        Object[] objectArray = files2;
        for (n = 0; n < $receiver$iv.length; ++n) {
            element$iv = $receiver$iv[n];
            it = (VirtualFile)element$iv;
            if (!(manager.findFile(it) instanceof PsiJavaFile)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) {
            return true;
        }
        $receiver$iv = files2;
        n = 0;
        while (n < $receiver$iv.length) {
            element$iv = $receiver$iv[n];
            it = (VirtualFile)element$iv;
            if (it.isDirectory()) {
                VirtualFile[] virtualFileArray = it.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"it.children");
                if (this.isAnyJavaFileSelected(project, virtualFileArray)) {
                    return true;
                }
            }
            boolean bl2 = false;
            if (bl2) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private final Sequence<PsiJavaFile> selectedJavaFiles(AnActionEvent e) {
        Project project;
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project2 = e.getProject();
        if (project2 == null) {
            return SequencesKt.sequenceOf((Object[])new PsiJavaFile[0]);
        }
        Project project3 = project = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        return this.allJavaFiles(virtualFiles, project3);
    }

    private final Sequence<PsiJavaFile> allJavaFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, PsiJavaFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final PsiJavaFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof PsiJavaFile)) {
                    psiFile = null;
                }
                return (PsiJavaFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (int i = 0; i < filesOrDirs.length; ++i) {
            VirtualFile file2 = filesOrDirs[i];
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    this.$result.add(file2);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    static {
        title = title;
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fJ*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0002J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0011H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/actions/JavaToKotlinAction$Companion;", "", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "convertFiles", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "javaFiles", "Lcom/intellij/psi/PsiJavaFile;", "project", "Lcom/intellij/openapi/project/Project;", "enableExternalCodeProcessing", "", "saveResults", "Lcom/intellij/openapi/vfs/VirtualFile;", "convertedTexts", "uniqueKotlinFileName", "javaFile", "idea"})
    public static final class Companion {
        private final String uniqueKotlinFileName(VirtualFile javaFile) {
            File ioFile = new File(StringsKt.replace$default((String)javaFile.getPath(), (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
            int i = 0;
            String fileName;
            while (FilesKt.resolveSibling((File)ioFile, (String)(fileName = javaFile.getNameWithoutExtension() + (i > 0 ? Integer.valueOf(i) : "") + ".kt")).exists()) {
                ++i;
            }
            return fileName;
        }

        @NotNull
        public final String getTitle() {
            return title;
        }

        private final List<VirtualFile> saveResults(List<? extends PsiJavaFile> javaFiles, List<String> convertedTexts) {
            ArrayList result2 = new ArrayList();
            for (Pair pair2 : CollectionsKt.zip((Iterable)javaFiles, (Iterable)convertedTexts)) {
                PsiJavaFile psiFile = (PsiJavaFile)pair2.component1();
                String text2 = (String)pair2.component2();
                try {
                    Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument((PsiFile)psiFile);
                    if (document == null) {
                        MessagesEx.error((Project)psiFile.getProject(), (String)("Failed to save conversion result: couldn't find document for " + psiFile.getName())).showLater();
                        continue;
                    }
                    document.replaceString(0, document.getTextLength(), (CharSequence)text2);
                    FileDocumentManager.getInstance().saveDocument(document);
                    VirtualFile virtualFile2 = psiFile.getVirtualFile();
                    if (ScratchRootType.getInstance().containsFile(virtualFile2)) {
                        PerFileMappings mapping = ScratchFileService.getInstance().getScratchesMapping();
                        mapping.setMapping(virtualFile2, (Object)KotlinFileType.INSTANCE.getLanguage());
                        continue;
                    }
                    VirtualFile virtualFile3 = virtualFile2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
                    String fileName = this.uniqueKotlinFileName(virtualFile3);
                    virtualFile2.rename((Object)this, fileName);
                }
                catch (IOException e) {
                    Project project = psiFile.getProject();
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    MessagesEx.error((Project)project, (String)string).showLater();
                }
            }
            return result2;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<KtFile> convertFiles(@NotNull List<? extends PsiJavaFile> javaFiles, @NotNull Project project, boolean enableExternalCodeProcessing) {
            void externalCodeUpdate;
            void converterResult;
            Intrinsics.checkParameterIsNotNull(javaFiles, (String)"javaFiles");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ApplicationManager.getApplication().saveAll();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            Function0<Unit> convert$ = new Function0<Unit>(project, (Ref.ObjectRef)converterResult, javaFiles){
                final /* synthetic */ Project $project;
                final /* synthetic */ Ref.ObjectRef $converterResult;
                final /* synthetic */ List $javaFiles;

                public final void invoke() {
                    JavaToKotlinConverter converter = new JavaToKotlinConverter(this.$project, ConverterSettings.Companion.getDefaultSettings(), IdeaJavaToKotlinServices.INSTANCE);
                    PostProcessor postProcessor = new J2kPostProcessor(true);
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                    this.$converterResult.element = converter.filesToKotlin(this.$javaFiles, postProcessor, progressIndicator);
                }
                {
                    this.$project = project;
                    this.$converterResult = objectRef;
                    this.$javaFiles = list2;
                    super(0);
                }
            };
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(convert$){
                final /* synthetic */ convertFiles.1 $convert;

                public final void run() {
                    ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                        final /* synthetic */ convertFiles.2 this$0;

                        public final void invoke() {
                            this.this$0.$convert.invoke();
                        }

                        public final KDeclarationContainer getOwner() {
                            return null;
                        }

                        public final String getName() {
                            return "convert";
                        }

                        public final String getSignature() {
                            return "invoke()V";
                        }
                        {
                            this.this$0 = var1_1;
                            super(0);
                        }
                    });
                }
                {
                    this.$convert = var1_1;
                }
            }, this.getTitle(), true, project)) {
                return CollectionsKt.emptyList();
            }
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            if (enableExternalCodeProcessing) {
                String question;
                JavaToKotlinConverter.FilesResult filesResult = (JavaToKotlinConverter.FilesResult)converterResult.element;
                if (filesResult == null) {
                    Intrinsics.throwNpe();
                }
                if (filesResult.getExternalCodeProcessing() != null && Messages.showOkCancelDialog((Project)project, (String)(question = "Some code in the rest of your project may require corrections after performing this conversion. Do you want to find such code and correct it too?"), (String)this.getTitle(), (Icon)Messages.getQuestionIcon()) == 0) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable((Ref.ObjectRef)externalCodeUpdate, (Ref.ObjectRef)converterResult){
                        final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;
                        final /* synthetic */ Ref.ObjectRef $converterResult;

                        public final void run() {
                            ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                                final /* synthetic */ convertFiles.3 this$0;

                                public final void invoke() {
                                    Ref.ObjectRef objectRef = this.this$0.$externalCodeUpdate;
                                    JavaToKotlinConverter.FilesResult filesResult = (JavaToKotlinConverter.FilesResult)this.this$0.$converterResult.element;
                                    if (filesResult == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    JavaToKotlinConverter.ExternalCodeProcessing externalCodeProcessing2 = filesResult.getExternalCodeProcessing();
                                    if (externalCodeProcessing2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)progressIndicator, (String)"ProgressManager.getInstance().progressIndicator");
                                    objectRef.element = externalCodeProcessing2.prepareWriteOperation(progressIndicator);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(0);
                                }
                            });
                        }
                        {
                            this.$externalCodeUpdate = objectRef;
                            this.$converterResult = objectRef2;
                        }
                    }, this.getTitle(), true, project);
                }
            }
            return (List)ApplicationUtilsKt.executeWriteCommand(project, "Convert files from Java to Kotlin", null, (Function0)new Function0<List<? extends KtFile>>(project, javaFiles, (Ref.ObjectRef)converterResult, (Ref.ObjectRef)externalCodeUpdate){
                final /* synthetic */ Project $project;
                final /* synthetic */ List $javaFiles;
                final /* synthetic */ Ref.ObjectRef $converterResult;
                final /* synthetic */ Ref.ObjectRef $externalCodeUpdate;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final List<KtFile> invoke() {
                    void destination$iv$iv;
                    void $receiver$iv$iv;
                    Object it;
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.$project);
                    JavaToKotlinConverter.FilesResult filesResult = (JavaToKotlinConverter.FilesResult)this.$converterResult.element;
                    if (filesResult == null) {
                        Intrinsics.throwNpe();
                    }
                    List newFiles = org.jetbrains.kotlin.idea.actions.JavaToKotlinAction$Companion.access$saveResults(JavaToKotlinAction.Companion, this.$javaFiles, filesResult.getResults());
                    Function0 function0 = (Function0)this.$externalCodeUpdate.element;
                    if (function0 != null) {
                        Unit cfr_ignored_0 = (Unit)function0.invoke();
                    }
                    PsiDocumentManager.getInstance((Project)this.$project).commitAllDocuments();
                    VirtualFile virtualFile2 = (VirtualFile)CollectionsKt.singleOrNull((List)newFiles);
                    if (virtualFile2 != null) {
                        VirtualFile virtualFile3 = virtualFile2;
                        it = virtualFile3;
                        FileEditorManager.getInstance((Project)this.$project).openFile(it, true);
                    }
                    Iterable $receiver$iv = newFiles;
                    it = $receiver$iv;
                    Collection $i$a$1$let = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it2;
                        VirtualFile virtualFile4 = (VirtualFile)item$iv$iv;
                        void var11_8 = destination$iv$iv;
                        PsiFile psiFile = KotlinRefactoringUtilKt.toPsiFile((VirtualFile)it2, this.$project);
                        if (psiFile == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                        }
                        KtFile ktFile = (KtFile)psiFile;
                        var11_8.add(ktFile);
                    }
                    return (List)destination$iv$iv;
                }
                {
                    this.$project = project;
                    this.$javaFiles = list2;
                    this.$converterResult = objectRef;
                    this.$externalCodeUpdate = objectRef2;
                    super(0);
                }
            });
        }

        @NotNull
        public static /* bridge */ /* synthetic */ List convertFiles$default(Companion companion, List list2, Project project, boolean bl, int n, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convertFiles");
            }
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.convertFiles(list2, project, bl);
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ List access$saveResults(Companion $this, @NotNull List javaFiles, @NotNull List convertedTexts) {
            return $this.saveResults(javaFiles, convertedTexts);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

