/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.j2k;

import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.conversion.copy.RangeUtilsKt;
import org.jetbrains.kotlin.idea.j2k.J2KPostProcessingRegistrar;
import org.jetbrains.kotlin.idea.j2k.J2kPostProcessing;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.j2k.PostProcessor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor;", "Lorg/jetbrains/kotlin/j2k/PostProcessor;", "formatCode", "", "(Z)V", "analyzeFileRange", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "collectAvailableActions", "", "Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$ActionData;", "doAdditionalProcessing", "", "insertImport", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "rangeFilter", "Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$RangeFilterResult;", "element", "Lcom/intellij/psi/PsiElement;", "ActionData", "RangeFilterResult", "idea"})
public final class J2kPostProcessor
implements PostProcessor {
    private final boolean formatCode;

    @Override
    public void insertImport(@NotNull KtFile file2, @NotNull FqName fqName2) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            Collection<DeclarationDescriptor> descriptors = ResolutionUtils.resolveImportReference(file2, fqName2);
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)CollectionsKt.firstOrNull((Iterable)descriptors);
            if (declarationDescriptor == null) break block0;
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            DeclarationDescriptor it = declarationDescriptor2;
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            ImportInsertHelper.importDescriptor$default(ImportInsertHelper.Companion.getInstance(project), file2, it, false, 4, null);
        }
    }

    @Override
    public void doAdditionalProcessing(@NotNull KtFile file2, @Nullable RangeMarker rangeMarker) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        List<ActionData> elementToActions = this.collectAvailableActions(file2, rangeMarker);
        while (true) {
            Collection collection = elementToActions;
            if (!(!collection.isEmpty())) break;
            Long modificationStamp = file2.getModificationStamp();
            for (ActionData actionData : elementToActions) {
                KtElement element2 = actionData.component1();
                Function0<Unit> action2 = actionData.component2();
                int processing = actionData.component3();
                if (element2.isValid()) {
                    action2.invoke();
                    continue;
                }
                modificationStamp = null;
            }
            if (Intrinsics.areEqual((Object)modificationStamp, (Object)file2.getModificationStamp())) break;
            elementToActions = this.collectAvailableActions(file2, rangeMarker);
        }
        if (this.formatCode) {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)file2.getProject());
            if (rangeMarker != null) {
                if (rangeMarker.isValid()) {
                    codeStyleManager.reformatRange((PsiElement)file2, rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
                }
            } else {
                codeStyleManager.reformat((PsiElement)file2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ActionData> collectAvailableActions(KtFile file2, RangeMarker rangeMarker) {
        void $receiver$iv;
        Diagnostics diagnostics2 = this.analyzeFileRange(file2, rangeMarker);
        ArrayList availableActions = new ArrayList();
        file2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, rangeMarker, diagnostics2, availableActions){
            final /* synthetic */ J2kPostProcessor this$0;
            final /* synthetic */ RangeMarker $rangeMarker;
            final /* synthetic */ Diagnostics $diagnostics;
            final /* synthetic */ ArrayList $availableActions;

            public void visitElement(@NotNull PsiElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (element2 instanceof KtElement) {
                    RangeFilterResult rangeResult = J2kPostProcessor.access$rangeFilter(this.this$0, element2, this.$rangeMarker);
                    if (Intrinsics.areEqual((Object)((Object)rangeResult), (Object)((Object)RangeFilterResult.SKIP))) {
                        return;
                    }
                    super.visitElement(element2);
                    if (Intrinsics.areEqual((Object)((Object)rangeResult), (Object)((Object)RangeFilterResult.PROCESS))) {
                        Iterable $receiver$iv = J2KPostProcessingRegistrar.INSTANCE.getProcessings();
                        for (T element$iv : $receiver$iv) {
                            J2kPostProcessing processing = (J2kPostProcessing)element$iv;
                            Function0<Unit> action2 = processing.createAction((KtElement)element2, this.$diagnostics);
                            if (action2 == null) continue;
                            this.$availableActions.add(new ActionData((KtElement)element2, action2, J2KPostProcessingRegistrar.INSTANCE.priority(processing)));
                        }
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$rangeMarker = $captured_local_variable$1;
                this.$diagnostics = $captured_local_variable$2;
                this.$availableActions = $captured_local_variable$3;
            }
        });
        List list2 = availableActions;
        if ($receiver$iv.size() > 1) {
            void var6_6 = $receiver$iv;
            Comparator comparator = new Comparator<ActionData>(){

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public int compare(Object a, Object b) {
                    ActionData it = (ActionData)a;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (ActionData)b;
                    Comparable comparable2 = comparable;
                    Integer n = it.getPriority();
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                }
            };
            CollectionsKt.sortWith((List)var6_6, (Comparator)comparator);
        }
        return availableActions;
    }

    /*
     * WARNING - void declaration
     */
    private final Diagnostics analyzeFileRange(KtFile file2, RangeMarker rangeMarker) {
        Diagnostics diagnostics2;
        Iterable iterable;
        List list2;
        if (rangeMarker == null) {
            list2 = CollectionsKt.listOf((Object)file2);
        } else {
            void destination$iv$iv;
            void $receiver$iv$iv;
            void $receiver$iv;
            PsiFile psiFile = (PsiFile)file2;
            TextRange textRange = RangeUtilsKt.getRange(rangeMarker);
            if (textRange == null) {
                Intrinsics.throwNpe();
            }
            iterable = PsiUtilsKt.elementsInRange(psiFile, textRange);
            void var5_4 = $receiver$iv;
            Collection collection = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof KtElement)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        }
        List elements2 = list2;
        iterable = elements2;
        if (!iterable.isEmpty()) {
            Diagnostics diagnostics3 = ResolutionUtils.getResolutionFacade(file2).analyzeFullyAndGetResult(elements2).getBindingContext().getDiagnostics();
            diagnostics2 = diagnostics3;
            Intrinsics.checkExpressionValueIsNotNull((Object)diagnostics3, (String)"file.getResolutionFacade\u2026indingContext.diagnostics");
        } else {
            diagnostics2 = Diagnostics.Companion.getEMPTY();
        }
        return diagnostics2;
    }

    private final RangeFilterResult rangeFilter(PsiElement element2, RangeMarker rangeMarker) {
        TextRange elementRange;
        if (rangeMarker == null) {
            return RangeFilterResult.PROCESS;
        }
        if (!rangeMarker.isValid()) {
            return RangeFilterResult.SKIP;
        }
        TextRange range = new TextRange(rangeMarker.getStartOffset(), rangeMarker.getEndOffset());
        return range.contains(elementRange = element2.getTextRange()) ? RangeFilterResult.PROCESS : (range.intersects(elementRange) ? RangeFilterResult.GO_INSIDE : RangeFilterResult.SKIP);
    }

    public J2kPostProcessor(boolean formatCode) {
        this.formatCode = formatCode;
    }

    @NotNull
    public static final /* synthetic */ RangeFilterResult access$rangeFilter(J2kPostProcessor $this, @NotNull PsiElement element2, @Nullable RangeMarker rangeMarker) {
        return $this.rangeFilter(element2, rangeMarker);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$RangeFilterResult;", "", "(Ljava/lang/String;I)V", "SKIP", "GO_INSIDE", "PROCESS", "idea"})
    private static final class RangeFilterResult
    extends Enum<RangeFilterResult> {
        public static final /* enum */ RangeFilterResult SKIP;
        public static final /* enum */ RangeFilterResult GO_INSIDE;
        public static final /* enum */ RangeFilterResult PROCESS;
        private static final /* synthetic */ RangeFilterResult[] $VALUES;

        static {
            RangeFilterResult[] rangeFilterResultArray = new RangeFilterResult[3];
            RangeFilterResult[] rangeFilterResultArray2 = rangeFilterResultArray;
            rangeFilterResultArray[0] = SKIP = new RangeFilterResult();
            rangeFilterResultArray[1] = GO_INSIDE = new RangeFilterResult();
            rangeFilterResultArray[2] = PROCESS = new RangeFilterResult();
            $VALUES = rangeFilterResultArray;
        }

        public static RangeFilterResult[] values() {
            return (RangeFilterResult[])$VALUES.clone();
        }

        public static RangeFilterResult valueOf(String string) {
            return Enum.valueOf(RangeFilterResult.class, string);
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/j2k/J2kPostProcessor$ActionData;", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "action", "Lkotlin/Function0;", "", "priority", "", "(Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/jvm/functions/Function0;I)V", "getAction", "()Lkotlin/jvm/functions/Function0;", "getElement", "()Lorg/jetbrains/kotlin/psi/KtElement;", "getPriority", "()I", "component1", "component2", "component3", "copy", "idea"})
    private static final class ActionData {
        @NotNull
        private final KtElement element;
        @NotNull
        private final Function0<Unit> action;
        private final int priority;

        @NotNull
        public final KtElement getElement() {
            return this.element;
        }

        @NotNull
        public final Function0<Unit> getAction() {
            return this.action;
        }

        public final int getPriority() {
            return this.priority;
        }

        public ActionData(@NotNull KtElement element2, @NotNull Function0<Unit> action2, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            this.element = element2;
            this.action = action2;
            this.priority = priority;
        }

        @NotNull
        public final KtElement component1() {
            return this.element;
        }

        @NotNull
        public final Function0<Unit> component2() {
            return this.action;
        }

        public final int component3() {
            return this.priority;
        }

        @NotNull
        public final ActionData copy(@NotNull KtElement element2, @NotNull Function0<Unit> action2, int priority) {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Intrinsics.checkParameterIsNotNull(action2, (String)"action");
            return new ActionData(element2, action2, priority);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ActionData copy$default(ActionData actionData, KtElement ktElement, Function0 function0, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                ktElement = actionData.element;
            }
            if ((n2 & 2) != 0) {
                function0 = actionData.action;
            }
            if ((n2 & 4) != 0) {
                n = actionData.priority;
            }
            return actionData.copy(ktElement, function0, n);
        }

        public String toString() {
            return "ActionData(element=" + this.element + ", action=" + this.action + ", priority=" + this.priority + ")";
        }

        public int hashCode() {
            KtElement ktElement = this.element;
            Function0<Unit> function0 = this.action;
            return ((ktElement != null ? ktElement.hashCode() : 0) * 31 + (function0 != null ? function0.hashCode() : 0)) * 31 + this.priority;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ActionData)) break block3;
                    ActionData actionData = (ActionData)object;
                    if (!Intrinsics.areEqual((Object)this.element, (Object)actionData.element) || !Intrinsics.areEqual(this.action, actionData.action) || !(this.priority == actionData.priority)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

