/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.refactoring;

import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.refactoring.ElementRenderingUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.ElementSelectionUtilsKt$WhenMappings;
import org.jetbrains.kotlin.idea.refactoring.IntroduceRefactoringException;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringBundle;
import org.jetbrains.kotlin.idea.refactoring.introduce.IntroduceUtilKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a2\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00102\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007\u001aD\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00140\u001bH\u0007\u001a<\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00140\u001bH\u0007\u001aL\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00192\u0014\u0010\u001a\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00140\u001bH\u0003\u00a8\u0006\u001d"}, d2={"findElement", "Lcom/intellij/psi/PsiElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startOffset", "", "endOffset", "failOnNoExpression", "", "elementKind", "Lorg/jetbrains/kotlin/idea/codeInsight/CodeInsightUtils$ElementKind;", "getExpressionShortText", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "getSmartSelectSuggestions", "", "Lcom/intellij/psi/PsiFile;", "offset", "selectElement", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "failOnEmptySuggestion", "elementKinds", "", "callback", "Lkotlin/Function1;", "smartSelectElement", "idea"})
public final class ElementSelectionUtilsKt {
    public static final void selectElement(@NotNull Editor editor, @NotNull KtFile file2, @NotNull Collection<? extends CodeInsightUtils.ElementKind> elementKinds, @NotNull Function1<? super PsiElement, Unit> callback2) throws IntroduceRefactoringException {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(elementKinds, (String)"elementKinds");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        ElementSelectionUtilsKt.selectElement(editor, file2, true, elementKinds, callback2);
    }

    /*
     * WARNING - void declaration
     */
    public static final void selectElement(@NotNull Editor editor, @NotNull KtFile file2, boolean failOnEmptySuggestion, @NotNull Collection<? extends CodeInsightUtils.ElementKind> elementKinds, @NotNull Function1<? super PsiElement, Unit> callback2) throws IntroduceRefactoringException {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull(elementKinds, (String)"elementKinds");
        Intrinsics.checkParameterIsNotNull(callback2, (String)"callback");
        if (editor.getSelectionModel().hasSelection()) {
            void selectionEnd;
            Object selectionStart;
            Ref.IntRef intRef = new Ref.IntRef();
            intRef.element = editor.getSelectionModel().getSelectionStart();
            Ref.IntRef intRef2 = new Ref.IntRef();
            intRef2.element = editor.getSelectionModel().getSelectionEnd();
            PsiElement psiElement = file2.findElementAt(selectionStart.element);
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            PsiElement firstElement = psiElement;
            PsiElement psiElement2 = file2.findElementAt(selectionEnd.element - 1);
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            PsiElement lastElement = psiElement2;
            if (PsiTreeUtil.getParentOfType((PsiElement)firstElement, (Class[])new Class[]{KtLiteralStringTemplateEntry.class, KtEscapeStringTemplateEntry.class}) == null && PsiTreeUtil.getParentOfType((PsiElement)lastElement, (Class[])new Class[]{KtLiteralStringTemplateEntry.class, KtEscapeStringTemplateEntry.class}) == null) {
                PsiElement psiElement3 = PsiUtilsKt.getNextSiblingIgnoringWhitespaceAndComments(firstElement, true);
                if (psiElement3 == null) {
                    Intrinsics.throwNpe();
                }
                firstElement = psiElement3;
                PsiElement psiElement4 = PsiUtilsKt.getPrevSiblingIgnoringWhitespaceAndComments(lastElement, true);
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                lastElement = psiElement4;
                selectionStart.element = firstElement.getTextRange().getStartOffset();
                selectionEnd.element = lastElement.getTextRange().getEndOffset();
            }
            PsiElement element2 = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)elementKinds), (Function1)((Function1)new Function1<CodeInsightUtils.ElementKind, PsiElement>(file2, (Ref.IntRef)selectionStart, (Ref.IntRef)selectionEnd, failOnEmptySuggestion){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ Ref.IntRef $selectionStart;
                final /* synthetic */ Ref.IntRef $selectionEnd;
                final /* synthetic */ boolean $failOnEmptySuggestion;

                @Nullable
                public final PsiElement invoke(@NotNull CodeInsightUtils.ElementKind it) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                    return ElementSelectionUtilsKt.access$findElement(this.$file, this.$selectionStart.element, this.$selectionEnd.element, this.$failOnEmptySuggestion, it);
                }
                {
                    this.$file = ktFile;
                    this.$selectionStart = intRef;
                    this.$selectionEnd = intRef2;
                    this.$failOnEmptySuggestion = bl;
                    super(1);
                }
            })));
            callback2.invoke((Object)element2);
            intRef2 = null;
            selectionStart = null;
        } else {
            int offset2 = editor.getCaretModel().getOffset();
            ElementSelectionUtilsKt.smartSelectElement(editor, (PsiFile)file2, offset2, failOnEmptySuggestion, elementKinds, callback2);
        }
    }

    @NotNull
    public static final List<KtElement> getSmartSelectSuggestions(@NotNull PsiFile file2, int offset2, @NotNull CodeInsightUtils.ElementKind elementKind) throws IntroduceRefactoringException {
        PsiElement element2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)((Object)elementKind), (String)"elementKind");
        if (offset2 < 0) {
            return CollectionsKt.emptyList();
        }
        if (file2.findElementAt(offset2) == null) {
            return CollectionsKt.emptyList();
        }
        if (element2 instanceof PsiWhiteSpace) {
            return ElementSelectionUtilsKt.getSmartSelectSuggestions(file2, offset2 - 1, elementKind);
        }
        ArrayList<KtElement> elements2 = new ArrayList<KtElement>();
        for (element2 = v724000; !(element2 == null || element2 instanceof KtBlockExpression && !(((KtBlockExpression)element2).getParent() instanceof KtFunctionLiteral) || element2 instanceof KtNamedFunction || element2 instanceof KtClassBody); element2 = element2.getParent()) {
            boolean addElement2 = false;
            boolean keepPrevious = true;
            if (element2 instanceof KtTypeElement) {
                addElement2 = Intrinsics.areEqual((Object)((Object)elementKind), (Object)((Object)CodeInsightUtils.ElementKind.TYPE_ELEMENT));
                if (!addElement2) {
                    keepPrevious = false;
                }
            } else if (element2 instanceof KtExpression && !(element2 instanceof KtStatementExpression) && (addElement2 = Intrinsics.areEqual((Object)((Object)elementKind), (Object)((Object)CodeInsightUtils.ElementKind.EXPRESSION)))) {
                BindingContext bindingContext2;
                KotlinType expressionType;
                if (element2 instanceof KtParenthesizedExpression) {
                    addElement2 = false;
                } else if (KtPsiUtil.isLabelIdentifierExpression(element2)) {
                    addElement2 = false;
                } else if (((KtExpression)element2).getParent() instanceof KtQualifiedExpression) {
                    PsiElement psiElement = ((KtExpression)element2).getParent();
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtQualifiedExpression");
                    }
                    KtQualifiedExpression qualifiedExpression = (KtQualifiedExpression)psiElement;
                    if (qualifiedExpression.getReceiverExpression() != element2) {
                        addElement2 = false;
                    }
                } else if (((KtExpression)element2).getParent() instanceof KtCallElement || ((KtExpression)element2).getParent() instanceof KtThisExpression || PsiTreeUtil.getParentOfType((PsiElement)element2, KtSuperExpression.class) != null) {
                    addElement2 = false;
                } else if (((KtExpression)element2).getParent() instanceof KtOperationExpression) {
                    PsiElement psiElement = ((KtExpression)element2).getParent();
                    if (psiElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtOperationExpression");
                    }
                    KtOperationExpression operationExpression = (KtOperationExpression)psiElement;
                    if (operationExpression.getOperationReference() == element2) {
                        addElement2 = false;
                    }
                }
                if (addElement2 && ((expressionType = (bindingContext2 = ResolutionUtils.analyze((KtElement)element2, BodyResolveMode.FULL)).getType((KtExpression)element2)) == null || KotlinBuiltIns.isUnit(expressionType))) {
                    addElement2 = false;
                }
            }
            if (addElement2) {
                PsiElement psiElement = element2;
                if (psiElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                elements2.add((KtElement)psiElement);
            }
            if (keepPrevious) continue;
            elements2.clear();
        }
        return elements2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void smartSelectElement(Editor editor, PsiFile file2, int offset2, boolean failOnEmptySuggestion, Collection<? extends CodeInsightUtils.ElementKind> elementKinds, Function1<? super PsiElement, Unit> callback2) throws IntroduceRefactoringException {
        void $receiver$iv;
        Iterator destination$iv$iv;
        Iterable $receiver$iv$iv;
        void $receiver$iv2;
        Iterable iterable = elementKinds;
        void var8_7 = $receiver$iv2;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            CodeInsightUtils.ElementKind it = (CodeInsightUtils.ElementKind)((Object)element$iv$iv);
            Iterable list$iv$iv = ElementSelectionUtilsKt.getSmartSelectSuggestions(file2, offset2, it);
            CollectionsKt.addAll((Collection)((Object)destination$iv$iv), (Iterable)list$iv$iv);
        }
        List elements2 = (List)((Object)destination$iv$iv);
        if (elements2.isEmpty()) {
            if (failOnEmptySuggestion) {
                String string = KotlinRefactoringBundle.message("cannot.refactor.not.expression", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinRefactoringBundle.\u2026refactor.not.expression\")");
                throw (Throwable)new IntroduceRefactoringException(string);
            }
            callback2.invoke(null);
            return;
        }
        if (elements2.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            callback2.invoke(CollectionsKt.first((List)elements2));
            return;
        }
        DefaultListModel<KtElement> model = new DefaultListModel<KtElement>();
        $receiver$iv$iv = elements2;
        for (Object element$iv : $receiver$iv) {
            KtElement it = (KtElement)element$iv;
            model.addElement(it);
        }
        ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        JBList list2 = new JBList((ListModel)model);
        list2.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @NotNull
            public Component getListCellRendererComponent(@NotNull JList<?> list2, @Nullable Object value2, int index2, boolean isSelected, boolean cellHasFocus) {
                KtElement element2;
                Intrinsics.checkParameterIsNotNull(list2, (String)"list");
                Component rendererComponent = super.getListCellRendererComponent(list2, value2, index2, isSelected, cellHasFocus);
                KtElement ktElement = element2 = (KtElement)value2;
                if (ktElement == null) {
                    Intrinsics.throwNpe();
                }
                if (ktElement.isValid()) {
                    this.setText(ElementSelectionUtilsKt.getExpressionShortText(element2));
                }
                Component component = rendererComponent;
                Intrinsics.checkExpressionValueIsNotNull((Object)component, (String)"rendererComponent");
                return component;
            }
        });
        list2.addListSelectionListener(new ListSelectionListener(highlighter, list2, model){
            final /* synthetic */ ScopeHighlighter $highlighter;
            final /* synthetic */ JBList $list;
            final /* synthetic */ DefaultListModel $model;

            public final void valueChanged(ListSelectionEvent it) {
                this.$highlighter.dropHighlight();
                int selectedIndex = this.$list.getSelectedIndex();
                if (selectedIndex < 0) {
                    return;
                }
                ArrayList<E> toExtract = new ArrayList<E>();
                toExtract.add(this.$model.get(selectedIndex));
                this.$highlighter.highlight((PsiElement)this.$model.get(selectedIndex), (List)toExtract);
            }
            {
                this.$highlighter = scopeHighlighter;
                this.$list = jBList;
                this.$model = defaultListModel;
            }
        });
        String title = "Elements";
        if (elementKinds.size() == 1) {
            switch (ElementSelectionUtilsKt$WhenMappings.$EnumSwitchMapping$0[elementKinds.iterator().next().ordinal()]) {
                case 1: {
                    title = "Expressions";
                    break;
                }
                case 2: {
                    title = "Types";
                }
            }
        }
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list2).setTitle(title).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(new Runnable(callback2, list2){
            final /* synthetic */ Function1 $callback;
            final /* synthetic */ JBList $list;

            public final void run() {
                Object object = this.$list.getSelectedValue();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
                }
                this.$callback.invoke((Object)((KtElement)object));
            }
            {
                this.$callback = function1;
                this.$list = jBList;
            }
        }).addListener((JBPopupListener)new JBPopupAdapter(highlighter){
            final /* synthetic */ ScopeHighlighter $highlighter;

            public void onClosed(@Nullable LightweightWindowEvent event) {
                this.$highlighter.dropHighlight();
            }
            {
                this.$highlighter = $captured_local_variable$0;
            }
        }).createPopup().showInBestPositionFor(editor);
    }

    @NotNull
    public static final String getExpressionShortText(@NotNull KtElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        String text2 = ElementRenderingUtilsKt.renderTrimmed(element2);
        int firstNewLinePos = StringsKt.indexOf$default((CharSequence)text2, (char)'\n', (int)0, (boolean)false, (int)6, null);
        String string = text2;
        int n = 0;
        int n2 = firstNewLinePos != -1 ? firstNewLinePos : Math.min(100, text2.length());
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String trimmedText = string3;
        if (trimmedText.length() != text2.length()) {
            trimmedText = trimmedText + " ...";
        }
        return trimmedText;
    }

    private static final PsiElement findElement(KtFile file2, int startOffset, int endOffset, boolean failOnNoExpression, CodeInsightUtils.ElementKind elementKind) throws IntroduceRefactoringException {
        PsiElement element2 = CodeInsightUtils.findElement((PsiFile)file2, startOffset, endOffset, elementKind);
        if (element2 == null && Intrinsics.areEqual((Object)((Object)elementKind), (Object)((Object)CodeInsightUtils.ElementKind.EXPRESSION))) {
            element2 = (PsiElement)IntroduceUtilKt.findExpressionOrStringFragment(file2, startOffset, endOffset);
        }
        if (element2 == null) {
            if (failOnNoExpression) {
                String string = KotlinRefactoringBundle.message("cannot.refactor.not.expression", new Object[0]);
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"KotlinRefactoringBundle.\u2026refactor.not.expression\")");
                throw (Throwable)new IntroduceRefactoringException(string);
            }
            return null;
        }
        return element2;
    }

    @Nullable
    public static final /* synthetic */ PsiElement access$findElement(@NotNull KtFile file2, int startOffset, int endOffset, boolean failOnNoExpression, @NotNull CodeInsightUtils.ElementKind elementKind) {
        return ElementSelectionUtilsKt.findElement(file2, startOffset, endOffset, failOnNoExpression, elementKind);
    }
}

