/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.j2k.Converter;
import org.jetbrains.kotlin.j2k.TypeConverter;
import org.jetbrains.kotlin.j2k.TypeVisitorKt;
import org.jetbrains.kotlin.j2k.UtilsKt;
import org.jetbrains.kotlin.j2k.ast.ArrayType;
import org.jetbrains.kotlin.j2k.ast.ClassType;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.ElementKt;
import org.jetbrains.kotlin.j2k.ast.ErrorType;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.InProjectionType;
import org.jetbrains.kotlin.j2k.ast.Mutability;
import org.jetbrains.kotlin.j2k.ast.NullType;
import org.jetbrains.kotlin.j2k.ast.Nullability;
import org.jetbrains.kotlin.j2k.ast.OutProjectionType;
import org.jetbrains.kotlin.j2k.ast.PrimitiveType;
import org.jetbrains.kotlin.j2k.ast.ReferenceElement;
import org.jetbrains.kotlin.j2k.ast.StarProjectionType;
import org.jetbrains.kotlin.j2k.ast.Type;
import org.jetbrains.kotlin.j2k.ast.UnitType;
import org.jetbrains.kotlin.j2k.ast.VarArgType;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\bH\u0002J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0006H\u0016J\u0010\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020%H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/j2k/TypeVisitor;", "Lcom/intellij/psi/PsiTypeVisitor;", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "converter", "Lorg/jetbrains/kotlin/j2k/Converter;", "topLevelType", "Lcom/intellij/psi/PsiType;", "topLevelTypeMutability", "Lorg/jetbrains/kotlin/j2k/ast/Mutability;", "inAnnotationType", "", "(Lorg/jetbrains/kotlin/j2k/Converter;Lcom/intellij/psi/PsiType;Lorg/jetbrains/kotlin/j2k/ast/Mutability;Z)V", "typeConverter", "Lorg/jetbrains/kotlin/j2k/TypeConverter;", "constructReferenceElement", "Lorg/jetbrains/kotlin/j2k/ast/ReferenceElement;", "classType", "Lcom/intellij/psi/PsiClassType;", "mutability", "convertTypeArgs", "", "createTypeArgsForRawTypeUsage", "visitArrayType", "arrayType", "Lcom/intellij/psi/PsiArrayType;", "visitClassType", "visitEllipsisType", "ellipsisType", "Lcom/intellij/psi/PsiEllipsisType;", "visitPrimitiveType", "primitiveType", "Lcom/intellij/psi/PsiPrimitiveType;", "visitType", "Lorg/jetbrains/kotlin/j2k/ast/ErrorType;", "type", "visitWildcardType", "wildcardType", "Lcom/intellij/psi/PsiWildcardType;", "j2k"})
public final class TypeVisitor
extends PsiTypeVisitor<Type> {
    private final TypeConverter typeConverter;
    private final Converter converter;
    private final PsiType topLevelType;
    private final Mutability topLevelTypeMutability;
    private final boolean inAnnotationType;

    @NotNull
    public ErrorType visitType(@NotNull PsiType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        return new ErrorType();
    }

    @NotNull
    public Type visitPrimitiveType(@NotNull PsiPrimitiveType primitiveType) {
        Type type2;
        Intrinsics.checkParameterIsNotNull((Object)primitiveType, (String)"primitiveType");
        String name2 = primitiveType.getCanonicalText();
        if (Intrinsics.areEqual((Object)name2, (Object)"void")) {
            type2 = new UnitType();
        } else if (TypeVisitorKt.access$getPRIMITIVE_TYPES_NAMES$p().contains(name2)) {
            String string = StringUtil.capitalize((String)name2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.capitalize(name)");
            type2 = new PrimitiveType(Identifier.Companion.withNoPrototype$default(Identifier.Companion, string, false, false, null, 14, null));
        } else if (Intrinsics.areEqual((Object)name2, (Object)"null")) {
            type2 = new NullType();
        } else {
            String string = name2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"name");
            type2 = new PrimitiveType(Identifier.Companion.withNoPrototype$default(Identifier.Companion, string, false, false, null, 14, null));
        }
        return type2;
    }

    @NotNull
    public Type visitArrayType(@NotNull PsiArrayType arrayType) {
        Intrinsics.checkParameterIsNotNull((Object)arrayType, (String)"arrayType");
        return new ArrayType(TypeConverter.convertType$default(this.typeConverter, arrayType.getComponentType(), null, null, this.inAnnotationType, 6, null), Nullability.Default, this.converter.getSettings());
    }

    @NotNull
    public Type visitClassType(@NotNull PsiClassType classType) {
        Intrinsics.checkParameterIsNotNull((Object)classType, (String)"classType");
        Mutability mutability = classType == this.topLevelType ? this.topLevelTypeMutability : Mutability.Default;
        ReferenceElement refElement = this.constructReferenceElement(classType, mutability);
        return new ClassType(refElement, Nullability.Default, this.converter.getSettings());
    }

    private final ReferenceElement constructReferenceElement(PsiClassType classType, Mutability mutability) {
        List<Type> typeArgs = this.convertTypeArgs(classType);
        PsiClass psiClass2 = classType.resolve();
        if (psiClass2 != null) {
            String javaClassName = psiClass2.getQualifiedName();
            Identifier identifier = UtilsKt.convertToKotlinAnalogIdentifier(this.converter, javaClassName, mutability);
            if (identifier != null) {
                Identifier identifier2 = identifier;
                Identifier it = identifier2;
                return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(it, typeArgs));
            }
            if (this.inAnnotationType && Intrinsics.areEqual((Object)javaClassName, (Object)"java.lang.Class")) {
                FqName fqName2 = new FqName("kotlin.reflect.KClass");
                String string = fqName2.shortName().getIdentifier();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fqName.shortName().identifier");
                Identifier identifier3 = Identifier.Companion.withNoPrototype$default(Identifier.Companion, string, false, false, CollectionsKt.listOf((Object)fqName2), 6, null);
                return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(identifier3, typeArgs));
            }
        }
        if (classType instanceof PsiClassReferenceType) {
            PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = ((PsiClassReferenceType)classType).getReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiJavaCodeReferenceElement, (String)"classType.reference");
            return this.converter.convertCodeReferenceElement(psiJavaCodeReferenceElement, false, typeArgs);
        }
        String string = classType.getClassName();
        if (string == null) {
            string = "";
        }
        return (ReferenceElement)ElementKt.assignNoPrototype((Element)new ReferenceElement(Identifier.Companion.withNoPrototype$default(Identifier.Companion, string, false, false, null, 14, null), typeArgs));
    }

    private final List<Type> convertTypeArgs(PsiClassType classType) {
        if (classType.getParameterCount() == 0) {
            return this.createTypeArgsForRawTypeUsage(classType, Mutability.Default);
        }
        PsiType[] psiTypeArray = classType.getParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiTypeArray, (String)"classType.parameters");
        return this.typeConverter.convertTypes(psiTypeArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Type> createTypeArgsForRawTypeUsage(PsiClassType classType, Mutability mutability) {
        if (classType instanceof PsiClassReferenceType) {
            PsiClass targetClass;
            PsiElement psiElement = ((PsiClassReferenceType)classType).getReference().resolve();
            if (!(psiElement instanceof PsiClass)) {
                psiElement = null;
            }
            if ((targetClass = (PsiClass)psiElement) != null) {
                void destination$iv$iv;
                void $receiver$iv$iv;
                void $receiver$iv;
                Object[] objectArray = targetClass.getTypeParameters();
                void var5_5 = $receiver$iv;
                Collection collection = new ArrayList(((void)$receiver$iv).length);
                for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                    void item$iv$iv = $receiver$iv$iv[i];
                    PsiTypeParameter psiTypeParameter = (PsiTypeParameter)item$iv$iv;
                    void var13_10 = destination$iv$iv;
                    StarProjectionType starProjectionType2 = (StarProjectionType)ElementKt.assignNoPrototype((Element)new StarProjectionType());
                    var13_10.add(starProjectionType2);
                }
                return (List)destination$iv$iv;
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public Type visitWildcardType(@NotNull PsiWildcardType wildcardType) {
        Intrinsics.checkParameterIsNotNull((Object)wildcardType, (String)"wildcardType");
        return wildcardType.isExtends() ? (Type)new OutProjectionType(TypeConverter.convertType$default(this.typeConverter, wildcardType.getExtendsBound(), null, null, false, 14, null)) : (wildcardType.isSuper() ? (Type)new InProjectionType(TypeConverter.convertType$default(this.typeConverter, wildcardType.getSuperBound(), null, null, false, 14, null)) : (Type)new StarProjectionType());
    }

    @NotNull
    public Type visitEllipsisType(@NotNull PsiEllipsisType ellipsisType) {
        Intrinsics.checkParameterIsNotNull((Object)ellipsisType, (String)"ellipsisType");
        return new VarArgType(TypeConverter.convertType$default(this.typeConverter, ellipsisType.getComponentType(), null, null, this.inAnnotationType, 6, null));
    }

    public TypeVisitor(@NotNull Converter converter, @NotNull PsiType topLevelType, @NotNull Mutability topLevelTypeMutability, boolean inAnnotationType) {
        Intrinsics.checkParameterIsNotNull((Object)converter, (String)"converter");
        Intrinsics.checkParameterIsNotNull((Object)topLevelType, (String)"topLevelType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)topLevelTypeMutability), (String)"topLevelTypeMutability");
        this.converter = converter;
        this.topLevelType = topLevelType;
        this.topLevelTypeMutability = topLevelTypeMutability;
        this.inAnnotationType = inAnnotationType;
        this.typeConverter = this.converter.getTypeConverter();
    }
}

