/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/ProtectedConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "frontend"})
public final class ProtectedConstructorCallChecker
implements CallChecker {
    public static final ProtectedConstructorCallChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block8: {
            boolean bl;
            DeclarationDescriptor scopeOwner;
            ConstructorDescriptor descriptor2;
            block7: {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
                Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
                Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                Object obj = resolvedCall2.getResultingDescriptor();
                if (!(obj instanceof ConstructorDescriptor)) {
                    obj = null;
                }
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)obj;
                if (constructorDescriptor == null) {
                    return;
                }
                descriptor2 = constructorDescriptor;
                ClassDescriptor constructorOwner = descriptor2.getContainingDeclaration().getOriginal();
                scopeOwner = context.getScope().getOwnerDescriptor();
                if (Intrinsics.areEqual((Object)descriptor2.getVisibility().normalize(), (Object)Visibilities.PROTECTED) ^ true) {
                    return;
                }
                if (!Visibilities.isVisibleWithAnyReceiver(descriptor2, scopeOwner)) {
                    return;
                }
                Sequence<DeclarationDescriptor> calleeExpression = resolvedCall2.getCall().getCalleeExpression();
                Sequence<DeclarationDescriptor> sequence2 = calleeExpression;
                if (sequence2 instanceof KtConstructorCalleeExpression ? ((KtConstructorCalleeExpression)calleeExpression).getParent() instanceof KtSuperTypeCallEntry : sequence2 instanceof KtConstructorDelegationReferenceExpression) {
                    return;
                }
                sequence2 = DescriptorUtilsKt.getParentsWithSelf(scopeOwner);
                for (Object element$iv : $receiver$iv) {
                    DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                    if (!(it.getOriginal() == constructorOwner)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
            if (bl) {
                return;
            }
            if (!Intrinsics.areEqual((Object)Visibilities.findInvisibleMember(Visibilities.FALSE_IF_PROTECTED, descriptor2, scopeOwner), (Object)descriptor2)) break block8;
            context.getTrace().report(Errors.PROTECTED_CONSTRUCTOR_NOT_IN_SUPER_CALL.on(reportOn, descriptor2));
        }
    }

    private ProtectedConstructorCallChecker() {
        INSTANCE = this;
    }

    static {
        new ProtectedConstructorCallChecker();
    }
}

