/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aop.jam;

import com.intellij.aop.AopBundle;
import com.intellij.aop.LocalAopModel;
import com.intellij.aop.jam.AopAdviceImpl;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class AopAnnoParameterReference
extends PsiReferenceBase<PsiAnnotationMemberValue>
implements EmptyResolveMessageProvider {
    private final PsiMethod myMethod;

    public AopAnnoParameterReference(PsiLiteral element) {
        super((PsiElement)element);
        this.myMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
    }

    public final PsiElement resolve() {
        return AopAdviceImpl.findParameter(this.myMethod, this.getCanonicalText());
    }

    @NotNull
    public Object[] getVariants() {
        Object[] parameters = this.myMethod.getParameterList().getParameters();
        Object[] objectArray = parameters.length > 0 && LocalAopModel.isJoinPointParameter(parameters[0]) ? ArrayUtil.remove((Object[])parameters, (int)0) : parameters;
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopAnnoParameterReference", "getVariants"));
        }
        return objectArray;
    }

    @NotNull
    public final String getCanonicalText() {
        String string = StringUtil.notNullize((String)((String)JamCommonUtil.getObjectValue((PsiAnnotationMemberValue)((PsiAnnotationMemberValue)this.getElement()), String.class)));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopAnnoParameterReference", "getCanonicalText"));
        }
        return string;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = AopBundle.message("error.cannot.resolve.parameter", this.getCanonicalText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/aop/jam/AopAnnoParameterReference", "getUnresolvedMessagePattern"));
        }
        return string;
    }
}

