/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.inspections.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class BaseRemoveElementFix
implements LocalQuickFix {
    private final PsiElement element;

    public BaseRemoveElementFix(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ws/inspections/fixes/BaseRemoveElementFix", "<init>"));
        }
        this.element = element;
    }

    @NotNull
    public abstract String getName();

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/inspections/fixes/BaseRemoveElementFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ws/inspections/fixes/BaseRemoveElementFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/ws/inspections/fixes/BaseRemoveElementFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        if (psiElement == null) {
            return;
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(psiElement.getContainingFile())) {
            return;
        }
        try {
            this.element.delete();
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

