/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.agent.cloud;

import com.intellij.javaee.openshift.agent.cloud.OS3ApplicationPropertyGroupImpl;
import com.intellij.javaee.openshift.agent.cloud.OS3Context;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Application;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationProperty;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationPropertyGroup;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ApplicationPropertyImpl;
import com.openshift.restclient.model.IResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class OS3ApplicationBase
implements OS3Application {
    private final String myName;
    private final OS3ApplicationPropertyGroup[] myPropertyGroups;
    private final OS3Context myContext;

    public OS3ApplicationBase(IResource resource, OS3Context context, OS3ApplicationProperty[] specificProperties) {
        this.myContext = context;
        this.myName = resource.getName();
        ArrayList<OS3ApplicationProperty> generalProperties = new ArrayList<OS3ApplicationProperty>(Arrays.asList(OS3ApplicationBase.wrapCommon(resource)));
        generalProperties.addAll(Arrays.asList(specificProperties));
        this.myPropertyGroups = new OS3ApplicationPropertyGroup[]{new OS3ApplicationPropertyGroupImpl("General", generalProperties.toArray(new OS3ApplicationProperty[generalProperties.size()])), new OS3ApplicationPropertyGroupImpl("Labels", OS3ApplicationBase.wrapMap(resource.getLabels())), new OS3ApplicationPropertyGroupImpl("Annotations", OS3ApplicationBase.wrapMap(resource.getAnnotations()))};
    }

    protected final OS3Context getContext() {
        return this.myContext;
    }

    private static OS3ApplicationProperty[] wrapCommon(IResource resource) {
        return new OS3ApplicationProperty[]{new OS3ApplicationPropertyImpl("Name", resource.getName()), new OS3ApplicationPropertyImpl("Creation Timestamp", resource.getCreationTimeStamp()), new OS3ApplicationPropertyImpl("Namespace", resource.getNamespace()), new OS3ApplicationPropertyImpl("API version", resource.getApiVersion())};
    }

    private static OS3ApplicationProperty[] wrapMap(Map<String, String> os3Entities) {
        ArrayList<OS3ApplicationPropertyImpl> entities = new ArrayList<OS3ApplicationPropertyImpl>();
        for (Map.Entry<String, String> entry : os3Entities.entrySet()) {
            entities.add(new OS3ApplicationPropertyImpl(entry.getKey(), entry.getValue()));
        }
        return entities.toArray(new OS3ApplicationProperty[entities.size()]);
    }

    public String getName() {
        return this.myName;
    }

    public OS3ApplicationPropertyGroup[] getPropertyGroups() {
        return this.myPropertyGroups;
    }
}

